/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import prompto.config.IConfigurationReader;

public class CmdLineConfigurationReader
implements IConfigurationReader {
    Map<String, String> argsMap;

    public CmdLineConfigurationReader(Map<String, String> argsMap) {
        this.argsMap = argsMap;
    }

    public String toString() {
        return this.argsMap.toString();
    }

    @Override
    public boolean hasKey(String key) {
        return this.argsMap.containsKey(key);
    }

    @Override
    public Boolean getBoolean(String key) {
        String value = this.argsMap.get(key);
        return value == null ? null : Boolean.valueOf(value);
    }

    @Override
    public String getString(String key) {
        return this.argsMap.get(key);
    }

    @Override
    public Integer getInteger(String key) {
        String value = this.argsMap.get(key);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    @Override
    public <T> Collection<T> getArray(String key) {
        String value = this.argsMap.get(key);
        if (value == null) {
            return null;
        }
        return Arrays.asList(value.split(","));
    }

    @Override
    public IConfigurationReader getObject(String key) {
        String prefix = key + "-";
        Map<String, String> subMap = this.argsMap.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(prefix.length()), e -> (String)e.getValue()));
        return subMap.isEmpty() ? null : new CmdLineConfigurationReader(subMap);
    }

    public Collection<IConfigurationReader> getObjectsArray(String key) {
        throw new UnsupportedOperationException();
    }
}

