/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import java.util.Collection;
import prompto.config.IDebugEventAdapterConfiguration;
import prompto.config.IDebugRequestListenerConfiguration;
import prompto.config.IKeyStoreFactoryConfiguration;
import prompto.config.ISecretKeyConfiguration;
import prompto.config.IStoreConfiguration;
import prompto.config.SecretKeyConfiguration;
import prompto.config.StoreConfiguration;
import prompto.debug.IDebugEventAdapterFactory;
import prompto.debug.IDebugRequestListenerFactory;
import prompto.security.IKeyStoreFactory;
import prompto.security.ISecretKeyFactory;
import prompto.store.IStoreFactory;

public interface IConfigurationReader {
    public boolean hasKey(String var1);

    public Boolean getBoolean(String var1);

    default public boolean getBooleanOrDefault(String key, boolean value) {
        Boolean read = this.getBoolean(key);
        return read == null ? value : read;
    }

    public String getString(String var1);

    default public String getStringOrDefault(String key, String value) {
        String read = this.getString(key);
        return read == null ? value : read;
    }

    public Integer getInteger(String var1);

    default public int getIntegerOrDefault(String key, int value) {
        Integer read = this.getInteger(key);
        return read == null ? value : read;
    }

    public <T> Collection<T> getArray(String var1);

    public IConfigurationReader getObject(String var1);

    public Collection<? extends IConfigurationReader> getObjectsArray(String var1);

    default public IStoreConfiguration readStoreConfiguration(String key) {
        IConfigurationReader child = this.getObject(key);
        if (child == null) {
            return null;
        }
        return child.readStoreConfiguration();
    }

    default public IStoreConfiguration readStoreConfiguration() {
        String factoryName = this.getString("factory");
        if (factoryName == null) {
            return new StoreConfiguration(this);
        }
        try {
            Class<?> klass = Class.forName(factoryName);
            IStoreFactory factory = (IStoreFactory)klass.newInstance();
            return factory.newConfiguration(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public IKeyStoreFactoryConfiguration readKeyStoreFactoryConfiguration(String key) {
        IConfigurationReader child = this.getObject(key);
        if (child == null) {
            return null;
        }
        String factoryName = child.getString("factory");
        if (factoryName == null) {
            return null;
        }
        try {
            Class<?> klass = Class.forName(factoryName);
            IKeyStoreFactory factory = (IKeyStoreFactory)klass.newInstance();
            return factory.newConfiguration(child);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public ISecretKeyConfiguration readSecretKeyConfiguration(String key) {
        IConfigurationReader child = this.getObject(key);
        if (child == null) {
            return null;
        }
        String factoryName = child.getString("factory");
        if (factoryName == null) {
            return new SecretKeyConfiguration(child);
        }
        try {
            Class<?> klass = Class.forName(factoryName);
            ISecretKeyFactory factory = (ISecretKeyFactory)klass.newInstance();
            return factory.newConfiguration(child);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public IDebugEventAdapterConfiguration readDebugEventAdapterConfiguration(String key) {
        IConfigurationReader child = this.getObject(key);
        if (child == null) {
            return null;
        }
        String factoryName = child.getString("factory");
        if (factoryName == null) {
            return null;
        }
        try {
            Class<?> klass = Class.forName(factoryName);
            IDebugEventAdapterFactory factory = (IDebugEventAdapterFactory)klass.newInstance();
            return factory.newConfiguration(child);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public IDebugRequestListenerConfiguration readDebugRequestListenerConfiguration(String key) {
        IConfigurationReader child = this.getObject(key);
        if (child == null) {
            return null;
        }
        String factoryName = child.getString("factory");
        if (factoryName == null) {
            return null;
        }
        try {
            Class<?> klass = Class.forName(factoryName);
            IDebugRequestListenerFactory factory = (IDebugRequestListenerFactory)klass.newInstance();
            return factory.newConfiguration(child);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

