/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import com.esotericsoftware.yamlbeans.document.YamlSequence;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import prompto.config.IDebugConfiguration;
import prompto.config.IStoreConfiguration;
import prompto.intrinsic.PromptoVersion;
import prompto.runtime.Mode;

public interface IRuntimeConfiguration {
    public Supplier<Collection<URL>> getRuntimeLibs();

    public IStoreConfiguration getCodeStoreConfiguration();

    public IStoreConfiguration getDataStoreConfiguration();

    public IDebugConfiguration getDebugConfiguration();

    public Mode getRuntimeMode();

    public Map<String, String> getArguments();

    public String getApplicationName();

    public PromptoVersion getApplicationVersion();

    public URL[] getAddOnURLs();

    public URL[] getResourceURLs();

    public boolean isLoadRuntime();

    public YamlMapping toYaml() throws YamlException;

    public <T extends IRuntimeConfiguration> T withRuntimeLibs(Supplier<Collection<URL>> var1);

    public <T extends IRuntimeConfiguration> T withCodeStoreConfiguration(IStoreConfiguration var1);

    public <T extends IRuntimeConfiguration> T withDataStoreConfiguration(IStoreConfiguration var1);

    public <T extends IRuntimeConfiguration> T withAddOnURLs(URL[] var1);

    public <T extends IRuntimeConfiguration> T withApplicationName(String var1);

    public <T extends IRuntimeConfiguration> T withApplicationVersion(PromptoVersion var1);

    public <T extends IRuntimeConfiguration> T withResourceURLs(URL[] var1);

    public <T extends IRuntimeConfiguration> T withRuntimeMode(Mode var1);

    public <T extends IRuntimeConfiguration> T withLoadRuntime(boolean var1);

    public <T extends IRuntimeConfiguration> T withDebugConfiguration(IDebugConfiguration var1);

    public static class Inline
    implements IRuntimeConfiguration {
        Supplier<Collection<URL>> runtimeLibs = null;
        Supplier<Map<String, String>> arguments = () -> Collections.emptyMap();
        Supplier<IDebugConfiguration> debugConfiguration = () -> null;
        Supplier<IStoreConfiguration> codeStoreConfiguration = () -> null;
        Supplier<IStoreConfiguration> dataStoreConfiguration = () -> null;
        Supplier<Mode> runtimeMode = () -> Mode.PRODUCTION;
        Supplier<Boolean> loadRuntime = () -> true;
        Supplier<URL[]> addOnURLs = () -> null;
        Supplier<URL[]> resourceURLs = () -> null;
        Supplier<String> applicationName = () -> null;
        Supplier<PromptoVersion> applicationVersion = () -> null;

        @Override
        public Supplier<Collection<URL>> getRuntimeLibs() {
            return this.runtimeLibs;
        }

        @Override
        public IStoreConfiguration getCodeStoreConfiguration() {
            return this.codeStoreConfiguration.get();
        }

        @Override
        public IStoreConfiguration getDataStoreConfiguration() {
            return this.dataStoreConfiguration.get();
        }

        @Override
        public IDebugConfiguration getDebugConfiguration() {
            return this.debugConfiguration.get();
        }

        @Override
        public Map<String, String> getArguments() {
            return this.arguments.get();
        }

        @Override
        public String getApplicationName() {
            return this.applicationName.get();
        }

        @Override
        public PromptoVersion getApplicationVersion() {
            return this.applicationVersion.get();
        }

        @Override
        public Mode getRuntimeMode() {
            return this.runtimeMode.get();
        }

        @Override
        public URL[] getAddOnURLs() {
            return this.addOnURLs.get();
        }

        @Override
        public URL[] getResourceURLs() {
            return this.resourceURLs.get();
        }

        @Override
        public boolean isLoadRuntime() {
            return this.loadRuntime.get();
        }

        @Override
        public <T extends IRuntimeConfiguration> T withRuntimeLibs(Supplier<Collection<URL>> runtimeLibs) {
            this.runtimeLibs = runtimeLibs;
            return (T)this;
        }

        @Override
        public <T extends IRuntimeConfiguration> T withCodeStoreConfiguration(IStoreConfiguration storeConfig) {
            this.codeStoreConfiguration = () -> storeConfig;
            return (T)this;
        }

        @Override
        public <T extends IRuntimeConfiguration> T withDataStoreConfiguration(IStoreConfiguration storeConfig) {
            this.dataStoreConfiguration = () -> storeConfig;
            return (T)this;
        }

        @Override
        public <T extends IRuntimeConfiguration> T withAddOnURLs(URL[] urls) {
            this.addOnURLs = () -> urls;
            return (T)this;
        }

        @Override
        public <T extends IRuntimeConfiguration> T withApplicationName(String name) {
            this.applicationName = () -> name;
            return (T)this;
        }

        @Override
        public <T extends IRuntimeConfiguration> T withApplicationVersion(PromptoVersion version) {
            this.applicationVersion = () -> version;
            return (T)this;
        }

        @Override
        public <T extends IRuntimeConfiguration> T withResourceURLs(URL[] urls) {
            this.resourceURLs = () -> urls;
            return (T)this;
        }

        @Override
        public <T extends IRuntimeConfiguration> T withRuntimeMode(Mode mode) {
            this.runtimeMode = () -> mode;
            return (T)this;
        }

        @Override
        public <T extends IRuntimeConfiguration> T withLoadRuntime(boolean set) {
            this.loadRuntime = () -> set;
            return (T)this;
        }

        @Override
        public <T extends IRuntimeConfiguration> T withDebugConfiguration(IDebugConfiguration config) {
            this.debugConfiguration = () -> config;
            return (T)this;
        }

        @Override
        public YamlMapping toYaml() throws YamlException {
            YamlSequence sequence;
            URL[] urls;
            Mode mode;
            IStoreConfiguration config;
            YamlMapping yaml = new YamlMapping();
            String value = this.applicationName.get();
            if (value != null) {
                yaml.setEntry("applicationName", value);
            }
            if (this.applicationVersion.get() != null) {
                yaml.setEntry("applicationVersion", this.applicationVersion.get().toString());
            }
            if ((config = this.codeStoreConfiguration.get()) != null) {
                yaml.setEntry("codeStore", (YamlElement)config.toYaml());
            }
            if ((config = this.dataStoreConfiguration.get()) != null) {
                yaml.setEntry("dataStore", (YamlElement)config.toYaml());
            }
            if ((mode = this.runtimeMode.get()) != null) {
                yaml.setEntry("runtimeMode", mode.name());
            }
            if ((urls = this.addOnURLs.get()) != null) {
                sequence = new YamlSequence();
                for (URL url : urls) {
                    sequence.addElement(url.toExternalForm());
                }
                yaml.setEntry("addOnURLs", (YamlElement)sequence);
            }
            if ((urls = this.resourceURLs.get()) != null) {
                sequence = new YamlSequence();
                for (URL url : urls) {
                    sequence.addElement(url.toExternalForm());
                }
                yaml.setEntry("resourceURLs", (YamlElement)sequence);
            }
            return yaml;
        }
    }
}

