/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import java.util.function.Supplier;
import prompto.config.ISecretKeyConfiguration;
import prompto.store.NullStoreFactory;
import prompto.store.memory.MemStoreFactory;

public interface IStoreConfiguration {
    public static final IStoreConfiguration NULL_STORE_CONFIG = new IStoreConfiguration(){

        @Override
        public String getFactory() {
            return NullStoreFactory.class.getName();
        }

        @Override
        public String getHost() {
            return null;
        }

        @Override
        public Integer getPort() {
            return null;
        }

        @Override
        public String getDbName() {
            return null;
        }

        @Override
        public String getUser() {
            return null;
        }

        @Override
        public ISecretKeyConfiguration getSecretKeyConfiguration() {
            return null;
        }

        @Override
        public IStoreConfiguration withDbName(String dbName) {
            return this;
        }
    };
    public static final IStoreConfiguration MEM_STORE_CONFIG = new IStoreConfiguration(){

        @Override
        public String getFactory() {
            return MemStoreFactory.class.getName();
        }

        @Override
        public String getHost() {
            return null;
        }

        @Override
        public Integer getPort() {
            return null;
        }

        @Override
        public String getDbName() {
            return null;
        }

        @Override
        public String getUser() {
            return null;
        }

        @Override
        public ISecretKeyConfiguration getSecretKeyConfiguration() {
            return null;
        }

        @Override
        public IStoreConfiguration withDbName(String dbName) {
            return this;
        }
    };

    public String getFactory();

    public String getHost();

    public Integer getPort();

    public String getDbName();

    public String getUser();

    public ISecretKeyConfiguration getSecretKeyConfiguration();

    public IStoreConfiguration withDbName(String var1);

    default public YamlMapping toYaml() throws YamlException {
        YamlMapping mapping = new YamlMapping();
        mapping.setEntry("factory", this.getFactory());
        mapping.setEntry("host", this.getHost());
        mapping.setEntry("port", (Number)this.getPort());
        mapping.setEntry("dbName", this.getDbName());
        mapping.setEntry("user", this.getUser());
        mapping.setEntry("secretKey", (YamlElement)this.getSecretKeyConfiguration().toYaml());
        return mapping;
    }

    public static class Inline
    implements IStoreConfiguration {
        Supplier<String> factory = () -> null;
        Supplier<String> host = () -> null;
        protected Supplier<Integer> port = () -> null;
        Supplier<String> dbName = () -> null;
        Supplier<String> user = () -> null;
        Supplier<ISecretKeyConfiguration> secretKey = () -> null;

        @Override
        public String getFactory() {
            return this.factory.get();
        }

        @Override
        public String getHost() {
            return this.host.get();
        }

        @Override
        public Integer getPort() {
            return this.port.get();
        }

        @Override
        public String getDbName() {
            return this.dbName.get();
        }

        @Override
        public String getUser() {
            return this.user.get();
        }

        @Override
        public ISecretKeyConfiguration getSecretKeyConfiguration() {
            return this.secretKey.get();
        }

        @Override
        public IStoreConfiguration withDbName(String dbName) {
            this.dbName = () -> dbName;
            return this;
        }
    }
}

