/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import prompto.config.IConfigurationReader;
import prompto.store.IStore;
import prompto.store.IStored;
import prompto.utils.Logger;

public class StoredRecordConfigurationReader
implements IConfigurationReader {
    static final Logger logger = new Logger();
    IStore store;
    IStored stored;

    private static IStored fetchStored(IStore store, Object dbId) {
        IStored stored = store.fetchUnique(store.convertToDbId(dbId));
        if (stored == null) {
            logger.error(() -> "No record found with dbId: " + dbId.toString());
        }
        return stored;
    }

    public StoredRecordConfigurationReader(IStore store, Object dbId) {
        this(store, StoredRecordConfigurationReader.fetchStored(store, dbId));
    }

    public StoredRecordConfigurationReader(IStore store, IStored stored) {
        this.store = store;
        this.stored = stored;
    }

    @Override
    public boolean hasKey(String key) {
        return this.stored.hasData(key);
    }

    @Override
    public Boolean getBoolean(String key) {
        Object value = this.stored.getRawData(key);
        return value instanceof Boolean ? (Boolean)value : null;
    }

    @Override
    public String getString(String key) {
        Object value = this.stored.getRawData(key);
        return value == null ? null : value.toString();
    }

    @Override
    public Integer getInteger(String key) {
        Object value = this.stored.getRawData(key);
        return value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : null;
    }

    @Override
    public <T> Collection<T> getArray(String key) {
        Object value = this.stored.getRawData(key);
        return value instanceof Collection ? (Collection)value : null;
    }

    @Override
    public StoredRecordConfigurationReader getObject(String key) {
        Object value = this.stored.getRawData(key);
        if (value == null) {
            return null;
        }
        if (!this.store.getDbIdClass().isInstance(value)) {
            logger.warn(() -> "Not a valid dbId: " + value.toString());
            return null;
        }
        return new StoredRecordConfigurationReader(this.store, value);
    }

    public Collection<StoredRecordConfigurationReader> getObjectsArray(String key) {
        Object value = this.stored.getRawData(key);
        if (value == null) {
            return null;
        }
        if (!(value instanceof Collection)) {
            logger.warn(() -> "Not a collection: " + value.toString());
            return null;
        }
        ArrayList<StoredRecordConfigurationReader> readers = new ArrayList<StoredRecordConfigurationReader>();
        for (Object item : (Collection)value) {
            if (!this.store.getDbIdClass().isInstance(item)) {
                logger.warn(() -> "Not a valid dbId: " + value.toString());
                return null;
            }
            readers.add(new StoredRecordConfigurationReader(this.store, item));
        }
        return readers;
    }

    public String readCategory() {
        Object value = this.stored.getRawData("category");
        if (!(value instanceof List)) {
            logger.warn(() -> "Not a valid category list: " + value.toString());
            return null;
        }
        List list = (List)value;
        return (String)list.get(list.size() - 1);
    }
}

