/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import com.esotericsoftware.yamlbeans.YamlReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import prompto.config.IConfigurationReader;
import prompto.config.IStoreConfiguration;
import prompto.store.IStore;
import prompto.store.IStoreFactory;
import prompto.utils.Logger;

public class YamlConfigurationReader
implements IConfigurationReader {
    static Logger logger = new Logger();
    Map<String, Object> data;

    static Map<String, Object> parseYaml(InputStream input) {
        try {
            YamlReader reader = new YamlReader((Reader)new InputStreamReader(input));
            return (Map)reader.read(Map.class);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public YamlConfigurationReader(InputStream input) {
        this(YamlConfigurationReader.parseYaml(input));
    }

    public YamlConfigurationReader(Map<String, Object> data) {
        if (data.containsKey("<<")) {
            this.data = new HashMap<String, Object>();
            this.data.putAll((Map)data.get("<<"));
            this.data.putAll(data);
            this.data.remove("<<");
        } else {
            this.data = data;
        }
    }

    public String toString() {
        return this.data.toString();
    }

    @Override
    public boolean hasKey(String key) {
        return this.data.containsKey(key);
    }

    @Override
    public String getString(String key) {
        Object value = this.data.get(key);
        return value == null ? null : value.toString();
    }

    @Override
    public Boolean getBoolean(String key) {
        Object value = this.data.get(key);
        return value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value.toString()));
    }

    @Override
    public Integer getInteger(String key) {
        Object value = this.data.get(key);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value.toString()));
    }

    @Override
    public <T> Collection<T> getArray(String key) {
        Object value = this.data.get(key);
        if (value instanceof List) {
            return (List)value;
        }
        return null;
    }

    public Collection<IConfigurationReader> getObjectsArray(String key) {
        Object value = this.data.get(key);
        if (value instanceof List) {
            return ((List)value).stream().filter(o -> o instanceof Map).map(o -> (Map)o).map(m -> new YamlConfigurationReader((Map)m)).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public IConfigurationReader getObject(String key) {
        Object value = this.data.get(key);
        return value instanceof Map ? new YamlConfigurationReader((Map)value) : null;
    }

    public static boolean checkStoreConnection(String yamlConfig) {
        try {
            logger.info(() -> yamlConfig);
            YamlConfigurationReader reader = new YamlConfigurationReader(new ByteArrayInputStream(yamlConfig.getBytes()));
            IStoreConfiguration storeConfig = reader.readStoreConfiguration();
            IStore store = IStoreFactory.newStoreFromConfig(storeConfig);
            boolean valid = store.checkConnection();
            store.close();
            return valid;
        }
        catch (Throwable t) {
            logger.error(() -> "Failed to connect!", t);
            return false;
        }
    }
}

