/*
 * Decompiled with CFR 0.152.
 */
package prompto.constraint;

import java.lang.reflect.Type;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.OffsetListenerConstant;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackState;
import prompto.compiler.StringConstant;
import prompto.constraint.MatchingConstraintBase;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoException;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.store.InvalidValueError;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.IContainer;
import prompto.value.IValue;

public class MatchingCollectionConstraint
extends MatchingConstraintBase {
    IExpression collection;

    public MatchingCollectionConstraint(IExpression collection) {
        this.collection = collection;
    }

    @Override
    public void checkValue(Context context, IValue value) throws PromptoError {
        IValue container = this.collection.interpret(context);
        if (container instanceof IContainer) {
            if (!((IContainer)container).hasItem(context, value)) {
                throw new InvalidValueError(String.valueOf(value) + this.collectionToString());
            }
        } else {
            throw new InvalidValueError("Not a collection: " + this.collection.toString());
        }
    }

    private String collectionToString() {
        return " is not in collection: " + this.collection.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append(" in ");
        this.collection.toDialect(writer);
    }

    @Override
    public void compile(Context context, MethodInfo method, Flags flags) {
        ResultInfo info = this.collection.compile(context, method, flags.withPrimitive(true));
        CompilerUtils.compileALOAD(method, "value");
        MethodConstant m = new MethodConstant(info.getType(), "contains", new Type[]{Object.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        OffsetListenerConstant finalListener = method.addOffsetListener(new OffsetListenerConstant());
        method.activateOffsetListener(finalListener);
        method.addInstruction(Opcode.IFNE, finalListener);
        StackState finalState = method.captureStackState();
        method.addInstruction(Opcode.LDC, new StringConstant("INVALID_VALUE"));
        CompilerUtils.compileALOAD(method, "value");
        m = new MethodConstant((Type)((Object)String.class), "valueOf", new Type[]{Object.class, String.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        String message = " does not match:" + this.collectionToString();
        method.addInstruction(Opcode.LDC, new StringConstant(message));
        m = new MethodConstant((Type)((Object)String.class), "concat", new Type[]{String.class, String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        m = new MethodConstant((Type)((Object)PromptoException.class), "throwEnumeratedException", new Type[]{String.class, String.class, Void.TYPE});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        method.restoreFullStackState(finalState);
        method.placeLabel(finalState);
        method.inhibitOffsetListener(finalListener);
    }

    @Override
    public void declare(Transpiler transpiler, String name, IType type) {
        transpiler = transpiler.newChildTranspiler(null);
        Identifier id = new Identifier("value");
        transpiler.getContext().registerValue(new Variable(id, type));
        this.collection.declare(transpiler);
        this.transpileFunction = t -> this.transpileChecker(t, name, type);
        transpiler.declare(this);
        transpiler.require("StrictSet");
    }

    private boolean transpileChecker(Transpiler transpiler, String name, IType type) {
        transpiler.append("function $check_").append(name).append("(value) {").indent();
        transpiler = transpiler.newChildTranspiler(null);
        Identifier id = new Identifier("value");
        transpiler.getContext().registerValue(new Variable(id, type));
        transpiler.append("if(");
        this.collection.transpile(transpiler);
        transpiler.append(".has(value))").indent();
        transpiler.append("return value;").dedent();
        transpiler.append("else").indent();
        transpiler.append("throw new IllegalValueError((value == null ? 'null' : value.toString()) + ' is not in: \"").append(this.collection.toString()).append("\"');").dedent();
        transpiler.dedent().append("}").newLine();
        transpiler.flush();
        return true;
    }
}

