/*
 * Decompiled with CFR 0.152.
 */
package prompto.constraint;

import java.lang.reflect.Type;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.OffsetListenerConstant;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackState;
import prompto.compiler.StringConstant;
import prompto.constraint.MatchingConstraintBase;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoException;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.store.InvalidValueError;
import prompto.transpiler.Transpiler;
import prompto.type.AnyType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.BooleanValue;
import prompto.value.IValue;

public class MatchingExpressionConstraint
extends MatchingConstraintBase {
    IExpression expression;

    public MatchingExpressionConstraint(IExpression expression) {
        this.expression = expression;
    }

    @Override
    public void checkValue(Context context, IValue value) throws PromptoError {
        Context child = context.newChildContext();
        child.registerValue(new Variable(new Identifier("value"), AnyType.instance()));
        child.setValue(new Identifier("value"), value);
        IValue test = this.expression.interpret(child);
        if (!BooleanValue.TRUE.equals(test)) {
            throw new InvalidValueError(String.valueOf(value) + this.expressionToString(context));
        }
    }

    private String expressionToString(Context context) {
        CodeWriter cw = new CodeWriter(this.getDialect(), context);
        this.expression.toDialect(cw);
        return " does not match:" + cw.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append(" matching ");
        this.expression.toDialect(writer);
    }

    @Override
    public void compile(Context context, MethodInfo method, Flags flags) {
        Context child = context.newChildContext();
        child.registerValue(new Variable(new Identifier("value"), AnyType.instance()));
        ResultInfo info = this.expression.compile(child, method, flags.withPrimitive(true));
        if (BooleanValue.class == info.getType()) {
            CompilerUtils.BooleanToboolean(method);
        }
        OffsetListenerConstant finalListener = method.addOffsetListener(new OffsetListenerConstant());
        method.activateOffsetListener(finalListener);
        method.addInstruction(Opcode.IFNE, finalListener);
        StackState finalState = method.captureStackState();
        method.addInstruction(Opcode.LDC, new StringConstant("INVALID_VALUE"));
        CompilerUtils.compileALOAD(method, "value");
        MethodConstant m = new MethodConstant((Type)((Object)String.class), "valueOf", new Type[]{Object.class, String.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        method.addInstruction(Opcode.LDC, new StringConstant(this.expressionToString(context)));
        m = new MethodConstant((Type)((Object)String.class), "concat", new Type[]{String.class, String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        m = new MethodConstant((Type)((Object)PromptoException.class), "throwEnumeratedException", new Type[]{String.class, String.class, Void.TYPE});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        method.restoreFullStackState(finalState);
        method.placeLabel(finalState);
        method.inhibitOffsetListener(finalListener);
    }

    @Override
    public void declare(Transpiler transpiler, String name, IType type) {
        transpiler = transpiler.newChildTranspiler(null);
        Identifier id = new Identifier("value");
        transpiler.getContext().registerValue(new Variable(id, type));
        this.expression.declare(transpiler);
        this.transpileFunction = t -> this.transpileChecker(t, name, type);
        transpiler.declare(this);
    }

    private boolean transpileChecker(Transpiler transpiler, String name, IType type) {
        transpiler.append("function $check_").append(name).append("(value) {").indent();
        transpiler = transpiler.newChildTranspiler(null);
        Identifier id = new Identifier("value");
        transpiler.getContext().registerValue(new Variable(id, type));
        transpiler.append("if(");
        this.expression.transpile(transpiler);
        transpiler.append(")").indent();
        transpiler.append("return value;").dedent();
        transpiler.append("else").indent();
        transpiler.append("throw new IllegalValueError((value == null ? 'null' : value.toString()) + ' does not match: \"").append(this.expression.toString()).append("\"');").dedent();
        transpiler.dedent().append("}").newLine();
        transpiler.flush();
        return false;
    }
}

