/*
 * Decompiled with CFR 0.152.
 */
package prompto.constraint;

import java.lang.reflect.Type;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.OffsetListenerConstant;
import prompto.compiler.Opcode;
import prompto.compiler.StackState;
import prompto.compiler.StringConstant;
import prompto.constraint.MatchingConstraintBase;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoException;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.store.InvalidValueError;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public class MatchingPatternConstraint
extends MatchingConstraintBase {
    IExpression expression;
    Pattern pattern;

    public MatchingPatternConstraint(IExpression expression) {
        this.expression = expression;
    }

    @Override
    public void checkValue(Context context, IValue value) throws PromptoError {
        if (this.pattern == null) {
            IValue toMatch = this.expression.interpret(context);
            this.pattern = Pattern.compile(toMatch.toString());
        }
        if (!this.pattern.matcher(value.toString()).matches()) {
            throw new InvalidValueError(value.toString() + this.patternToString());
        }
    }

    private String patternToString() {
        return " does not match:" + this.expression.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append(" matching ");
        this.expression.toDialect(writer);
    }

    @Override
    public void compile(Context context, MethodInfo method, Flags flags) {
        this.expression.compile(context, method, flags);
        MethodConstant m = new MethodConstant((Type)((Object)String.class), "valueOf", new Type[]{Object.class, String.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        m = new MethodConstant((Type)((Object)Pattern.class), "compile", new Type[]{String.class, Pattern.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        CompilerUtils.compileALOAD(method, "value");
        m = new MethodConstant((Type)((Object)Pattern.class), "matcher", new Type[]{CharSequence.class, Matcher.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        m = new MethodConstant((Type)((Object)Matcher.class), "matches", Boolean.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        OffsetListenerConstant finalListener = method.addOffsetListener(new OffsetListenerConstant());
        method.activateOffsetListener(finalListener);
        method.addInstruction(Opcode.IFNE, finalListener);
        StackState finalState = method.captureStackState();
        method.addInstruction(Opcode.LDC, new StringConstant("INVALID_VALUE"));
        CompilerUtils.compileALOAD(method, "value");
        m = new MethodConstant((Type)((Object)String.class), "valueOf", new Type[]{Object.class, String.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        method.addInstruction(Opcode.LDC, new StringConstant(this.patternToString()));
        m = new MethodConstant((Type)((Object)String.class), "concat", new Type[]{String.class, String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        m = new MethodConstant((Type)((Object)PromptoException.class), "throwEnumeratedException", new Type[]{String.class, String.class, Void.TYPE});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        method.restoreFullStackState(finalState);
        method.placeLabel(finalState);
        method.inhibitOffsetListener(finalListener);
    }

    @Override
    public void declare(Transpiler transpiler, String name, IType type) {
        transpiler = transpiler.newChildTranspiler(null);
        Identifier id = new Identifier("value");
        transpiler.getContext().registerValue(new Variable(id, type));
        this.expression.declare(transpiler);
        this.transpileFunction = t -> this.transpileChecker(t, name, type);
        transpiler.declare(this);
    }

    private boolean transpileChecker(Transpiler transpiler, String name, IType type) {
        transpiler.append("function $check_").append(name).append("(value) {").indent();
        transpiler = transpiler.newChildTranspiler(null);
        Identifier id = new Identifier("value");
        transpiler.getContext().registerValue(new Variable(id, type));
        transpiler.append("if(new RegExp(");
        this.expression.transpile(transpiler);
        transpiler.append(").test(value))").indent();
        transpiler.append("return value;").dedent();
        transpiler.append("else").indent();
        transpiler.append("throw new IllegalValueError((value == null ? 'null' : value.toString()) + ' does not match: ").append(this.expression.toString()).append("');").dedent();
        transpiler.dedent().append("}").newLine();
        transpiler.flush();
        return false;
    }
}

