/*
 * Decompiled with CFR 0.152.
 */
package prompto.csharp;

import prompto.csharp.CSharpExpression;
import prompto.utils.CodeWriter;

public class CSharpIdentifierExpression
implements CSharpExpression {
    CSharpIdentifierExpression parent;
    String identifier;

    public static CSharpIdentifierExpression parse(String ids) {
        String[] parts = ids.split("\\.");
        CSharpIdentifierExpression result = null;
        for (String part : parts) {
            result = new CSharpIdentifierExpression(result, part);
        }
        return result;
    }

    public CSharpIdentifierExpression(String identifier) {
        this.identifier = identifier;
    }

    public CSharpIdentifierExpression(CSharpIdentifierExpression parent, String identifier) {
        this.parent = parent;
        this.identifier = identifier;
    }

    public CSharpIdentifierExpression getParent() {
        return this.parent;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        if (this.parent == null) {
            return this.identifier;
        }
        return this.parent.toString() + "." + this.identifier;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (this.parent != null) {
            this.parent.toDialect(writer);
            writer.append('.');
        }
        writer.append(this.identifier);
    }
}

