/*
 * Decompiled with CFR 0.152.
 */
package prompto.css;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import prompto.css.ICssValue;
import prompto.transpiler.Transpiler;
import prompto.type.TextType;
import prompto.utils.CodeWriter;

public class CssField {
    String name;
    ICssValue value;

    public CssField(String name, ICssValue value) {
        this.name = name;
        this.value = value;
    }

    public void toDialect(CodeWriter writer) {
        writer.append(this.name).append(":");
        this.value.toDialect(writer);
        writer.append(";");
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name).append(": ");
        this.value.toString(sb);
        sb.append("; ");
    }

    public void toJson(ObjectNode result, boolean withType) {
        if (withType) {
            ObjectNode value = JsonNodeFactory.instance.objectNode();
            value.put("typeName", TextType.instance().toString());
            value.put("value", this.value.toString());
            result.set(this.name, (JsonNode)value);
        } else {
            result.put(this.name, this.value.toString());
        }
    }

    public void declare(Transpiler transpiler) {
        this.value.declare(transpiler);
    }

    public void transpile(Transpiler transpiler) {
        transpiler.append("'").append(this.name).append("':");
        this.value.transpile(transpiler);
    }
}

