/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import java.io.InputStream;
import java.io.OutputStream;
import prompto.debug.IAcknowledgement;
import prompto.debug.IDebugEvent;
import prompto.debug.IDebugEventAdapter;
import prompto.debug.IWorker;
import prompto.debug.ResumeReason;
import prompto.debug.Serializer;
import prompto.debug.SuspendReason;
import prompto.utils.Logger;

public abstract class DebugEventAdapterBase
implements IDebugEventAdapter {
    static Logger logger = new Logger();

    @Override
    public void handleConnectedEvent(IDebugEvent.Connected event) {
        this.send(event);
    }

    @Override
    public void handleReadyEvent() {
        this.send(new IDebugEvent.Ready());
    }

    @Override
    public void handleStartedEvent(IWorker worker) {
        this.send(new IDebugEvent.Started(worker));
    }

    @Override
    public void handleSuspendedEvent(IWorker worker, SuspendReason reason) {
        this.send(new IDebugEvent.Suspended(worker, reason));
    }

    @Override
    public void handleResumedEvent(IWorker worker, ResumeReason reason) {
        this.send(new IDebugEvent.Resumed(worker, reason));
    }

    @Override
    public void handleCompletedEvent(IWorker worker) {
        this.send(new IDebugEvent.Completed(worker));
    }

    @Override
    public void handleTerminatedEvent() {
        this.send(new IDebugEvent.Terminated());
    }

    protected abstract IAcknowledgement send(IDebugEvent var1);

    protected void sendDebugEvent(OutputStream output, IDebugEvent event) throws Exception {
        Serializer.writeDebugEvent(output, event);
    }

    protected IAcknowledgement readAcknowledgement(InputStream input) throws Exception {
        return Serializer.readAcknowledgement(input);
    }
}

