/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import com.fasterxml.jackson.annotation.JsonIgnore;
import prompto.debug.IDebugEventListener;
import prompto.debug.IWorker;
import prompto.debug.ProcessDebugger;
import prompto.debug.ResumeReason;
import prompto.debug.SuspendReason;

public interface IDebugEvent {
    @JsonIgnore
    public Type getType();

    public void execute(IDebugEventListener var1);

    public static enum Type {
        CONNECTED(Connected.class),
        READY(Ready.class),
        STARTED(Started.class),
        SUSPENDED(Suspended.class),
        RESUMED(Resumed.class),
        COMPLETED(Completed.class),
        TERMINATED(Terminated.class);

        Class<? extends IDebugEvent> klass;

        private Type(Class<? extends IDebugEvent> klass) {
            this.klass = klass;
        }

        public Class<? extends IDebugEvent> getKlass() {
            return this.klass;
        }
    }

    public static class Terminated
    implements IDebugEvent {
        @Override
        public Type getType() {
            return Type.TERMINATED;
        }

        @Override
        public void execute(IDebugEventListener listener) {
            listener.handleTerminatedEvent();
        }
    }

    public static class Completed
    extends WorkerEvent {
        public Completed() {
        }

        public Completed(IWorker worker) {
            super(worker);
        }

        @Override
        public Type getType() {
            return Type.COMPLETED;
        }

        @Override
        public void execute(IDebugEventListener listener) {
            IWorker worker = ProcessDebugger.DebuggedWorker.parse(this.workerId);
            listener.handleStartedEvent(worker);
        }
    }

    public static class Resumed
    extends WorkerEvent {
        ResumeReason reason;

        public Resumed() {
        }

        public Resumed(IWorker worker, ResumeReason reason) {
            super(worker);
            this.reason = reason;
        }

        public void setReason(ResumeReason reason) {
            this.reason = reason;
        }

        public ResumeReason getReason() {
            return this.reason;
        }

        @Override
        public Type getType() {
            return Type.RESUMED;
        }

        @Override
        public void execute(IDebugEventListener listener) {
            IWorker worker = ProcessDebugger.DebuggedWorker.parse(this.workerId);
            listener.handleResumedEvent(worker, this.reason);
        }
    }

    public static class Suspended
    extends WorkerEvent {
        SuspendReason reason;

        public Suspended() {
        }

        public Suspended(IWorker worker, SuspendReason reason) {
            super(worker);
            this.reason = reason;
        }

        public void setReason(SuspendReason reason) {
            this.reason = reason;
        }

        public SuspendReason getReason() {
            return this.reason;
        }

        @Override
        public Type getType() {
            return Type.SUSPENDED;
        }

        @Override
        public void execute(IDebugEventListener listener) {
            IWorker worker = ProcessDebugger.DebuggedWorker.parse(this.workerId);
            listener.handleSuspendedEvent(worker, this.reason);
        }
    }

    public static class Started
    extends WorkerEvent {
        String name;
        IWorker.State state;

        public Started() {
        }

        public Started(IWorker worker) {
            super(worker);
            this.name = worker.getName();
            this.state = worker.getState();
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setState(IWorker.State state) {
            this.state = state;
        }

        public IWorker.State getState() {
            return this.state;
        }

        @Override
        public Type getType() {
            return Type.STARTED;
        }

        @Override
        public void execute(IDebugEventListener listener) {
            IWorker worker = ProcessDebugger.DebuggedWorker.parse(this.workerId);
            listener.handleStartedEvent(worker);
        }
    }

    public static abstract class WorkerEvent
    implements IDebugEvent {
        String workerId;

        WorkerEvent() {
        }

        WorkerEvent(IWorker worker) {
            this.workerId = worker.getWorkerId();
        }

        public void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        public String getWorkerId() {
            return this.workerId;
        }
    }

    public static class Ready
    implements IDebugEvent {
        @Override
        public Type getType() {
            return Type.READY;
        }

        @Override
        public void execute(IDebugEventListener listener) {
            listener.handleReadyEvent();
        }
    }

    public static class Connected
    implements IDebugEvent {
        String host;
        int port;

        public Connected() {
        }

        public Connected(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        @Override
        public Type getType() {
            return Type.CONNECTED;
        }

        @Override
        public void execute(IDebugEventListener listener) {
            listener.handleConnectedEvent(this);
        }
    }
}

