/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import prompto.config.IConfigurationReader;
import prompto.config.IDebugEventAdapterConfiguration;
import prompto.debug.IDebugEventAdapter;

public interface IDebugEventAdapterFactory {
    public IDebugEventAdapter newAdapter(IDebugEventAdapterConfiguration var1);

    public IDebugEventAdapterConfiguration newConfiguration(IConfigurationReader var1);

    public static IDebugEventAdapter newAdapterFromConfig(IDebugEventAdapterConfiguration cfg) throws Throwable {
        IDebugEventAdapterFactory factory = IDebugEventAdapterFactory.newAdapterFactory(cfg.getFactory());
        return factory.newAdapter(cfg);
    }

    public static IDebugEventAdapterFactory newAdapterFactory(String factoryName) throws Throwable {
        Class<?> klass = Class.forName(factoryName, true, Thread.currentThread().getContextClassLoader());
        if (!IDebugEventAdapterFactory.class.isAssignableFrom(klass)) {
            throw new RuntimeException("Not an adapter factory: " + factoryName);
        }
        return (IDebugEventAdapterFactory)klass.newInstance();
    }
}

