/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import prompto.debug.IDebugResponse;
import prompto.debug.IDebugger;
import prompto.debug.IStack;
import prompto.debug.IStackFrame;
import prompto.debug.IVariable;
import prompto.debug.IWorker;
import prompto.debug.LeanStackFrame;
import prompto.debug.ProcessDebugger;
import prompto.debug.Status;
import prompto.parser.ISection;
import prompto.parser.Section;
import prompto.utils.Logger;

public interface IDebugRequest {
    public static final Logger logger = new Logger();

    @JsonIgnore
    public Type getType();

    public IDebugResponse execute(IDebugger var1);

    public static enum Type {
        GET_WORKERS(GetWorkersRequest.class),
        GET_PROCESS_STATUS(GetProcessStatusRequest.class),
        GET_WORKER_STATUS(GetWorkerStatusRequest.class),
        GET_LINE(GetLineRequest.class),
        GET_STACK(GetStackRequest.class),
        GET_VARIABLES(GetVariablesRequest.class),
        GET_VARIABLE(GetVariableRequest.class),
        INSTALL_BREAKPOINT(InstallBreakpointRequest.class),
        SUSPEND(SuspendRequest.class),
        RESUME(ResumeRequest.class),
        TERMINATE(TerminateRequest.class),
        IS_STEPPING(IsSteppingRequest.class),
        STEP_INTO(StepIntoRequest.class),
        STEP_OUT(StepOutRequest.class),
        STEP_OVER(StepOverRequest.class);

        Class<? extends IDebugRequest> klass;

        private Type(Class<? extends IDebugRequest> klass) {
            this.klass = klass;
        }

        public Class<? extends IDebugRequest> getKlass() {
            return this.klass;
        }
    }

    public static class StepOutRequest
    extends WorkerRequest {
        public StepOutRequest() {
        }

        public StepOutRequest(IWorker worker) {
            super(worker);
        }

        @Override
        public IDebugResponse.VoidResponse execute(IDebugger debugger) {
            logger.debug(() -> "before step out");
            debugger.stepOut(ProcessDebugger.DebuggedWorker.parse(this.workerId));
            logger.debug(() -> "after step out");
            return new IDebugResponse.VoidResponse();
        }

        @Override
        public Type getType() {
            return Type.STEP_OUT;
        }
    }

    public static class StepIntoRequest
    extends WorkerRequest {
        public StepIntoRequest() {
        }

        public StepIntoRequest(IWorker worker) {
            super(worker);
        }

        @Override
        public IDebugResponse.VoidResponse execute(IDebugger debugger) {
            logger.debug(() -> "before step into");
            debugger.stepInto(ProcessDebugger.DebuggedWorker.parse(this.workerId));
            logger.debug(() -> "after step into");
            return new IDebugResponse.VoidResponse();
        }

        @Override
        public Type getType() {
            return Type.STEP_INTO;
        }
    }

    public static class StepOverRequest
    extends WorkerRequest {
        public StepOverRequest() {
        }

        public StepOverRequest(IWorker worker) {
            super(worker);
        }

        @Override
        public IDebugResponse.VoidResponse execute(IDebugger debugger) {
            logger.debug(() -> "before step over");
            debugger.stepOver(ProcessDebugger.DebuggedWorker.parse(this.workerId));
            logger.debug(() -> "after step over");
            return new IDebugResponse.VoidResponse();
        }

        @Override
        public Type getType() {
            return Type.STEP_OVER;
        }
    }

    public static class IsSteppingRequest
    extends WorkerRequest {
        public IsSteppingRequest() {
        }

        public IsSteppingRequest(IWorker worker) {
            super(worker);
        }

        @Override
        public IDebugResponse.IsSteppingResponse execute(IDebugger debugger) {
            logger.debug(() -> "before is stepping");
            boolean stepping = debugger.isStepping(ProcessDebugger.DebuggedWorker.parse(this.workerId));
            logger.debug(() -> "after is stepping");
            return new IDebugResponse.IsSteppingResponse(stepping);
        }

        @Override
        public Type getType() {
            return Type.IS_STEPPING;
        }
    }

    public static class TerminateRequest
    extends WorkerRequest {
        public TerminateRequest() {
        }

        public TerminateRequest(IWorker worker) {
            super(worker);
        }

        @Override
        public IDebugResponse.VoidResponse execute(IDebugger debugger) {
            logger.debug(() -> "before terminate");
            debugger.terminate(ProcessDebugger.DebuggedWorker.parse(this.workerId));
            logger.debug(() -> "after terminate");
            return new IDebugResponse.VoidResponse();
        }

        @Override
        public Type getType() {
            return Type.TERMINATE;
        }
    }

    public static class ResumeRequest
    extends WorkerRequest {
        public ResumeRequest() {
        }

        public ResumeRequest(IWorker worker) {
            super(worker);
        }

        @Override
        public IDebugResponse.VoidResponse execute(IDebugger debugger) {
            logger.debug(() -> "before resume");
            debugger.resume(ProcessDebugger.DebuggedWorker.parse(this.workerId));
            logger.debug(() -> "after resume");
            return new IDebugResponse.VoidResponse();
        }

        @Override
        public Type getType() {
            return Type.RESUME;
        }
    }

    public static class SuspendRequest
    extends WorkerRequest {
        public SuspendRequest() {
        }

        public SuspendRequest(IWorker worker) {
            super(worker);
        }

        @Override
        public IDebugResponse.VoidResponse execute(IDebugger debugger) {
            logger.debug(() -> "before suspend");
            debugger.suspend(ProcessDebugger.DebuggedWorker.parse(this.workerId));
            logger.debug(() -> "after suspend");
            return new IDebugResponse.VoidResponse();
        }

        @Override
        public Type getType() {
            return Type.SUSPEND;
        }
    }

    public static class InstallBreakpointRequest
    implements IDebugRequest {
        Section section;

        public InstallBreakpointRequest() {
        }

        public InstallBreakpointRequest(ISection section) {
            this.section = section.getClass() == Section.class ? (Section)section : new Section(section);
        }

        public Section getSection() {
            return this.section;
        }

        public void setSection(Section section) {
            this.section = section;
        }

        @Override
        public IDebugResponse execute(IDebugger debugger) {
            debugger.installBreakpoint(this.section);
            return new IDebugResponse.VoidResponse();
        }

        @Override
        public Type getType() {
            return Type.INSTALL_BREAKPOINT;
        }
    }

    public static class GetVariableRequest
    extends WorkerRequest {
        LeanStackFrame stackFrame;
        String variableName;

        public GetVariableRequest() {
        }

        public GetVariableRequest(IWorker worker, IStackFrame stackFrame, String variableName) {
            super(worker);
            this.stackFrame = new LeanStackFrame(stackFrame);
            this.variableName = variableName;
        }

        public void setStackFrame(LeanStackFrame stackFrame) {
            this.stackFrame = stackFrame;
        }

        public LeanStackFrame getStackFrame() {
            return this.stackFrame;
        }

        public void setVariableName(String variableName) {
            this.variableName = variableName;
        }

        public String getVariableName() {
            return this.variableName;
        }

        @Override
        public IDebugResponse.GetVariableResponse execute(IDebugger debugger) {
            logger.debug(() -> "before variable");
            IVariable variable = debugger.getVariable(ProcessDebugger.DebuggedWorker.parse(this.workerId), this.stackFrame, this.variableName);
            logger.debug(() -> "after variables");
            return new IDebugResponse.GetVariableResponse(variable);
        }

        @Override
        public Type getType() {
            return Type.GET_VARIABLE;
        }
    }

    public static class GetVariablesRequest
    extends WorkerRequest {
        LeanStackFrame stackFrame;

        public GetVariablesRequest() {
        }

        public GetVariablesRequest(IWorker worker, IStackFrame stackFrame) {
            super(worker);
            this.stackFrame = new LeanStackFrame(stackFrame);
        }

        public void setStackFrame(LeanStackFrame stackFrame) {
            this.stackFrame = stackFrame;
        }

        public LeanStackFrame getStackFrame() {
            return this.stackFrame;
        }

        @Override
        public IDebugResponse.GetVariablesResponse execute(IDebugger debugger) {
            logger.debug(() -> "before variables");
            Collection<? extends IVariable> variables = debugger.getVariables(ProcessDebugger.DebuggedWorker.parse(this.workerId), this.stackFrame);
            logger.debug(() -> "after variables");
            return new IDebugResponse.GetVariablesResponse(variables);
        }

        @Override
        public Type getType() {
            return Type.GET_VARIABLES;
        }
    }

    public static class GetStackRequest
    extends WorkerRequest {
        public GetStackRequest() {
        }

        public GetStackRequest(IWorker worker) {
            super(worker);
        }

        @Override
        public IDebugResponse.GetStackResponse execute(IDebugger debugger) {
            logger.debug(() -> "before stack");
            IStack<?> stack = debugger.getStack(ProcessDebugger.DebuggedWorker.parse(this.workerId));
            logger.debug(() -> "after stack");
            return new IDebugResponse.GetStackResponse(stack);
        }

        @Override
        public Type getType() {
            return Type.GET_STACK;
        }
    }

    public static class GetLineRequest
    extends WorkerRequest {
        public GetLineRequest() {
        }

        public GetLineRequest(IWorker worker) {
            super(worker);
        }

        @Override
        public IDebugResponse.GetLineResponse execute(IDebugger debugger) {
            logger.debug(() -> "before line");
            IWorker worker = ProcessDebugger.DebuggedWorker.parse(this.workerId);
            int lineInFile = debugger.getLineInFile(worker);
            int lineInMethod = debugger.getLineInMethod(worker);
            logger.debug(() -> "after line:" + lineInFile + ", " + lineInMethod);
            return new IDebugResponse.GetLineResponse(lineInFile, lineInMethod);
        }

        @Override
        public Type getType() {
            return Type.GET_LINE;
        }
    }

    public static class GetWorkerStatusRequest
    extends WorkerRequest {
        public GetWorkerStatusRequest() {
        }

        public GetWorkerStatusRequest(IWorker worker) {
            super(worker);
        }

        @Override
        public IDebugResponse.GetStatusResponse execute(IDebugger debugger) {
            Status status = debugger.getWorkerStatus(ProcessDebugger.DebuggedWorker.parse(this.workerId));
            return new IDebugResponse.GetStatusResponse(status);
        }

        @Override
        public Type getType() {
            return Type.GET_WORKER_STATUS;
        }
    }

    public static abstract class WorkerRequest
    implements IDebugRequest {
        String workerId;

        WorkerRequest() {
        }

        WorkerRequest(IWorker worker) {
            this.workerId = worker.getWorkerId();
        }

        public String getWorkerId() {
            return this.workerId;
        }

        public void setWorkerId(String workerId) {
            this.workerId = workerId;
        }
    }

    public static class GetProcessStatusRequest
    implements IDebugRequest {
        @Override
        public IDebugResponse.GetStatusResponse execute(IDebugger debugger) {
            Status status = debugger.getProcessStatus();
            return new IDebugResponse.GetStatusResponse(status);
        }

        @Override
        public Type getType() {
            return Type.GET_PROCESS_STATUS;
        }
    }

    public static class GetWorkersRequest
    implements IDebugRequest {
        @Override
        public IDebugResponse.GetWorkersResponse execute(IDebugger debugger) {
            Collection<? extends IWorker> workers = debugger.getWorkers();
            return new IDebugResponse.GetWorkersResponse(workers);
        }

        @Override
        public Type getType() {
            return Type.GET_WORKERS;
        }
    }
}

