/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import prompto.config.IConfigurationReader;
import prompto.config.IDebugRequestListenerConfiguration;
import prompto.debug.IDebugRequestListener;
import prompto.debug.IDebugger;

public interface IDebugRequestListenerFactory {
    public IDebugRequestListener newListener(IDebugRequestListenerConfiguration var1, IDebugger var2);

    public IDebugRequestListenerConfiguration newConfiguration(IConfigurationReader var1);

    public static IDebugRequestListener newListenerFromConfig(IDebugRequestListenerConfiguration cfg, IDebugger debugger) throws Throwable {
        IDebugRequestListenerFactory factory = IDebugRequestListenerFactory.newListenerFactory(cfg.getFactory());
        return factory.newListener(cfg, debugger);
    }

    public static IDebugRequestListenerFactory newListenerFactory(String factoryName) throws Throwable {
        Class<?> klass = Class.forName(factoryName, true, Thread.currentThread().getContextClassLoader());
        if (!IDebugRequestListenerFactory.class.isAssignableFrom(klass)) {
            throw new RuntimeException("Not a listener factory: " + factoryName);
        }
        return (IDebugRequestListenerFactory)klass.newInstance();
    }
}

