/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import prompto.debug.FatVariable;
import prompto.debug.IStack;
import prompto.debug.IVariable;
import prompto.debug.IWorker;
import prompto.debug.LeanStack;
import prompto.debug.LeanVariable;
import prompto.debug.LeanVariableList;
import prompto.debug.Status;

public interface IDebugResponse {
    @JsonIgnore
    public Type getType();

    public static enum Type {
        VOID(VoidResponse.class),
        GET_WORKERS(GetWorkersResponse.class),
        GET_STATUS(GetStatusResponse.class),
        GET_LINE(GetLineResponse.class),
        GET_STACK(GetStackResponse.class),
        GET_VARIABLES(GetVariablesResponse.class),
        GET_VARIABLE(GetVariableResponse.class),
        IS_STEPPING(IsSteppingResponse.class);

        Class<? extends IDebugResponse> klass;

        private Type(Class<? extends IDebugResponse> klass) {
            this.klass = klass;
        }

        public Class<? extends IDebugResponse> getKlass() {
            return this.klass;
        }
    }

    public static class IsSteppingResponse
    implements IDebugResponse {
        boolean stepping;

        public IsSteppingResponse() {
        }

        public IsSteppingResponse(boolean stepping) {
            this.stepping = stepping;
        }

        @Override
        public Type getType() {
            return Type.IS_STEPPING;
        }

        public boolean isStepping() {
            return this.stepping;
        }

        public void setStepping(boolean stepping) {
            this.stepping = stepping;
        }
    }

    public static class GetVariableResponse
    implements IDebugResponse {
        FatVariable variable;

        public GetVariableResponse() {
        }

        public GetVariableResponse(IVariable variable) {
            this.variable = new FatVariable(variable);
        }

        @Override
        public Type getType() {
            return Type.GET_VARIABLE;
        }

        public FatVariable getVariable() {
            return this.variable;
        }

        public void setVariable(FatVariable variable) {
            this.variable = variable;
        }
    }

    public static class GetVariablesResponse
    implements IDebugResponse {
        LeanVariableList variables = new LeanVariableList();

        public GetVariablesResponse() {
        }

        public GetVariablesResponse(Collection<? extends IVariable> variables) {
            this.variables.addAll(variables.stream().map(LeanVariable::new).collect(Collectors.toList()));
        }

        @Override
        public Type getType() {
            return Type.GET_VARIABLES;
        }

        public LeanVariableList getVariables() {
            return this.variables;
        }

        public void setVariables(LeanVariableList variables) {
            this.variables = variables;
        }
    }

    public static class GetStackResponse
    implements IDebugResponse {
        LeanStack stack;

        public GetStackResponse() {
            this.stack = new LeanStack();
        }

        public GetStackResponse(IStack<?> stack) {
            this.stack = new LeanStack(stack);
        }

        @Override
        public Type getType() {
            return Type.GET_STACK;
        }

        public LeanStack getStack() {
            return this.stack;
        }

        public void setStack(LeanStack stack) {
            this.stack = stack;
        }
    }

    public static class GetLineResponse
    implements IDebugResponse {
        int lineInFile;
        int lineInMethod;

        public GetLineResponse() {
        }

        public GetLineResponse(int lineInFile, int lineInMethod) {
            this.lineInFile = lineInFile;
            this.lineInMethod = lineInMethod;
        }

        @Override
        public Type getType() {
            return Type.GET_LINE;
        }

        public int getLineInFile() {
            return this.lineInFile;
        }

        public void setLineInFile(int lineInFile) {
            this.lineInFile = lineInFile;
        }

        public int getLineInMethod() {
            return this.lineInMethod;
        }

        public void setLineInMethod(int lineInMethod) {
            this.lineInMethod = lineInMethod;
        }
    }

    public static class GetStatusResponse
    implements IDebugResponse {
        Status status;

        public GetStatusResponse() {
        }

        public GetStatusResponse(Status status) {
            this.status = status;
        }

        @Override
        public Type getType() {
            return Type.GET_STATUS;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }
    }

    public static class GetWorkersResponse
    implements IDebugResponse {
        List<IWorker> workers;

        public GetWorkersResponse() {
        }

        public GetWorkersResponse(Collection<? extends IWorker> workers) {
            this.workers = new ArrayList<IWorker>(workers);
        }

        @Override
        public Type getType() {
            return Type.GET_WORKERS;
        }

        public List<IWorker> getWorkers() {
            return this.workers;
        }

        public void setWorkers(List<IWorker> workers) {
            this.workers = workers;
        }
    }

    public static class VoidResponse
    implements IDebugResponse {
        @Override
        public Type getType() {
            return Type.VOID;
        }
    }
}

