/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

public interface IWorker {
    public String getWorkerId();

    public String getName();

    public State getState();

    public static enum State {
        STARTING,
        RUNNING,
        STEPPING,
        WAITING,
        COMPLETED;


        public static State valueOf(Thread.State state) {
            switch (state) {
                case NEW: {
                    return STARTING;
                }
                case RUNNABLE: {
                    return RUNNING;
                }
                case BLOCKED: {
                    return STEPPING;
                }
                case WAITING: 
                case TIMED_WAITING: {
                    return WAITING;
                }
                case TERMINATED: {
                    return COMPLETED;
                }
            }
            throw new IllegalArgumentException(state.name());
        }
    }
}

