/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import prompto.debug.IDebugEvent;
import prompto.debug.IDebugRequest;
import prompto.debug.IDebugRequestListener;
import prompto.debug.IDebugResponse;
import prompto.debug.IDebugger;
import prompto.debug.Serializer;
import prompto.utils.Logger;

public class JavaDebugRequestListener
implements IDebugRequestListener {
    private static Logger logger = new Logger();
    IDebugger debugger;
    Thread thread;
    int port;
    boolean loop;

    public JavaDebugRequestListener(IDebugger debugger) {
        this.debugger = debugger;
    }

    public Thread getThread() {
        return this.thread;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDebugEvent.Connected startListening() throws Exception {
        Object lock = new Object();
        this.thread = new Thread(() -> {
            try (ServerSocket server = new ServerSocket(0);){
                server.setSoTimeout(10);
                this.port = server.getLocalPort();
                logger.debug(() -> "DebugRequestServer listening on " + this.port);
                Object object2 = lock;
                synchronized (object2) {
                    lock.notify();
                }
                this.loop = true;
                logger.debug(() -> "DebugRequestServer entering loop");
                while (this.loop) {
                    try {
                        Socket client = server.accept();
                        this.handleMessage(client);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {}
                }
                logger.debug(() -> "DebugRequestServer exiting loop");
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }, "Prompto debug server");
        this.thread.start();
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return new IDebugEvent.Connected("localhost", this.port);
    }

    @Override
    public void stopListening() {
        this.loop = false;
        if (this.thread != Thread.currentThread()) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(Socket client) throws Exception {
        JavaDebugRequestListener javaDebugRequestListener = this;
        synchronized (javaDebugRequestListener) {
            InputStream input = client.getInputStream();
            OutputStream output = client.getOutputStream();
            IDebugRequest request = this.readRequest(input);
            logger.debug(() -> "DebugRequestServer receives " + (Object)((Object)request.getType()));
            IDebugResponse response = request.execute(this.debugger);
            logger.debug(() -> "DebugRequestServer responds " + (Object)((Object)response.getType()));
            this.sendResponse(output, response);
            output.flush();
        }
    }

    private IDebugRequest readRequest(InputStream input) throws Exception {
        return Serializer.readDebugRequest(input);
    }

    private void sendResponse(OutputStream output, IDebugResponse response) throws Exception {
        Serializer.writeDebugResponse(output, response);
    }
}

