/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import prompto.debug.IStackFrame;
import prompto.debug.IVariable;

public class LeanStackFrame
implements IStackFrame {
    String filePath;
    int index;
    int startCharIndex;
    int endCharIndex;
    String categoryName;
    String methodName;
    String methodProto;
    int methodLine;
    int statementLine;

    public LeanStackFrame() {
    }

    public LeanStackFrame(IStackFrame frame) {
        this.filePath = frame.getFilePath();
        this.index = frame.getIndex();
        this.startCharIndex = frame.getStartCharIndex();
        this.endCharIndex = frame.getEndCharIndex();
        this.categoryName = frame.getCategoryName();
        this.methodName = frame.getMethodName();
        this.methodProto = frame.getMethodProto();
        this.methodLine = frame.getMethodLine();
        this.statementLine = frame.getStatementLine();
    }

    @Override
    public String getCategoryName() {
        return this.categoryName;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getMethodProto() {
        return this.methodProto;
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getMethodLine() {
        return this.methodLine;
    }

    @Override
    public int getStatementLine() {
        return this.statementLine;
    }

    @Override
    public int getEndCharIndex() {
        return this.endCharIndex;
    }

    @Override
    public int getStartCharIndex() {
        return this.startCharIndex;
    }

    @Override
    @JsonIgnore
    public Collection<? extends IVariable> getVariables() {
        throw new UnsupportedOperationException("Must override!");
    }

    public String toString() {
        return this.methodName + ", line " + Integer.toString(this.statementLine);
    }

    public String toJson() {
        return new ObjectMapper().valueToTree((Object)this).toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IStackFrame)) {
            return false;
        }
        IStackFrame sf = (IStackFrame)obj;
        return this.index == sf.getIndex();
    }
}

