/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import prompto.debug.IDebugEventListener;
import prompto.debug.IDebugger;
import prompto.debug.IStack;
import prompto.debug.IStackFrame;
import prompto.debug.IVariable;
import prompto.debug.IWorker;
import prompto.debug.IWorkerDebugger;
import prompto.debug.LeanStack;
import prompto.debug.LeanWorker;
import prompto.debug.Status;
import prompto.debug.WorkerDebugger;
import prompto.parser.ISection;
import prompto.runtime.Context;
import prompto.utils.Logger;

public class ProcessDebugger
implements IDebugger {
    private static Logger logger = new Logger();
    static ProcessDebugger instance = null;
    Map<IWorker, IWorkerDebugger> debuggers = new HashMap<IWorker, IWorkerDebugger>();
    Status status = Status.STARTING;
    IDebugEventListener listener;
    Context context;

    public static ProcessDebugger getInstance() {
        return instance;
    }

    public static ProcessDebugger createInstance(Context context) {
        if (instance != null) {
            throw new IllegalStateException("An instance already exists!");
        }
        instance = new ProcessDebugger(context);
        return instance;
    }

    public static void reset() {
        instance = null;
    }

    private ProcessDebugger(Context context) {
        this.context = context;
    }

    public void setProcessStatus(Status status) {
        this.status = status;
    }

    @Override
    public Status getProcessStatus() {
        return this.status;
    }

    public void register(Thread thread, WorkerDebugger debugger) {
        DebuggedWorker debugged = DebuggedWorker.wrap(thread);
        this.debuggers.put(debugged, debugger);
    }

    public void unregister(Thread thread) {
        DebuggedWorker debugged = DebuggedWorker.wrap(thread);
        this.debuggers.remove(debugged);
    }

    @Override
    public void setListener(IDebugEventListener listener) {
        this.listener = listener;
    }

    @Override
    public void installBreakpoint(ISection section) {
        if (this.context == null) {
            throw new RuntimeException("No context to search from!");
        }
        ISection instance = this.context.locateSection(section);
        if (instance != null) {
            logger.debug(() -> "Found section " + instance.toString());
            instance.setAsBreakpoint(section.isBreakpoint());
        } else {
            logger.debug(() -> "Could not find section " + section.toString());
        }
    }

    @Override
    public boolean isTerminated() {
        return this.status == Status.TERMINATED;
    }

    @Override
    public boolean canTerminate() {
        return !this.isTerminated();
    }

    @Override
    public void terminate() {
        this.notifyTerminated();
    }

    @Override
    public void notifyTerminated() {
        if (!this.isTerminated()) {
            this.setProcessStatus(Status.TERMINATED);
            if (this.listener != null) {
                this.listener.handleTerminatedEvent();
            }
        }
    }

    @Override
    public Collection<? extends IWorker> getWorkers() {
        return this.debuggers.keySet();
    }

    @Override
    public Status getWorkerStatus(IWorker worker) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
            return Status.TERMINATED;
        }
        return debugger.getStatus();
    }

    @Override
    public IStack<?> getStack(IWorker worker) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
            return new LeanStack();
        }
        return debugger.getStack();
    }

    @Override
    public int getLineInFile(IWorker worker) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
            return -1;
        }
        return debugger.getLineInFile();
    }

    @Override
    public int getLineInMethod(IWorker worker) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
            return -1;
        }
        return debugger.getLineInMethod();
    }

    @Override
    public boolean isStepping(IWorker worker) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
            return false;
        }
        return debugger.isStepping();
    }

    @Override
    public boolean isSuspended(IWorker worker) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
            return false;
        }
        return debugger.isSuspended();
    }

    @Override
    public boolean canResume(IWorker worker) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
            return false;
        }
        return debugger.canResume();
    }

    @Override
    public boolean canSuspend(IWorker worker) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
            return false;
        }
        return debugger.canSuspend();
    }

    @Override
    public boolean canStepInto(IWorker worker) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
            return false;
        }
        return debugger.canStepInto();
    }

    @Override
    public boolean canStepOver(IWorker worker) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
            return false;
        }
        return debugger.canStepOver();
    }

    @Override
    public boolean canStepOut(IWorker worker) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
            return false;
        }
        return debugger.canStepOut();
    }

    @Override
    public void suspend(IWorker worker) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
        } else {
            debugger.suspend();
        }
    }

    @Override
    public void resume(IWorker worker) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
        } else {
            debugger.resume();
        }
    }

    @Override
    public void terminate(IWorker worker) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
        } else {
            debugger.terminate();
        }
    }

    @Override
    public void stepInto(IWorker worker) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
        } else {
            debugger.stepInto();
        }
    }

    @Override
    public void stepOut(IWorker worker) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
        } else {
            debugger.stepOut();
        }
    }

    @Override
    public void stepOver(IWorker worker) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
        } else {
            debugger.stepOver();
        }
    }

    @Override
    public Collection<? extends IVariable> getVariables(IWorker worker, IStackFrame frame) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
            return Collections.emptyList();
        }
        return debugger.getVariables(frame);
    }

    @Override
    public IVariable getVariable(IWorker worker, IStackFrame frame, String variableName) {
        IWorkerDebugger debugger = this.debuggers.get(worker);
        if (debugger == null) {
            logger.warn(() -> "Invalid worker: " + worker);
            return null;
        }
        return debugger.getVariable(frame, variableName);
    }

    public static class DebuggedWorker
    extends LeanWorker {
        long threadId;

        public static DebuggedWorker wrap(Thread thread) {
            return new DebuggedWorker(thread);
        }

        public static IWorker parse(String workerId) {
            try {
                long id = Long.parseLong(workerId);
                return new DebuggedWorker(id);
            }
            catch (NumberFormatException e) {
                Set<IWorker> workers;
                if ("only".equals(workerId) && (workers = ProcessDebugger.getInstance().debuggers.keySet()).size() == 1) {
                    return workers.iterator().next();
                }
                return null;
            }
        }

        public DebuggedWorker(long threadId) {
            this.threadId = threadId;
            this.workerId = String.valueOf(threadId);
        }

        public DebuggedWorker(Thread thread) {
            this.threadId = thread.getId();
            this.workerId = String.valueOf(this.threadId);
            this.name = thread.getName();
            this.state = IWorker.State.valueOf(thread.getState());
        }

        public boolean equals(Object obj) {
            return obj instanceof DebuggedWorker && this.equals((DebuggedWorker)obj);
        }

        public boolean equals(DebuggedWorker obj) {
            return this.threadId == obj.threadId;
        }

        public int hashCode() {
            return Long.hashCode(this.threadId);
        }
    }
}

