/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import prompto.debug.IAcknowledgement;
import prompto.debug.IDebugEvent;
import prompto.debug.IDebugRequest;
import prompto.debug.IDebugResponse;

public class Serializer {
    static ObjectMapper mapper = Serializer.initMapper();

    private static ObjectMapper initMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        return mapper;
    }

    public static void writeDebugRequest(OutputStream output, IDebugRequest request) throws Exception {
        DebugRequestMessage message = new DebugRequestMessage();
        message.type = request.getType();
        message.object = request;
        mapper.writeValue(output, (Object)message);
        output.flush();
    }

    public static IDebugRequest readDebugRequest(InputStream input) throws Exception {
        JsonNode content = mapper.readTree(input);
        String typeName = content.get("type").asText();
        IDebugRequest.Type type = IDebugRequest.Type.valueOf(typeName);
        return (IDebugRequest)mapper.convertValue((Object)content.get("object"), type.getKlass());
    }

    public static void writeDebugResponse(OutputStream output, IDebugResponse response) throws Exception {
        DebugResponseMessage message = new DebugResponseMessage();
        message.type = response.getType();
        message.object = response;
        mapper.writeValue(output, (Object)message);
    }

    public static IDebugResponse readDebugResponse(InputStream input) throws Exception {
        JsonNode content = mapper.readTree(input);
        String typeName = content.get("type").asText();
        IDebugResponse.Type type = IDebugResponse.Type.valueOf(typeName);
        return (IDebugResponse)mapper.convertValue((Object)content.get("object"), type.getKlass());
    }

    public static String writeDebugEvent(IDebugEvent event) throws Exception {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            Serializer.writeDebugEvent(output, event);
            String string = output.toString();
            return string;
        }
    }

    public static void writeDebugEvent(OutputStream output, IDebugEvent event) throws Exception {
        DebugEventMessage message = new DebugEventMessage();
        message.type = event.getType();
        message.object = event;
        mapper.writeValue(output, (Object)message);
    }

    public static IDebugEvent readDebugEvent(String message) throws Exception {
        try (ByteArrayInputStream input = new ByteArrayInputStream(message.getBytes());){
            IDebugEvent iDebugEvent = Serializer.readDebugEvent(input);
            return iDebugEvent;
        }
    }

    public static IDebugEvent readDebugEvent(InputStream input) throws Exception {
        JsonNode content = mapper.readTree(input);
        String typeName = content.get("type").asText();
        IDebugEvent.Type type = IDebugEvent.Type.valueOf(typeName);
        return (IDebugEvent)mapper.convertValue((Object)content.get("object"), type.getKlass());
    }

    public static void writeAcknowledgement(OutputStream output, IAcknowledgement ack) throws Exception {
        AcknowledgementMessage message = new AcknowledgementMessage();
        message.type = ack.getType();
        mapper.writeValue(output, (Object)message);
    }

    public static IAcknowledgement readAcknowledgement(InputStream input) throws Exception {
        JsonNode content = mapper.readTree(input);
        String typeName = content.get("type").asText();
        IAcknowledgement.Type type = IAcknowledgement.Type.valueOf(typeName);
        return type.getKlass().newInstance();
    }

    static class AcknowledgementMessage {
        IAcknowledgement.Type type;

        AcknowledgementMessage() {
        }

        public IAcknowledgement.Type getType() {
            return this.type;
        }
    }

    static class DebugEventMessage {
        IDebugEvent.Type type;
        IDebugEvent object;

        DebugEventMessage() {
        }

        public IDebugEvent.Type getType() {
            return this.type;
        }

        public IDebugEvent getObject() {
            return this.object;
        }
    }

    static class DebugResponseMessage {
        IDebugResponse.Type type;
        IDebugResponse object;

        DebugResponseMessage() {
        }

        public IDebugResponse.Type getType() {
            return this.type;
        }

        public IDebugResponse getObject() {
            return this.object;
        }
    }

    static class DebugRequestMessage {
        IDebugRequest.Type type;
        IDebugRequest object;

        DebugRequestMessage() {
        }

        public IDebugRequest.Type getType() {
            return this.type;
        }

        public IDebugRequest getObject() {
            return this.object;
        }
    }
}

