/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import java.util.Collection;
import java.util.Collections;
import prompto.debug.IDebugEvent;
import prompto.debug.IDebugEventListener;
import prompto.debug.IStackFrame;
import prompto.debug.IVariable;
import prompto.debug.IWorker;
import prompto.debug.IWorkerDebugger;
import prompto.debug.ProcessDebugger;
import prompto.debug.ResumeReason;
import prompto.debug.Status;
import prompto.debug.SuspendReason;
import prompto.debug.WorkerStack;
import prompto.debug.WorkerStackFrame;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.declaration.TestMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.TerminatedError;
import prompto.parser.ISection;
import prompto.runtime.Context;
import prompto.utils.Logger;

public class WorkerDebugger
implements IWorkerDebugger {
    static Logger logger = new Logger();
    WorkerStack stack = new WorkerStack();
    Object lock = new Object();
    Status status = Status.STARTING;
    boolean suspended = false;
    boolean terminated = false;
    ResumeReason resumeReason;
    IDebugEventListener listener;
    Context context;
    int stepDepth = 0;

    public WorkerStack getStack() {
        return this.stack;
    }

    @Override
    public Collection<? extends IVariable> getVariables(IStackFrame frame) {
        WorkerStackFrame sf = this.stack.find(frame);
        if (sf != null) {
            return sf.getVariables();
        }
        System.err.println("Could not find frame: " + frame.toString() + " in stack:");
        this.stack.forEach(f -> System.err.println(f.toString()));
        return Collections.emptyList();
    }

    @Override
    public IVariable getVariable(IStackFrame frame, String variableName) {
        WorkerStackFrame sf = this.stack.find(frame);
        if (sf != null) {
            return sf.getVariable(variableName);
        }
        System.err.println("Could not find frame: " + frame.toString() + " in stack:");
        this.stack.forEach(f -> System.err.println(f.toString()));
        return null;
    }

    public void setStatus(Status status) {
        logger.debug(() -> "LocalDebugger sets status " + (Object)((Object)status));
        this.status = status;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public void suspend() {
        this.suspended = true;
    }

    @Override
    public void terminate() {
        this.terminated = true;
        this.doResume(ResumeReason.RESUMED);
    }

    public IDebugEventListener getListener() {
        return this.listener;
    }

    public void setListener(IDebugEventListener listener) {
        this.listener = listener;
    }

    public void enterTest(Context context, TestMethodDeclaration test) {
        this.terminateIfRequested();
        this.context = context;
        this.stack.push(new WorkerStackFrame(context, null, test.getName(), null, this.stack.size(), test));
        this.terminateIfRequested();
    }

    public void enterMethod(Context context, IMethodDeclaration method) throws PromptoError {
        this.terminateIfRequested();
        this.context = context;
        CategoryDeclaration category = method.getMemberOf();
        String categoryName = category == null ? null : category.getName();
        this.stack.push(new WorkerStackFrame(context, categoryName, method.getName(), method.getProto(), this.stack.size(), method));
        this.terminateIfRequested();
    }

    public void leaveSection(Context context, ISection section) throws PromptoError {
        this.terminateIfRequested();
        if (this.stack.size() > 0 && this.stack.size() == -this.stepDepth) {
            this.stepDepth = this.stack.size();
            this.suspend(SuspendReason.STEPPING, context, section);
        } else {
            this.suspendIfRequested(context, section);
        }
        this.stack.pop();
        this.terminateIfRequested();
    }

    public void enterStatement(Context context, ISection section) throws PromptoError {
        this.terminateIfRequested();
        this.context = context;
        IStackFrame previous = (IStackFrame)this.stack.pop();
        this.stack.push(new WorkerStackFrame(context, previous.getCategoryName(), previous.getMethodName(), previous.getMethodProto(), previous.getMethodLine(), this.stack.size(), section));
        if (this.stack.size() > 0 && this.stack.size() <= this.stepDepth) {
            this.suspend(SuspendReason.STEPPING, context, section);
        } else if (section.isBreakpoint()) {
            this.stepDepth = this.stack.size();
            this.suspend(SuspendReason.BREAKPOINT, context, section);
        } else {
            this.suspendIfRequested(context, section);
        }
        this.terminateIfRequested();
    }

    public void leaveStatement(Context context, ISection section) throws PromptoError {
        this.terminateIfRequested();
        if (this.stack.size() > 0 && this.stack.size() == -this.stepDepth) {
            this.stepDepth = this.stack.size();
            this.suspend(SuspendReason.STEPPING, context, section);
        } else {
            this.suspendIfRequested(context, section);
        }
        this.terminateIfRequested();
    }

    private void terminateIfRequested() throws TerminatedError {
        if (this.terminated) {
            this.setStatus(Status.TERMINATING);
            throw new TerminatedError();
        }
    }

    private void suspendIfRequested(Context context, ISection section) {
        if (this.suspended) {
            this.suspended = false;
            this.stepDepth = this.stack.size();
            this.suspend(SuspendReason.SUSPENDED, context, section);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(SuspendReason reason, Context context, ISection section) {
        logger.debug(() -> "acquiring lock");
        Object object = this.lock;
        synchronized (object) {
            this.setStatus(Status.SUSPENDED);
            if (this.listener != null) {
                this.listener.handleSuspendedEvent(ProcessDebugger.DebuggedWorker.wrap(Thread.currentThread()), reason);
            }
            try {
                logger.debug(() -> "waiting lock");
                this.lock.wait();
                logger.debug(() -> "waiting lock");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.setStatus(Status.RUNNING);
                if (this.listener != null) {
                    this.listener.handleResumedEvent(ProcessDebugger.DebuggedWorker.wrap(Thread.currentThread()), this.resumeReason);
                }
            }
        }
    }

    @Override
    public boolean isStepping() {
        return this.stepDepth != 0;
    }

    @Override
    public boolean canSuspend() {
        return !this.isSuspended();
    }

    @Override
    public boolean isSuspended() {
        return this.status == Status.SUSPENDED;
    }

    @Override
    public boolean canResume() {
        return this.isSuspended();
    }

    @Override
    public void resume() {
        this.stepDepth = 0;
        this.doResume(ResumeReason.RESUMED);
    }

    @Override
    public boolean canStepOver() {
        return this.isSuspended();
    }

    @Override
    public void stepOver() {
        this.stepDepth = this.stack.size();
        this.doResume(ResumeReason.STEP_OVER);
    }

    @Override
    public boolean canStepInto() {
        return this.isSuspended();
    }

    @Override
    public void stepInto() {
        this.stepDepth = Math.abs(this.stepDepth) + 1;
        this.doResume(ResumeReason.STEP_INTO);
    }

    @Override
    public boolean canStepOut() {
        return this.isSuspended();
    }

    @Override
    public void stepOut() {
        this.stepDepth = -(Math.abs(this.stepDepth) - 1);
        this.doResume(ResumeReason.STEP_OUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doResume(ResumeReason reason) {
        this.resumeReason = reason;
        logger.debug(() -> "acquiring lock");
        Object object = this.lock;
        synchronized (object) {
            logger.debug(() -> "notifying lock");
            this.lock.notify();
            logger.debug(() -> "releasing lock");
        }
    }

    @Override
    public int getLineInFile() {
        IStackFrame frame = (IStackFrame)this.stack.peek();
        return frame == null ? -1 : frame.getStatementLine();
    }

    @Override
    public int getLineInMethod() {
        IStackFrame frame = (IStackFrame)this.stack.peek();
        return frame == null ? -1 : 1 + frame.getMethodLine() - frame.getStatementLine();
    }

    public void notifyStarted(IDebugEvent.Started event) {
        this.setStatus(Status.RUNNING);
        if (this.listener != null) {
            IWorker worker = ProcessDebugger.DebuggedWorker.parse(event.getWorkerId());
            this.listener.handleStartedEvent(worker);
        }
    }

    public void notifyCompleted(IDebugEvent.Completed event) {
        ProcessDebugger.getInstance().unregister(Thread.currentThread());
        if (this.listener != null) {
            IWorker worker = ProcessDebugger.DebuggedWorker.parse(event.getWorkerId());
            this.listener.handleCompletedEvent(worker);
        }
    }
}

