/*
 * Decompiled with CFR 0.152.
 */
package prompto.declaration;

import java.lang.reflect.Type;
import prompto.compiler.ClassFile;
import prompto.compiler.InterfaceType;
import prompto.declaration.BaseMethodDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.error.SyntaxError;
import prompto.grammar.Identifier;
import prompto.grammar.ParameterList;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public class AbstractMethodDeclaration
extends BaseMethodDeclaration
implements IMethodDeclaration {
    public AbstractMethodDeclaration(Identifier name, ParameterList arguments, IType returnType) {
        super(name, arguments, returnType != null ? returnType : VoidType.instance());
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isTemplate() {
        return false;
    }

    @Override
    public IType check(Context context, boolean isStart) {
        if (this.parameters != null) {
            this.parameters.check(context);
        }
        if (isStart) {
            Context local = context.newLocalContext();
            this.registerParameters(local);
        }
        return this.returnType;
    }

    @Override
    public IType checkChild(Context context) {
        if (this.parameters != null) {
            this.parameters.check(context);
        }
        return this.returnType;
    }

    @Override
    public IValue interpret(Context context) {
        throw new SyntaxError("Should never get there !");
    }

    @Override
    public void compile(Context context, boolean isStart, ClassFile classFile) {
        if (this.memberOf == null) {
            throw new SyntaxError("Should never get there !");
        }
        this.compilePrototype(context, isStart, classFile);
    }

    @Override
    public String compileTemplate(Context context, boolean isStart, ClassFile classFile) {
        throw new SyntaxError("Should never get there !");
    }

    public ClassFile compileInterface(Context context, Type type) {
        ClassFile classFile = new ClassFile(type);
        classFile.addModifier(1536);
        InterfaceType intf = new InterfaceType(this.parameters, this.returnType);
        classFile.addAttribute(intf.computeSignature(context, (Type)((Object)Object.class)));
        classFile.addInterface(intf.getInterfaceType());
        return classFile;
    }

    @Override
    public void declarationToDialect(CodeWriter writer) {
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
    }

    private void toMDialect(CodeWriter writer) {
        writer.append("abstract def ");
        writer.append(this.getName());
        writer.append(" (");
        this.parameters.toDialect(writer);
        writer.append(")");
        if (this.returnType != null && this.returnType != VoidType.instance()) {
            writer.append("->");
            this.returnType.toDialect(writer);
        }
    }

    protected void toEDialect(CodeWriter writer) {
        writer.append("define ");
        writer.append(this.getName());
        writer.append(" as abstract method ");
        this.parameters.toDialect(writer);
        if (this.returnType != null && this.returnType != VoidType.instance()) {
            writer.append("returning ");
            this.returnType.toDialect(writer);
        }
    }

    protected void toODialect(CodeWriter writer) {
        writer.append("abstract ");
        if (this.returnType != null && this.returnType != VoidType.instance()) {
            this.returnType.toDialect(writer);
            writer.append(" ");
        }
        writer.append("method ");
        writer.append(this.getName());
        writer.append(" (");
        this.parameters.toDialect(writer);
        writer.append(");");
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.declareParameters(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        return false;
    }
}

