/*
 * Decompiled with CFR 0.152.
 */
package prompto.declaration;

import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import prompto.compiler.ClassConstant;
import prompto.compiler.ClassFile;
import prompto.compiler.CompilerException;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Descriptor;
import prompto.compiler.FieldConstant;
import prompto.compiler.FieldInfo;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.StackLocal;
import prompto.constraint.IAttributeConstraint;
import prompto.declaration.BaseDeclaration;
import prompto.declaration.IDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.runtime.Context;
import prompto.store.AttributeInfo;
import prompto.store.FamilyInfo;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.IterableType;
import prompto.type.NativeType;
import prompto.utils.CodeWriter;
import prompto.utils.IdentifierList;
import prompto.value.IValue;

public class AttributeDeclaration
extends BaseDeclaration {
    IType type;
    IAttributeConstraint constraint;
    IdentifierList indexTypes;
    boolean storable = false;

    public AttributeDeclaration(Identifier id, IType type) {
        this(id, type, null, null);
    }

    public AttributeDeclaration(Identifier id, IType type, IAttributeConstraint constraint) {
        this(id, type, constraint, null);
    }

    public AttributeDeclaration(Identifier id, IType type, IdentifierList indexTypes) {
        this(id, type, null, indexTypes);
    }

    public AttributeDeclaration(Identifier id, IType type, IAttributeConstraint constraint, IdentifierList indexTypes) {
        super(id);
        this.type = type;
        this.constraint = constraint;
        this.indexTypes = indexTypes;
    }

    @Override
    public IDeclaration.DeclarationType getDeclarationType() {
        return IDeclaration.DeclarationType.ATTRIBUTE;
    }

    @Override
    public String toString() {
        return this.type.toString() + " " + this.getName();
    }

    public AttributeInfo getAttributeInfo(Context context) {
        return this.getAttributeInfo(context, id -> context.getRegisteredDeclaration(IDeclaration.class, (Identifier)id));
    }

    public AttributeInfo getAttributeInfo(Context context, Function<Identifier, IDeclaration> locator) {
        List<String> list = this.indexTypes == null ? null : this.indexTypes.stream().map(id -> id.toString()).collect(Collectors.toList());
        FamilyInfo family = this.getFamilyInfo(context, locator);
        return new AttributeInfo(this.getName(), family.getFamily(), family.isCollection(), list);
    }

    private FamilyInfo getFamilyInfo(Context context, Function<Identifier, IDeclaration> locator) {
        IType type = this.type;
        if (type instanceof NativeType) {
            return type.getFamilyInfo(context);
        }
        if (type instanceof IterableType) {
            FamilyInfo info = ((IterableType)type).getItemType().getFamilyInfo(context);
            return new FamilyInfo(info.getFamily(), true);
        }
        Identifier typeName = type.getTypeNameId();
        IDeclaration decl = locator.apply(typeName);
        return decl.getType(null).getFamilyInfo(context);
    }

    public IType getType() {
        return this.type;
    }

    public IAttributeConstraint getConstraint() {
        return this.constraint;
    }

    public void setStorable(boolean storable) {
        this.storable = storable;
    }

    @Override
    public boolean isStorable(Context context) {
        return this.storable;
    }

    @Override
    public void declarationToDialect(CodeWriter writer) {
        switch (writer.getDialect()) {
            case E: {
                writer.append("define ");
                writer.append(this.getId());
                writer.append(" as ");
                if (this.storable) {
                    writer.append("storable ");
                }
                this.type.toDialect(writer);
                writer.append(" attribute");
                if (this.constraint != null) {
                    this.constraint.toDialect(writer);
                }
                if (this.indexTypes == null) break;
                writer.append(" with ");
                this.indexTypes.toDialect(writer, true);
                writer.append(" index");
                break;
            }
            case O: {
                if (this.storable) {
                    writer.append("storable ");
                }
                writer.append("attribute ");
                writer.append(this.getId());
                writer.append(" : ");
                this.type.toDialect(writer);
                if (this.constraint != null) {
                    this.constraint.toDialect(writer);
                }
                if (this.indexTypes != null) {
                    writer.append(" with index");
                    if (!this.indexTypes.isEmpty()) {
                        writer.append(" (");
                        this.indexTypes.toDialect(writer, false);
                        writer.append(')');
                    }
                }
                writer.append(';');
                break;
            }
            case M: {
                if (this.storable) {
                    writer.append("storable ");
                }
                writer.append("attr ");
                writer.append(this.getId());
                writer.append(" (");
                this.type.toDialect(writer);
                writer.append("):\n");
                writer.indent();
                if (this.constraint != null) {
                    this.constraint.toDialect(writer);
                }
                if (this.indexTypes != null) {
                    if (this.constraint != null) {
                        writer.newLine();
                    }
                    writer.append("index (");
                    this.indexTypes.toDialect(writer, false);
                    writer.append(')');
                }
                if (this.constraint == null && this.indexTypes == null) {
                    writer.append("pass");
                }
                writer.dedent();
            }
        }
    }

    @Override
    public void register(Context context) {
        context.registerDeclaration(this);
    }

    @Override
    public IType check(Context context) {
        this.type.checkExists(context);
        return this.type;
    }

    @Override
    public IType getType(Context context) {
        return this.type;
    }

    public IValue checkValue(Context context, IExpression expression) throws PromptoError {
        IValue value = expression.interpret(context);
        if (this.constraint == null) {
            return value;
        }
        this.constraint.checkValue(context, value);
        return value;
    }

    public FieldInfo toFieldInfo(Context context) {
        return new FieldInfo(this.getName(), this.type.getJavaType(context));
    }

    public ClassFile compile(Context context, String fullName) {
        Type type = CompilerUtils.attributeInterfaceTypeFrom(fullName);
        ClassFile classFile = new ClassFile(type);
        classFile.addModifier(1536);
        FieldInfo field = this.toFieldInfo(context);
        this.compileSetterPrototype(context, classFile, field);
        this.compileGetterPrototype(context, classFile, field);
        this.compileDefaultChecker(context, classFile, field);
        ClassFile concrete = this.compileConcreteClass(context, classFile, fullName);
        classFile.addInnerClass(concrete);
        return classFile;
    }

    private void compileDefaultChecker(Context context, ClassFile classFile, FieldInfo field) {
        if (this.constraint != null) {
            String checkerName = CompilerUtils.checkerName(field.getName().getValue());
            Descriptor.Method proto = new Descriptor.Method(field.getType(), Void.TYPE);
            MethodInfo method = classFile.newMethod(checkerName, proto);
            method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
            method.registerLocal("value", IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(field.getType()));
            this.constraint.compile(context, method, new Flags());
            method.addInstruction(Opcode.RETURN, new IOperand[0]);
        }
    }

    protected ClassFile compileConcreteClass(Context context, ClassFile outerClass, String fullName) {
        try {
            Type concreteType = CompilerUtils.attributeConcreteTypeFrom(fullName);
            ClassFile classFile = new ClassFile(concreteType);
            classFile.setSuperClass(new ClassConstant((Type)((Object)Object.class)));
            classFile.addInterface(outerClass.getThisClass());
            FieldInfo field = this.toFieldInfo(context);
            classFile.addField(field);
            this.compileGetter(context, classFile, field);
            this.compileSetter(context, classFile, field);
            this.compileCopyConstructor(context, classFile, field);
            return classFile;
        }
        catch (SyntaxError e) {
            throw new CompilerException(e);
        }
    }

    private void compileCopyConstructor(Context context, ClassFile classFile, FieldInfo field) {
        Descriptor.Method proto = new Descriptor.Method(field.getType(), Void.TYPE);
        MethodInfo method = classFile.newMethod("<init>", proto);
        StackLocal local = method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_UninitializedThis, classFile.getThisClass());
        CompilerUtils.compileALOAD(method, local);
        MethodConstant m = new MethodConstant(classFile.getSuperClass(), "<init>", Void.TYPE);
        method.addInstruction(Opcode.INVOKESPECIAL, m);
        CompilerUtils.compileALOAD(method, local);
        StackLocal value = method.registerLocal("%value%", IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(field.getType()));
        CompilerUtils.compileALOAD(method, value);
        String setterName = CompilerUtils.setterName(field.getName().getValue());
        m = new MethodConstant(classFile.getThisClass(), setterName, field.getType(), Void.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        method.addInstruction(Opcode.RETURN, new IOperand[0]);
    }

    private void compileSetter(Context context, ClassFile classFile, FieldInfo field) {
        String setterName = CompilerUtils.setterName(field.getName().getValue());
        Descriptor.Method proto = new Descriptor.Method(field.getType(), Void.TYPE);
        MethodInfo method = classFile.newMethod(setterName, proto);
        StackLocal local = method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        StackLocal value = method.registerLocal("%value%", IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(field.getType()));
        if (this.constraint != null) {
            CompilerUtils.compileALOAD(method, local);
            CompilerUtils.compileALOAD(method, value);
            String checkerName = CompilerUtils.checkerName(field.getName().getValue());
            MethodConstant m = new MethodConstant(classFile.getThisClass(), checkerName, field.getType(), Void.TYPE);
            method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        }
        CompilerUtils.compileALOAD(method, local);
        CompilerUtils.compileALOAD(method, value);
        FieldConstant fc = new FieldConstant(classFile.getThisClass(), field.getName().getValue(), field.getType());
        method.addInstruction(Opcode.PUTFIELD, fc);
        method.addInstruction(Opcode.RETURN, new IOperand[0]);
    }

    private void compileGetter(Context context, ClassFile classFile, FieldInfo field) {
        String getterName = CompilerUtils.getterName(field.getName().getValue());
        Descriptor.Method proto = new Descriptor.Method(field.getType());
        MethodInfo method = classFile.newMethod(getterName, proto);
        StackLocal local = method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        CompilerUtils.compileALOAD(method, local);
        FieldConstant fc = new FieldConstant(classFile.getThisClass(), field.getName().getValue(), field.getType());
        method.addInstruction(Opcode.GETFIELD, fc);
        method.addInstruction(Opcode.ARETURN, new IOperand[0]);
    }

    private void compileGetterPrototype(Context context, ClassFile classFile, FieldInfo field) {
        String name = CompilerUtils.getterName(field.getName().getValue());
        Descriptor.Method proto = new Descriptor.Method(field.getType());
        MethodInfo method = classFile.newMethod(name, proto);
        method.addModifier(1024);
    }

    private void compileSetterPrototype(Context context, ClassFile classFile, FieldInfo field) {
        String name = CompilerUtils.setterName(field.getName().getValue());
        Descriptor.Method proto = new Descriptor.Method(field.getType(), Void.TYPE);
        MethodInfo method = classFile.newMethod(name, proto);
        method.addModifier(1024);
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.type.declare(transpiler);
        if (this.constraint != null) {
            this.constraint.declare(transpiler, this.getName(), this.type);
        }
    }
}

