/*
 * Decompiled with CFR 0.152.
 */
package prompto.declaration;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import prompto.code.ICodeStore;
import prompto.declaration.IDeclaration;
import prompto.grammar.Annotation;
import prompto.grammar.Identifier;
import prompto.parser.Section;
import prompto.runtime.Context;
import prompto.statement.CommentStatement;
import prompto.utils.CodeWriter;

public abstract class BaseDeclaration
extends Section
implements IDeclaration {
    Collection<CommentStatement> comments = null;
    Collection<Annotation> annotations = null;
    Identifier id;
    ICodeStore origin;
    boolean declaring = false;

    protected BaseDeclaration(Identifier id) {
        this.id = id;
    }

    @Override
    public Identifier getId() {
        return this.id;
    }

    public String toString() {
        return this.getId().toString();
    }

    @Override
    public void setOrigin(ICodeStore origin) {
        this.origin = origin;
    }

    @Override
    public ICodeStore getOrigin() {
        return this.origin;
    }

    @Override
    public String getName() {
        return this.id.toString();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public final void toDialect(CodeWriter writer) {
        if (this.getComments() != null) {
            this.getComments().forEach(comment -> comment.toDialect(writer));
        }
        if (this.getLocalAnnotations() != null) {
            this.getLocalAnnotations().forEach(annotation -> annotation.toDialect(writer));
        }
        this.declarationToDialect(writer);
    }

    protected abstract void declarationToDialect(CodeWriter var1);

    @Override
    public Collection<CommentStatement> getComments() {
        return this.comments;
    }

    @Override
    public void setComments(Collection<CommentStatement> comments) {
        this.comments = comments;
    }

    @Override
    public void setAnnotations(Collection<Annotation> annotations) {
        this.annotations = annotations;
    }

    @Override
    public void addAnnotation(Annotation annotation) {
        this.annotations = this.annotations == null ? Collections.singletonList(annotation) : (Collection)Stream.concat(this.annotations.stream(), Stream.of(annotation)).collect(Collectors.toList());
    }

    @Override
    public boolean removeAnnotation(String name) {
        String prefixed;
        String string = prefixed = name.startsWith("@") ? name : "@" + name;
        if (this.annotations == null || !this.annotations.stream().anyMatch(a -> a.isNamed(prefixed))) {
            return false;
        }
        this.annotations = this.annotations.stream().filter(a -> !a.isNamed(prefixed)).collect(Collectors.toList());
        return true;
    }

    @Override
    public Collection<Annotation> getLocalAnnotations() {
        return this.annotations;
    }

    @Override
    public Collection<Annotation> getAllAnnotations(Context context) {
        return this.annotations;
    }

    @Override
    public Stream<Annotation> getAllAnnotationsAsStream(Context context) {
        return this.annotations == null ? Stream.empty() : this.annotations.stream();
    }

    @Override
    public boolean hasLocalAnnotation(String name) {
        if (this.annotations == null) {
            return false;
        }
        String prefixed = name.startsWith("@") ? name : "@" + name;
        return this.annotations.stream().anyMatch(a -> a.isNamed(prefixed));
    }

    @Override
    public boolean hasInheritedAnnotation(Context context, String name) {
        return false;
    }

    @Override
    public int computeStartLine() {
        if (this.comments != null && !this.comments.isEmpty()) {
            return this.comments.iterator().next().getStart().getLine();
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            return this.annotations.iterator().next().getStart().getLine();
        }
        return super.computeStartLine();
    }
}

