/*
 * Decompiled with CFR 0.152.
 */
package prompto.declaration;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import prompto.compiler.ClassFile;
import prompto.compiler.CompilerException;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Descriptor;
import prompto.compiler.Flags;
import prompto.compiler.MethodInfo;
import prompto.declaration.BaseDeclaration;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.DefaultExpression;
import prompto.expression.IExpression;
import prompto.grammar.Argument;
import prompto.grammar.ArgumentList;
import prompto.grammar.Identifier;
import prompto.grammar.ParameterList;
import prompto.grammar.Specificity;
import prompto.param.IParameter;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.value.IValue;

public abstract class BaseMethodDeclaration
extends BaseDeclaration
implements IMethodDeclaration {
    CategoryDeclaration memberOf;
    IMethodDeclaration closureOf;
    ParameterList parameters;
    IType returnType;

    public BaseMethodDeclaration(Identifier name, ParameterList parameters, IType returnType) {
        super(name);
        this.parameters = parameters != null ? parameters : new ParameterList();
        this.returnType = returnType;
    }

    @Override
    public IDeclaration.DeclarationType getDeclarationType() {
        return IDeclaration.DeclarationType.METHOD;
    }

    @Override
    public void setMemberOf(CategoryDeclaration declaration) {
        this.memberOf = declaration;
    }

    @Override
    public CategoryDeclaration getMemberOf() {
        return this.memberOf;
    }

    @Override
    public void setClosureOf(IMethodDeclaration declaration) {
        this.closureOf = declaration;
    }

    @Override
    public IMethodDeclaration getClosureOf() {
        return this.closureOf;
    }

    @Override
    public String getSignature(Dialect dialect) {
        StringBuilder sb = new StringBuilder(this.getId().toString());
        sb.append('(');
        for (IParameter param : this.parameters) {
            sb.append(param.getSignature(dialect));
            sb.append(", ");
        }
        if (this.parameters.size() > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String getProto() {
        StringBuilder sb = new StringBuilder();
        for (IParameter param : this.parameters) {
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append(param.getProto());
        }
        return sb.toString();
    }

    @Override
    public ParameterList getParameters() {
        return this.parameters;
    }

    @Override
    public IType getReturnType() {
        return this.returnType;
    }

    @Override
    public void register(Context context) {
        context.registerDeclaration(this);
    }

    @Override
    public void registerParameters(Context context) {
        if (this.parameters != null) {
            this.parameters.register(context);
        }
    }

    @Override
    public IType getType(Context context) {
        try {
            return this.check(context, false);
        }
        catch (SyntaxError e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isAssignableTo(Context context, ArgumentList arguments, boolean checkInstance, boolean allowDerived, Predicate<Specificity> filter) {
        try {
            Context local = context.newLocalContext();
            this.registerParameters(local);
            ArgumentList argsList = new ArgumentList(arguments);
            for (IParameter parameter : this.parameters) {
                DefaultExpression expression;
                Argument argument = argsList.find(parameter.getId());
                if (argument == null && (expression = parameter.getDefaultExpression()) != null) {
                    argument = new Argument(parameter, expression);
                }
                if (argument == null) {
                    return false;
                }
                if (!this.isAssignableTo(local, parameter, argument, checkInstance, allowDerived, filter)) {
                    return false;
                }
                argsList.remove(argument);
            }
            return argsList.isEmpty();
        }
        catch (SyntaxError e) {
            return false;
        }
    }

    @Override
    public boolean isAssignableFrom(Context context, ArgumentList arguments) {
        try {
            Context local = context.newLocalContext();
            this.registerParameters(local);
            ArgumentList argsList = new ArgumentList(arguments);
            for (IParameter parameter : this.parameters) {
                DefaultExpression expression;
                Argument argument = argsList.find(parameter.getId());
                if (argument == null && (expression = parameter.getDefaultExpression()) != null) {
                    argument = new Argument(parameter, expression);
                }
                if (argument == null) {
                    return false;
                }
                if (!this.isAssignableFrom(local, parameter, argument)) {
                    return false;
                }
                argsList.remove(argument);
            }
            return argsList.isEmpty();
        }
        catch (SyntaxError e) {
            return false;
        }
    }

    boolean isAssignableTo(Context context, IParameter parameter, Argument argument, boolean useInstance, boolean allowDerived, Predicate<Specificity> filter) {
        Specificity spec = this.computeSpecificity(context, parameter, argument, useInstance, allowDerived);
        return filter.test(spec);
    }

    boolean isAssignableFrom(Context context, IParameter parameter, Argument argument) {
        try {
            IType requiredType = parameter.getType(context);
            IExpression expression = argument.getExpression();
            IType actualType = argument.checkActualType(context, requiredType, expression, false);
            if (actualType.equals(requiredType) || actualType.isAssignableFrom(context, requiredType) || requiredType.isAssignableFrom(context, actualType)) {
                return true;
            }
            actualType = argument.resolve(context, this, false, false).check(context);
            return actualType.equals(requiredType) || actualType.isAssignableFrom(context, requiredType) || requiredType.isAssignableFrom(context, actualType);
        }
        catch (PromptoError error) {
            return false;
        }
    }

    @Override
    public Specificity computeSpecificity(Context context, IParameter parameter, Argument argument, boolean useInstance, boolean allowDerived) {
        try {
            IType requiredType = parameter.getType(context).resolve(context, null);
            IType actualType = argument.checkActualType(context, requiredType, argument.getExpression(), useInstance).resolve(context, null);
            if (actualType.equals(requiredType)) {
                return Specificity.EXACT;
            }
            if (requiredType.isAssignableFrom(context, actualType)) {
                return Specificity.INHERITED;
            }
            if (allowDerived && actualType.isAssignableFrom(context, requiredType)) {
                return Specificity.DERIVED;
            }
            actualType = argument.resolve(context, this, useInstance, false).check(context);
            if (requiredType.isAssignableFrom(context, actualType)) {
                return Specificity.IMPLICIT;
            }
            if (allowDerived && actualType.isAssignableFrom(context, requiredType)) {
                return Specificity.IMPLICIT;
            }
        }
        catch (PromptoError promptoError) {
            // empty catch block
        }
        return Specificity.INCOMPATIBLE;
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        throw new InternalError("Should never get there!");
    }

    @Override
    public boolean isEligibleAsMain() {
        return false;
    }

    @Override
    public void compilePrototype(Context context, boolean isStart, ClassFile classFile) {
        try {
            context = this.prepareContext(context, isStart);
            IType returnType = this.check(context, false);
            MethodInfo method = this.createMethodInfo(context, classFile, returnType, this.getName());
            method.addModifier(1024);
        }
        catch (PromptoError e) {
            throw new CompilerException(e);
        }
    }

    protected Context prepareContext(Context context, boolean isStart) {
        if (isStart) {
            context = context.newLocalContext();
            this.registerParameters(context);
        }
        return context;
    }

    protected MethodInfo createMethodInfo(Context context, ClassFile classFile, IType returnType, String methodName) {
        Descriptor.Method proto = CompilerUtils.createMethodDescriptor(context, this.parameters, returnType);
        MethodInfo method = classFile.newMethod(methodName, proto);
        return method;
    }

    @Override
    public void compileParameters(Context context, MethodInfo method, Flags flags, ArgumentList arguments) {
        boolean isFirst = true;
        for (IParameter param : this.parameters.stripOutTemplateParameters()) {
            param.compileParameter(context, method, flags, arguments, isFirst);
            isFirst = false;
        }
    }

    public void declareParameters(Transpiler transpiler) {
        this.parameters.declare(transpiler);
    }

    public void transpileProlog(Transpiler transpiler) {
        if (this.memberOf != null) {
            transpiler.append(this.memberOf.getName());
            if (this.hasAnnotation(transpiler.getContext(), "@Static")) {
                transpiler.append(".");
            } else {
                transpiler.append(".prototype.");
            }
            transpiler.append(this.getTranspiledName(transpiler.getContext())).append(" = function (");
        } else {
            transpiler.append("function ").append(this.getTranspiledName(transpiler.getContext())).append(" (");
        }
        this.parameters.transpile(transpiler);
        transpiler.append(") {").indent();
    }

    public void transpileEpilog(Transpiler transpiler) {
        transpiler.dedent().append("}");
        if (this.memberOf != null) {
            transpiler.append(";");
        }
        transpiler.newLine();
    }

    @Override
    public String getTranspiledName(Context context) {
        if (this.getName().indexOf("$") > 0) {
            return this.getName();
        }
        if (this.hasLocalAnnotation("@Callback") || this.hasInheritedAnnotation(context, "@Callback")) {
            return this.getName();
        }
        Stream<String> name = Stream.of(this.getName());
        Stream<String> args = this.parameters.stream().map(arg -> arg.getTranspiledName(context));
        return Stream.concat(name, args).collect(Collectors.joining("$"));
    }

    @Override
    public boolean hasInheritedAnnotation(Context context, String name) {
        if (this.memberOf == null) {
            return false;
        }
        return this.getOverriddenMethods(context).anyMatch(m -> m.hasLocalAnnotation(name));
    }

    protected Stream<IMethodDeclaration> getOverriddenMethods(Context context) {
        Stream<CategoryDeclaration> categories = Stream.of(this.memberOf);
        if (this.memberOf.getDerivedFrom() != null) {
            categories = Stream.concat(categories, this.memberOf.getDerivedFrom().stream().map(id -> context.getRegisteredDeclaration(CategoryDeclaration.class, (Identifier)id)));
        }
        return categories.map(cat -> cat.getLocalMethods().stream()).flatMap(Function.identity()).filter(m -> this.getName().equals(m.getName())).filter(m -> this.getProto().equals(m.getProto()));
    }
}

