/*
 * Decompiled with CFR 0.152.
 */
package prompto.declaration;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import prompto.compiler.ClassFile;
import prompto.compiler.Flags;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.BaseDeclaration;
import prompto.declaration.GetterMethodDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.declaration.IWidgetDeclaration;
import prompto.declaration.SetterMethodDeclaration;
import prompto.declaration.WrappingWidgetDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.grammar.Annotation;
import prompto.grammar.Identifier;
import prompto.grammar.MethodDeclarationList;
import prompto.grammar.Operator;
import prompto.parser.ISection;
import prompto.runtime.Context;
import prompto.store.IStored;
import prompto.transpiler.ITranspilable;
import prompto.transpiler.Transpiler;
import prompto.type.CategoryType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.utils.IdentifierList;
import prompto.utils.Instance;
import prompto.utils.TypeUtils;
import prompto.value.DbIdValue;
import prompto.value.IInstance;
import prompto.value.IValue;

public abstract class CategoryDeclaration
extends BaseDeclaration {
    IWidgetDeclaration widget;
    IdentifierList derivedFrom = null;
    IdentifierList attributes;
    boolean storable = false;

    public CategoryDeclaration(Identifier id) {
        super(id);
    }

    public CategoryDeclaration(Identifier name, IdentifierList attributes) {
        super(name);
        this.attributes = attributes;
    }

    @Override
    public IDeclaration.DeclarationType getDeclarationType() {
        return IDeclaration.DeclarationType.CATEGORY;
    }

    public boolean isAWidget(Context context) {
        return false;
    }

    public IWidgetDeclaration asWidget() {
        if (this.widget == null) {
            this.widget = new WrappingWidgetDeclaration(this);
        }
        return this.widget;
    }

    public void setStorable(boolean storable) {
        this.storable = storable;
    }

    @Override
    public boolean isStorable(Context context) {
        return this.storable || this.isDerivedFromStorable(context);
    }

    private boolean isDerivedFromStorable(Context context) {
        if (context == null || this.derivedFrom == null) {
            return false;
        }
        return this.derivedFrom.stream().map(id -> context.getRegisteredDeclaration(CategoryDeclaration.class, (Identifier)id)).filter(Objects::nonNull).anyMatch(decl -> decl.isStorable(context));
    }

    public void setAttributes(IdentifierList attributes) {
        this.attributes = attributes;
    }

    public IdentifierList getAttributes() {
        return this.attributes;
    }

    public Set<Identifier> getAllAttributes(Context context) {
        if (this.attributes != null) {
            return new HashSet<Identifier>(this.attributes);
        }
        return null;
    }

    public abstract List<String> collectCategories(Context var1);

    @Override
    public void register(Context context) {
        context.registerDeclaration(this);
        this.registerMethods(context);
    }

    protected abstract void registerMethods(Context var1);

    @Override
    public IType check(Context context) {
        if (this.attributes != null) {
            for (Identifier attribute : this.attributes) {
                AttributeDeclaration ad;
                if (attribute == null || (ad = context.getRegisteredDeclaration(AttributeDeclaration.class, attribute)) != null) continue;
                context.getProblemListener().reportUnknownAttribute(attribute, attribute.toString());
            }
        }
        return new CategoryType(this.getId());
    }

    @Override
    public CategoryType getType(Context context) {
        return new CategoryType(this.getId());
    }

    public boolean hasAttribute(Context context, Identifier id) {
        if ("dbId".equals(id.toString())) {
            return this.isStorable(context);
        }
        return this.attributes != null && this.attributes.contains(id);
    }

    public boolean hasMethod(Context context, Identifier name) {
        return false;
    }

    public boolean isDerivedFrom(Context context, CategoryType categoryType) {
        return false;
    }

    public IdentifierList getDerivedFrom() {
        return null;
    }

    public boolean isAbstract() {
        return false;
    }

    public abstract IInstance newInstance(Context var1) throws PromptoError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IInstance newInstance(Context context, IStored stored) throws PromptoError {
        IInstance instance = this.newInstance(context);
        instance.setMutable(true);
        try {
            this.populateInstance(context, stored, instance);
        }
        finally {
            instance.setMutable(false);
        }
        return instance;
    }

    private void populateInstance(Context context, IStored stored, IInstance instance) throws PromptoError {
        Object dbId = stored.getDbId();
        this.setDbId(context, instance, dbId);
        for (Identifier name : this.getAllAttributes(context)) {
            this.populateMember(context, stored, instance, name);
        }
        if (instance.getStorable() != null) {
            instance.getStorable().clear();
        }
    }

    protected void setDbId(Context context, IInstance instance, Object dbId) {
        DbIdValue value = new DbIdValue(dbId);
        instance.setMember(context, new Identifier("dbId"), value);
    }

    private void populateMember(Context context, IStored stored, IInstance instance, Identifier name) throws PromptoError {
        AttributeDeclaration decl = context.getRegisteredDeclaration(AttributeDeclaration.class, name);
        if (!decl.isStorable(context)) {
            return;
        }
        Object data = stored.getData(name.toString());
        this.populateMember(context, data, instance, decl);
    }

    protected void populateMember(Context context, Object data, IInstance instance, AttributeDeclaration decl) throws PromptoError {
        IValue value;
        IValue iValue = value = data == null ? null : decl.getType().convertJavaValueToIValue(context, data);
        if (value != null) {
            instance.setMember(context, decl.getId(), value);
        }
    }

    public void checkConstructorContext(Context context) {
    }

    @Override
    public void declarationToDialect(CodeWriter writer) {
        writer = writer.newInstanceWriter(this.getType(writer.getContext()));
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
    }

    @Override
    public Collection<Annotation> getAllAnnotations(Context context) {
        return this.getAllAnnotationsAsStream(context).collect(Collectors.toList());
    }

    @Override
    public Stream<Annotation> getAllAnnotationsAsStream(Context context) {
        Instance stream = new Instance();
        stream.set(Stream.empty());
        IdentifierList derivedFrom = this.getDerivedFrom();
        if (derivedFrom != null) {
            derivedFrom.forEach(id -> {
                CategoryDeclaration decl = context.getRegisteredDeclaration(CategoryDeclaration.class, (Identifier)id);
                if (decl == null) {
                    context.getProblemListener().reportUnknownCategory((ISection)id, id.toString());
                } else {
                    stream.set(Stream.concat((Stream)stream.get(), decl.getAllAnnotationsAsStream(context)));
                }
            });
        }
        if (this.annotations != null) {
            stream.set(Stream.concat((Stream)stream.get(), this.annotations.stream()));
        }
        return (Stream)stream.get();
    }

    public void processAnnotations(Context context, boolean processDerivedFrom) {
        Stream<Annotation> stream = processDerivedFrom ? this.getAllAnnotationsAsStream(context) : (this.annotations == null ? Stream.empty() : this.annotations.stream());
        stream.forEach(a -> a.processCategory(context, this));
    }

    protected abstract void toEDialect(CodeWriter var1);

    protected void protoToEDialect(CodeWriter writer, boolean hasMethods, boolean hasMappings) {
        boolean hasAttributes = this.attributes != null && this.attributes.size() > 0;
        writer.append("define ");
        writer.append(this.getName());
        writer.append(" as ");
        if (this.storable) {
            writer.append("storable ");
        }
        this.categoryTypeToEDialect(writer);
        if (hasAttributes) {
            if (this.attributes.size() == 1) {
                writer.append(" with attribute ");
            } else {
                writer.append(" with attributes ");
            }
            this.attributes.toDialect(writer, true);
        }
        if (hasMethods) {
            if (hasAttributes) {
                writer.append(", and methods:");
            } else {
                writer.append(" with methods:");
            }
        } else if (hasMappings) {
            if (hasAttributes) {
                writer.append(", and bindings:");
            } else {
                writer.append(" with bindings:");
            }
        }
        writer.newLine();
    }

    protected void methodsToEDialect(CodeWriter writer, MethodDeclarationList methods) {
        writer.indent();
        for (IDeclaration decl : methods) {
            CodeWriter w = writer.newMemberWriter();
            decl.toDialect(w);
            writer.newLine();
        }
        writer.dedent();
    }

    protected void methodsToODialect(CodeWriter writer, MethodDeclarationList methods) {
        for (IDeclaration decl : methods) {
            CodeWriter w = writer.newMemberWriter();
            decl.toDialect(w);
            w.newLine();
        }
    }

    protected abstract void categoryTypeToEDialect(CodeWriter var1);

    protected abstract void toODialect(CodeWriter var1);

    protected void toODialect(CodeWriter writer, boolean hasBody) {
        this.categoryTypeToODialect(writer);
        writer.append(" ");
        writer.append(this.getName());
        if (this.attributes != null) {
            writer.append('(');
            this.attributes.toDialect(writer, true);
            writer.append(')');
        }
        this.categoryExtensionToODialect(writer);
        if (hasBody) {
            writer.append(" {\n");
            writer.newLine();
            writer.indent();
            this.bodyToODialect(writer);
            writer.dedent();
            writer.append('}');
            writer.newLine();
        } else {
            writer.append(';');
        }
    }

    protected abstract void categoryTypeToODialect(CodeWriter var1);

    protected void categoryExtensionToODialect(CodeWriter writer) {
    }

    protected abstract void bodyToODialect(CodeWriter var1);

    protected abstract void toMDialect(CodeWriter var1);

    protected void protoToMDialect(CodeWriter writer, IdentifierList derivedFrom) {
        if (this.storable) {
            writer.append("storable ");
        }
        this.categoryTypeToMDialect(writer);
        writer.append(" ");
        writer.append(this.getName());
        writer.append("(");
        if (derivedFrom != null) {
            derivedFrom.toDialect(writer, false);
            if (this.attributes != null) {
                writer.append(", ");
            }
        }
        if (this.attributes != null) {
            this.attributes.toDialect(writer, false);
        }
        writer.append("):\n");
    }

    protected abstract void categoryTypeToMDialect(CodeWriter var1);

    public ClassFile compile(Context context, String fullName) {
        throw new UnsupportedOperationException();
    }

    public abstract IMethodDeclaration findOperator(Context var1, Operator var2, IType var3);

    public static ResultInfo compilePlus(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression value) {
        return CategoryDeclaration.compileOperator(context, method, flags, left, value, Operator.PLUS);
    }

    public static ResultInfo compileDivide(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression value) {
        return CategoryDeclaration.compileOperator(context, method, flags, left, value, Operator.DIVIDE);
    }

    public static ResultInfo compileIntDivide(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression value) {
        return CategoryDeclaration.compileOperator(context, method, flags, left, value, Operator.IDIVIDE);
    }

    public static ResultInfo compileModulo(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression value) {
        return CategoryDeclaration.compileOperator(context, method, flags, left, value, Operator.MODULO);
    }

    public static ResultInfo compileMultiply(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression value) {
        return CategoryDeclaration.compileOperator(context, method, flags, left, value, Operator.MULTIPLY);
    }

    public static ResultInfo compileMultiply(Context context, MethodInfo method, Flags flags, ResultInfo left, ResultInfo right) {
        IType argType = TypeUtils.typeToIType(right.getType());
        return CategoryDeclaration.compileOperator(context, method, flags, left, right, argType, Operator.MULTIPLY);
    }

    public static ResultInfo compileMinus(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression value) {
        return CategoryDeclaration.compileOperator(context, method, flags, left, value, Operator.MINUS);
    }

    public static ResultInfo compileOperator(Context context, MethodInfo method, Flags flags, ResultInfo left, IExpression value, Operator oper) {
        IType argType = value.check(context);
        ResultInfo right = value.compile(context, method, flags);
        return CategoryDeclaration.compileOperator(context, method, flags, left, right, argType, oper);
    }

    private static ResultInfo compileOperator(Context context, MethodInfo method, Flags flags, ResultInfo left, ResultInfo right, IType argType, Operator oper) {
        String name = left.getType().getTypeName().substring("\u03c0.\u03c7.".length());
        CategoryDeclaration decl = context.getRegisteredDeclaration(CategoryDeclaration.class, new Identifier(name));
        IMethodDeclaration operator = decl.findOperator(context, oper, argType);
        if (operator == null) {
            throw new SyntaxError("No " + oper.getToken() + " operator method defined!");
        }
        Context local = context.newInstanceContext(decl.getType(context), false).newChildContext();
        operator.registerParameters(local);
        IType resultType = operator.check(local, false);
        String methodName = "operator_" + oper.name();
        InterfaceConstant c = new InterfaceConstant(left.getType(), methodName, argType.getJavaType(context), resultType.getJavaType(context));
        method.addInstruction(Opcode.INVOKEINTERFACE, c);
        return new ResultInfo(resultType.getJavaType(context), new ResultInfo.Flag[0]);
    }

    public Context.MethodDeclarationMap getMemberMethods(Context context, Identifier name) {
        throw new UnsupportedOperationException();
    }

    public MethodDeclarationList getLocalMethods() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Context.MethodDeclarationMap> getAllMethods(Context context) {
        HashMap<String, Context.MethodDeclarationMap> map = new HashMap<String, Context.MethodDeclarationMap>();
        this.collectAllMethods(context, map);
        return map;
    }

    public void collectAllMethods(Context context, Map<String, Context.MethodDeclarationMap> map) {
        this.getLocalMethods().forEach(m -> {
            Context.MethodDeclarationMap current = (Context.MethodDeclarationMap)map.get(m.getNameAsKey());
            if (current == null) {
                current = new Context.MethodDeclarationMap(m.getId());
                map.put(m.getNameAsKey(), current);
            }
            if (current.get(m.getProto()) == null) {
                current.put(m.getProto(), m);
            }
        });
    }

    protected boolean isPromptoRoot(Context context) {
        return false;
    }

    protected void declareAttributes(Transpiler transpiler) {
        if (this.attributes != null) {
            this.attributes.forEach(attr -> this.declareAttribute((Identifier)attr, transpiler));
        }
    }

    protected void declareAttribute(Identifier attr, Transpiler transpiler) {
        AttributeDeclaration decl = transpiler.getContext().getRegisteredDeclaration(AttributeDeclaration.class, attr);
        if (decl == null) {
            transpiler.getContext().getProblemListener().reportUnknownAttribute(attr, attr.toString(), " in category: " + this.getName());
        } else {
            decl.declare(transpiler);
        }
    }

    public abstract void ensureDeclarationOrder(Context var1, List<ITranspilable> var2, Set<ITranspilable> var3);

    public GetterMethodDeclaration findGetter(Context context, Identifier attrName) {
        throw new IllegalStateException("Should never get there");
    }

    public SetterMethodDeclaration findSetter(Context context, Identifier attrName) {
        throw new IllegalStateException("Should never get there");
    }
}

