/*
 * Decompiled with CFR 0.152.
 */
package prompto.declaration;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import prompto.compiler.ClassConstant;
import prompto.compiler.ClassFile;
import prompto.compiler.CompilerException;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Descriptor;
import prompto.compiler.FieldConstant;
import prompto.compiler.FieldInfo;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.IntConstant;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.OffsetListenerConstant;
import prompto.compiler.Opcode;
import prompto.compiler.StackLocal;
import prompto.compiler.StackState;
import prompto.compiler.StringConstant;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.EnumeratedNativeDeclaration;
import prompto.declaration.GetterMethodDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IEnumeratedDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.declaration.OperatorMethodDeclaration;
import prompto.declaration.SetterMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.grammar.Identifier;
import prompto.grammar.MethodDeclarationList;
import prompto.grammar.Operator;
import prompto.intrinsic.PromptoEnum;
import prompto.intrinsic.PromptoRoot;
import prompto.intrinsic.PromptoStorableBase;
import prompto.param.IParameter;
import prompto.parser.ISection;
import prompto.problem.IProblemListener;
import prompto.runtime.Context;
import prompto.store.DataStore;
import prompto.store.IStorable;
import prompto.store.IStore;
import prompto.store.IStored;
import prompto.transpiler.ITranspilable;
import prompto.transpiler.Transpiler;
import prompto.type.CategoryType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.utils.IdentifierList;
import prompto.value.ConcreteInstance;
import prompto.value.IInstance;

public class ConcreteCategoryDeclaration
extends CategoryDeclaration {
    MethodDeclarationList methods;
    Map<String, IDeclaration> methodsMap = null;

    protected ConcreteCategoryDeclaration(Identifier id) {
        super(id);
    }

    public ConcreteCategoryDeclaration(Identifier name, IdentifierList attributes, IdentifierList derivedFrom, MethodDeclarationList methods) {
        super(name, attributes);
        this.derivedFrom = derivedFrom;
        this.methods = methods != null ? methods : new MethodDeclarationList();
        this.methods.forEach(method -> method.setMemberOf(this));
    }

    @Override
    public boolean isAWidget(Context context) {
        if (this.derivedFrom == null || this.derivedFrom.size() != 1) {
            return false;
        }
        CategoryDeclaration parent = context.getRegisteredDeclaration(CategoryDeclaration.class, (Identifier)this.derivedFrom.get(0), true);
        return parent.isAWidget(context);
    }

    @Override
    public MethodDeclarationList getLocalMethods() {
        return this.methods;
    }

    @Override
    public IdentifierList getDerivedFrom() {
        return this.derivedFrom;
    }

    public MethodDeclarationList getMethods() {
        return this.methods;
    }

    @Override
    public ISection locateSection(ISection section) {
        return this.methods.locateSection(section);
    }

    @Override
    protected void toEDialect(CodeWriter writer) {
        boolean hasMethods = this.methods != null && this.methods.size() > 0;
        this.protoToEDialect(writer, hasMethods, false);
        if (hasMethods) {
            this.methodsToEDialect(writer, this.methods);
        }
    }

    @Override
    protected void categoryTypeToEDialect(CodeWriter writer) {
        if (this.derivedFrom == null) {
            writer.append("category");
        } else {
            this.derivedFrom.toDialect(writer, true);
        }
    }

    @Override
    protected void toODialect(CodeWriter writer) {
        boolean hasMethods = this.methods != null && this.methods.size() > 0;
        this.toODialect(writer, hasMethods);
    }

    @Override
    protected void categoryTypeToODialect(CodeWriter writer) {
        if (this.storable) {
            writer.append("storable ");
        }
        if (this.isAWidget(writer.getContext())) {
            writer.append("widget");
        } else {
            writer.append("category");
        }
    }

    @Override
    protected void categoryExtensionToODialect(CodeWriter writer) {
        if (this.derivedFrom != null) {
            writer.append(" extends ");
            this.derivedFrom.toDialect(writer, true);
        }
    }

    @Override
    protected void bodyToODialect(CodeWriter writer) {
        this.methodsToODialect(writer, this.methods);
    }

    @Override
    protected void toMDialect(CodeWriter writer) {
        this.protoToMDialect(writer, this.derivedFrom);
        this.methodsToMDialect(writer);
    }

    @Override
    protected void categoryTypeToMDialect(CodeWriter writer) {
        writer.append("class");
    }

    private void methodsToMDialect(CodeWriter writer) {
        writer.indent();
        if (this.methods == null || this.methods.size() == 0) {
            writer.append("pass\n");
        } else {
            writer.newLine();
            for (IDeclaration decl : this.methods) {
                CodeWriter w = writer.newMemberWriter();
                decl.toDialect(w);
                writer.newLine();
            }
        }
        writer.dedent();
    }

    @Override
    public Set<Identifier> getAllAttributes(Context context) {
        HashSet<Identifier> all = new HashSet<Identifier>();
        Set<Identifier> more = super.getAllAttributes(context);
        if (more != null) {
            all.addAll(more);
        }
        if (this.derivedFrom != null) {
            this.derivedFrom.forEach(id -> {
                Set<Identifier> ids = this.getAncestorAttributes(context, (Identifier)id);
                if (ids != null) {
                    all.addAll(ids);
                }
            });
        }
        return all;
    }

    private Set<Identifier> getLocalCategoryAttributes(Context context) {
        Set<Identifier> set = this.getLocalAttributes(context);
        if (set == null) {
            return null;
        }
        return (set = set.stream().filter(id -> this.isCategoryAttribute(context, (Identifier)id)).collect(Collectors.toSet())).isEmpty() ? null : set;
    }

    protected Set<Identifier> getLocalAttributes(Context context) {
        Set<Identifier> set = this.getAllAttributes(context);
        if (set == null) {
            return null;
        }
        return (set = set.stream().filter(id -> !this.isSuperClassAttribute(context, (Identifier)id)).collect(Collectors.toSet())).isEmpty() ? null : set;
    }

    private Set<Identifier> getAncestorAttributes(Context context, Identifier ancestor) {
        CategoryDeclaration actual = context.getRegisteredDeclaration(CategoryDeclaration.class, ancestor);
        if (actual == null) {
            return null;
        }
        return actual.getAllAttributes(context);
    }

    @Override
    public boolean hasAttribute(Context context, Identifier name) {
        if (super.hasAttribute(context, name)) {
            return true;
        }
        return this.hasDerivedAttribute(context, name);
    }

    private boolean hasDerivedAttribute(Context context, Identifier name) {
        if (this.derivedFrom == null) {
            return false;
        }
        return this.derivedFrom.stream().map(ancestor -> context.getRegisteredDeclaration(CategoryDeclaration.class, (Identifier)ancestor)).filter(Objects::nonNull).anyMatch(decl -> decl.hasAttribute(context, name));
    }

    @Override
    public boolean hasMethod(Context context, Identifier name) {
        this.registerMethods(context);
        if (this.methodsMap.containsKey(name.toString())) {
            return true;
        }
        return this.hasDerivedMethod(context, name);
    }

    private boolean hasDerivedMethod(Context context, Identifier name) {
        if (this.derivedFrom == null) {
            return false;
        }
        return this.derivedFrom.stream().map(ancestor -> context.getRegisteredDeclaration(CategoryDeclaration.class, (Identifier)ancestor)).filter(Objects::nonNull).anyMatch(decl -> decl.hasMethod(context, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IType check(Context context) {
        IProblemListener listener = context.getProblemListener();
        listener.pushDeclaration(this);
        try {
            context = context.newInstanceContext(this.getType(context), false);
            this.checkDerived(context);
            this.checkMethods(context);
            IType iType = super.check(context);
            return iType;
        }
        finally {
            listener.popDeclaration();
        }
    }

    private void checkMethods(Context context) {
        this.registerMethods(context);
        for (IMethodDeclaration method : this.methods) {
            method.checkChild(context);
        }
    }

    @Override
    protected void registerMethods(Context context) {
        if (this.methodsMap == null) {
            this.methodsMap = new HashMap<String, IDeclaration>();
            this.methods.forEach(method -> this.registerMethod((IMethodDeclaration)method, context));
        }
    }

    private void registerMethod(IMethodDeclaration method, Context context) {
        String methodKey = method.getNameAsKey();
        IDeclaration actual = this.methodsMap.get(methodKey);
        if (method instanceof SetterMethodDeclaration || method instanceof GetterMethodDeclaration) {
            if (actual != null) {
                throw new SyntaxError("Duplicate method: \"" + methodKey + "\"");
            }
            this.methodsMap.put(methodKey, method);
        } else {
            if (actual == null) {
                actual = new Context.MethodDeclarationMap(method.getId());
                this.methodsMap.put(methodKey, actual);
            }
            ((Context.MethodDeclarationMap)actual).register(method, context);
        }
    }

    private void checkDerived(Context context) {
        if (this.derivedFrom != null) {
            for (Identifier category : this.derivedFrom) {
                ConcreteCategoryDeclaration cd = context.getRegisteredDeclaration(ConcreteCategoryDeclaration.class, category);
                if (cd != null) continue;
                context.getProblemListener().reportUnknownCategory(category, category.toString());
            }
        }
    }

    @Override
    public boolean isDerivedFrom(Context context, CategoryType categoryType) {
        if (this.derivedFrom == null) {
            return false;
        }
        for (Identifier ancestor : this.derivedFrom) {
            if (ancestor.equals(categoryType.getTypeNameId())) {
                return true;
            }
            if (!ConcreteCategoryDeclaration.isAncestorDerivedFrom(ancestor, context, categoryType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAncestorDerivedFrom(Identifier ancestor, Context context, CategoryType categoryType) {
        IDeclaration actual = context.getRegisteredDeclaration(IDeclaration.class, ancestor);
        if (actual == null || !(actual instanceof CategoryDeclaration)) {
            return false;
        }
        CategoryDeclaration cd = (CategoryDeclaration)actual;
        return cd.isDerivedFrom(context, categoryType);
    }

    @Override
    public IInstance newInstance(Context context) throws PromptoError {
        return new ConcreteInstance(context, this);
    }

    @Override
    public GetterMethodDeclaration findGetter(Context context, Identifier attrName) {
        if (this.methodsMap == null) {
            return null;
        }
        IDeclaration method = this.methodsMap.get(GetterMethodDeclaration.getNameAsKey(attrName));
        if (method instanceof GetterMethodDeclaration) {
            return (GetterMethodDeclaration)method;
        }
        if (method != null) {
            throw new SyntaxError("Not a getter method!");
        }
        return this.findDerivedGetter(context, attrName);
    }

    private GetterMethodDeclaration findDerivedGetter(Context context, Identifier attrName) {
        if (this.derivedFrom == null) {
            return null;
        }
        for (Identifier ancestor : this.derivedFrom) {
            GetterMethodDeclaration method = ConcreteCategoryDeclaration.findAncestorGetter(ancestor, context, attrName);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static GetterMethodDeclaration findAncestorGetter(Identifier ancestor, Context context, Identifier attrName) {
        IDeclaration actual = context.getRegisteredDeclaration(IDeclaration.class, ancestor);
        if (actual == null || !(actual instanceof ConcreteCategoryDeclaration)) {
            return null;
        }
        ConcreteCategoryDeclaration cd = (ConcreteCategoryDeclaration)actual;
        return cd.findGetter(context, attrName);
    }

    @Override
    public SetterMethodDeclaration findSetter(Context context, Identifier attrName) {
        if (this.methodsMap == null) {
            return null;
        }
        IDeclaration method = this.methodsMap.get(SetterMethodDeclaration.getNameAsKey(attrName));
        if (method instanceof SetterMethodDeclaration) {
            return (SetterMethodDeclaration)method;
        }
        if (method != null) {
            throw new SyntaxError("Not a setter method!");
        }
        return this.findDerivedSetter(context, attrName);
    }

    private SetterMethodDeclaration findDerivedSetter(Context context, Identifier attrName) {
        if (this.derivedFrom == null) {
            return null;
        }
        for (Identifier ancestor : this.derivedFrom) {
            SetterMethodDeclaration method = ConcreteCategoryDeclaration.findAncestorSetter(ancestor, context, attrName);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static SetterMethodDeclaration findAncestorSetter(Identifier ancestor, Context context, Identifier attrName) {
        IDeclaration actual = context.getRegisteredDeclaration(IDeclaration.class, ancestor);
        if (actual == null || !(actual instanceof ConcreteCategoryDeclaration)) {
            return null;
        }
        ConcreteCategoryDeclaration cd = (ConcreteCategoryDeclaration)actual;
        return cd.findSetter(context, attrName);
    }

    @Override
    public Context.MethodDeclarationMap getMemberMethods(Context context, Identifier name) {
        this.registerMethods(context);
        Context.MethodDeclarationMap result = new Context.MethodDeclarationMap(name);
        this.registerMemberMethods(context, result);
        return result;
    }

    private void registerMemberMethods(Context context, Context.MethodDeclarationMap result) {
        this.registerThisMemberMethods(context, result);
        this.registerDerivedMemberMethods(context, result);
    }

    private void registerThisMemberMethods(Context context, Context.MethodDeclarationMap result) {
        if (this.methodsMap == null) {
            return;
        }
        IDeclaration actual = this.methodsMap.get(result.getId().toString());
        if (actual == null) {
            return;
        }
        if (!(actual instanceof Context.MethodDeclarationMap)) {
            throw new SyntaxError("Not a member method!");
        }
        for (IMethodDeclaration method : ((Context.MethodDeclarationMap)actual).values()) {
            result.registerIfMissing(method, context);
        }
    }

    private void registerDerivedMemberMethods(Context context, Context.MethodDeclarationMap result) {
        if (this.derivedFrom == null) {
            return;
        }
        for (Identifier ancestor : this.derivedFrom) {
            this.registerAncestorMemberMethods(ancestor, context, result);
        }
    }

    private void registerAncestorMemberMethods(Identifier ancestor, Context context, Context.MethodDeclarationMap result) {
        IDeclaration actual = context.getRegisteredDeclaration(IDeclaration.class, ancestor);
        if (actual == null || !(actual instanceof ConcreteCategoryDeclaration)) {
            return;
        }
        ConcreteCategoryDeclaration cd = (ConcreteCategoryDeclaration)actual;
        cd.registerMemberMethods(context, result);
    }

    @Override
    public IMethodDeclaration findOperator(Context context, Operator operator, IType type) {
        Identifier methodName = new Identifier(OperatorMethodDeclaration.getNameAsKey(operator));
        Context.MethodDeclarationMap methods = this.getMemberMethods(context, methodName);
        if (methods == null) {
            return null;
        }
        IMethodDeclaration candidate = null;
        for (IMethodDeclaration method : methods.values()) {
            IType potential = ((IParameter)method.getParameters().getFirst()).getType(context);
            if (!potential.isAssignableFrom(context, type)) continue;
            if (candidate == null) {
                candidate = method;
                continue;
            }
            IType currentBest = ((IParameter)candidate.getParameters().getFirst()).getType(context);
            if (!potential.isAssignableFrom(context, currentBest)) continue;
            candidate = method;
        }
        return candidate;
    }

    @Override
    public List<String> collectCategories(Context context) {
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> list = new ArrayList<String>();
        this.collectCategories(context, set, list);
        return list;
    }

    private void collectCategories(Context context, Set<String> set, List<String> list) {
        if (this.derivedFrom != null) {
            for (Identifier category : this.derivedFrom) {
                ConcreteCategoryDeclaration cd = context.getRegisteredDeclaration(ConcreteCategoryDeclaration.class, category);
                cd.collectCategories(context, set, list);
            }
        }
        if (!set.contains(this.getName())) {
            set.add(this.getName());
            list.add(this.getName());
        }
    }

    protected ClassFile compileConcreteClass(Context context, String fullName) {
        try {
            Type concreteType = CompilerUtils.categoryConcreteParentTypeFrom(fullName);
            ClassFile classFile = new ClassFile(concreteType);
            if (this.isAbstract()) {
                classFile.addModifier(1024);
            }
            this.compileSuperClass(context, classFile, new Flags());
            this.compileInterface(context, classFile, new Flags());
            this.compileCategoryField(context, classFile, new Flags());
            this.compileClassConstructor(context, classFile, new Flags());
            this.compileFields(context, classFile, new Flags());
            this.compileEmptyConstructor(context, classFile, new Flags());
            this.compileCopyConstructor(context, classFile, new Flags());
            this.compileCollectStorables(context, classFile, new Flags());
            this.compileMethods(context, classFile, new Flags());
            return classFile;
        }
        catch (SyntaxError e) {
            throw new CompilerException(e);
        }
    }

    private void compileCollectStorables(Context context, ClassFile classFile, Flags flags) {
        Set<Identifier> attributes = this.getLocalCategoryAttributes(context);
        if (attributes == null) {
            return;
        }
        MethodInfo method = classFile.newMethod("collectStorables", new Descriptor.Method(new Type[]{Consumer.class, Void.TYPE}));
        StackLocal $this = method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        StackLocal $storables = method.registerLocal("storables", IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant((Type)((Object)List.class)));
        CompilerUtils.compileALOAD(method, $this);
        CompilerUtils.compileALOAD(method, $storables);
        MethodConstant m = new MethodConstant(classFile.getSuperClass(), "collectStorables", new Type[]{Consumer.class, Void.TYPE});
        method.addInstruction(Opcode.INVOKESPECIAL, m);
        attributes.stream().filter(id -> this.compilesToPromptoRoot(context, (Identifier)id)).forEach(id -> {
            StackState state = method.captureStackState();
            CompilerUtils.compileALOAD(method, $this);
            AttributeDeclaration attr = context.getRegisteredDeclaration(AttributeDeclaration.class, (Identifier)id);
            FieldInfo field = attr.toFieldInfo(context);
            MethodConstant mx = new MethodConstant(classFile.getThisClass(), CompilerUtils.getterName(id.toString()), field.getType());
            method.addInstruction(Opcode.INVOKEVIRTUAL, mx);
            StackLocal $field = method.registerLocal("$" + id.toString(), IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(field.getType()));
            CompilerUtils.compileASTORE(method, $field);
            CompilerUtils.compileALOAD(method, $field);
            OffsetListenerConstant listener = method.addOffsetListener(new OffsetListenerConstant());
            method.activateOffsetListener(listener);
            method.addInstruction(Opcode.IFNULL, listener);
            CompilerUtils.compileALOAD(method, $field);
            method.addInstruction(Opcode.CHECKCAST, new ClassConstant((Type)((Object)PromptoRoot.class)));
            CompilerUtils.compileALOAD(method, $storables);
            mx = new MethodConstant((Type)((Object)PromptoRoot.class), "collectStorables", new Type[]{Consumer.class, Void.TYPE});
            method.addInstruction(Opcode.INVOKEVIRTUAL, mx);
            method.inhibitOffsetListener(listener);
            method.restoreFullStackState(state);
            method.placeLabel(state);
        });
        method.addInstruction(Opcode.RETURN, new IOperand[0]);
    }

    private boolean compilesToPromptoRoot(Context context, Identifier id) {
        AttributeDeclaration attr = context.getRegisteredDeclaration(AttributeDeclaration.class, id);
        IDeclaration decl = context.getRegisteredDeclaration(IDeclaration.class, attr.getType(context).getTypeNameId(), true);
        return decl instanceof CategoryDeclaration && !(decl instanceof IEnumeratedDeclaration);
    }

    protected void compileClassConstructor(Context context, ClassFile classFile, Flags flags) {
        if (this.needsClassConstructor(context)) {
            MethodInfo method = classFile.newMethod("<clinit>", new Descriptor.Method(Void.TYPE));
            method.addModifier(8);
            this.compileClassConstructorBody(context, method, flags);
            method.addInstruction(Opcode.RETURN, new IOperand[0]);
        }
    }

    protected void compileClassConstructorBody(Context context, MethodInfo method, Flags flags) {
        this.compilePopulateCategoryField(context, method, flags);
    }

    protected void compilePopulateCategoryField(Context context, MethodInfo method, Flags flags) {
        List<String> categories = this.collectCategories(context);
        if (categories.size() <= 5) {
            Opcode opcode = Opcode.values()[Opcode.ICONST_0.ordinal() + categories.size()];
            method.addInstruction(opcode, new IOperand[0]);
        } else {
            method.addInstruction(Opcode.LDC, new IntConstant(categories.size()));
        }
        method.addInstruction(Opcode.ANEWARRAY, new ClassConstant((Type)((Object)String.class)));
        int idx = 0;
        for (String s : categories) {
            method.addInstruction(Opcode.DUP, new IOperand[0]);
            if (idx <= 5) {
                Opcode opcode = Opcode.values()[Opcode.ICONST_0.ordinal() + idx++];
                method.addInstruction(opcode, new IOperand[0]);
            } else {
                method.addInstruction(Opcode.LDC, new IntConstant(idx++));
            }
            method.addInstruction(Opcode.LDC, new StringConstant(s));
            method.addInstruction(Opcode.AASTORE, new IOperand[0]);
        }
        FieldConstant f = new FieldConstant(method.getClassFile().getThisClass(), "category", (Type)((Object)String[].class));
        method.addInstruction(Opcode.PUTSTATIC, f);
    }

    protected boolean needsClassConstructor(Context context) {
        return this.isStorable(context);
    }

    @Override
    public ClassFile compile(Context context, String fullName) {
        try {
            Type interfaceType = CompilerUtils.categoryInterfaceTypeFrom(fullName);
            ClassFile classFile = new ClassFile(interfaceType);
            classFile.addModifier(1536);
            this.compileInterfaces(context, classFile);
            this.compileMethodPrototypes(context, classFile);
            ClassFile concrete = this.compileConcreteClass(context, fullName);
            classFile.addInnerClass(concrete);
            return classFile;
        }
        catch (SyntaxError e) {
            throw new CompilerException(e);
        }
    }

    private void compileInterfaces(Context context, ClassFile classFile) {
        if (this.derivedFrom != null) {
            this.derivedFrom.forEach(id -> classFile.addInterface(CompilerUtils.getCategoryInterfaceType(id)));
        }
        if (this.attributes != null) {
            this.attributes.forEach(id -> {
                if (!this.isSuperClassAttribute(context, (Identifier)id) && !this.isInheritedAttribute(context, (Identifier)id)) {
                    classFile.addInterface(CompilerUtils.getAttributeInterfaceType(id));
                }
            });
        }
    }

    private void compileMethodPrototypes(Context context, ClassFile classFile) {
        Map<String, Context.MethodDeclarationMap> all = this.collectInterfaceMethods(context);
        all.values().forEach(map -> map.values().forEach(method -> this.compileMethodPrototype(context, classFile, (IMethodDeclaration)method)));
    }

    protected Map<String, Context.MethodDeclarationMap> collectInterfaceMethods(Context context) {
        Map<String, Context.MethodDeclarationMap> local = super.getAllMethods(context);
        Map<String, Context.MethodDeclarationMap> all = this.getAllMethods(context);
        this.removeInheritedMethods(local, all);
        return local;
    }

    private void removeInheritedMethods(Map<String, Context.MethodDeclarationMap> local, Map<String, Context.MethodDeclarationMap> all) {
        all.keySet().forEach(key -> {
            Context.MethodDeclarationMap localMap = (Context.MethodDeclarationMap)local.get(key);
            if (localMap != null) {
                Context.MethodDeclarationMap allMap = (Context.MethodDeclarationMap)all.get(key);
                allMap.keySet().forEach(proto -> {
                    if (((IMethodDeclaration)allMap.get(proto)).getMemberOf() != this) {
                        localMap.remove(proto);
                    }
                });
                if (localMap.isEmpty()) {
                    local.remove(key);
                }
            }
        });
    }

    @Override
    public Map<String, Context.MethodDeclarationMap> getAllMethods(Context context) {
        Map<String, Context.MethodDeclarationMap> map = super.getAllMethods(context);
        if (this.derivedFrom != null) {
            this.derivedFrom.forEach(id -> {
                CategoryDeclaration decl = context.getRegisteredDeclaration(CategoryDeclaration.class, (Identifier)id);
                decl.collectAllMethods(context, map);
            });
        }
        return map;
    }

    private void compileMethodPrototype(Context context, ClassFile classFile, IMethodDeclaration method) {
        try {
            context = context.newInstanceContext(this.getType(context), false).newChildContext();
            method.registerParameters(context);
            method.compilePrototype(context, false, classFile);
        }
        catch (SyntaxError e) {
            throw new CompilerException(e);
        }
    }

    protected void compileSuperClass(Context context, ClassFile classFile, Flags flags) {
        ClassConstant superClass = this.getSuperClass(context);
        if (superClass != null) {
            classFile.setSuperClass(superClass);
        }
    }

    protected void compileInterface(Context context, ClassFile classFile, Flags flags) {
        ClassConstant interFace = this.getInterface(context);
        if (interFace != null) {
            classFile.addInterface(interFace);
        }
    }

    protected ClassConstant getInterface(Context context) {
        return new ClassConstant(CompilerUtils.getCategoryInterfaceType(this.getId()));
    }

    protected ClassConstant getSuperClass(Context context) {
        if (this.derivedFrom == null) {
            return new ClassConstant((Type)((Object)PromptoRoot.class));
        }
        return new ClassConstant(CompilerUtils.getCategoryConcreteType((Identifier)this.derivedFrom.getFirst()));
    }

    protected void compileCategoryField(Context context, ClassFile classFile, Flags flags) {
        if (this.isStorable(context)) {
            FieldInfo field = new FieldInfo("category", (Type)((Object)String[].class));
            field.addModifier(8);
            classFile.addField(field);
        }
    }

    protected void compileFields(Context context, ClassFile classFile, Flags flags) {
        Set<Identifier> ids = this.getAllAttributes(context);
        for (Identifier id : ids) {
            this.compileField(context, classFile, flags, id);
        }
    }

    protected void compileField(Context context, ClassFile classFile, Flags flags, Identifier id) {
        if (this.isSuperClassAttribute(context, id)) {
            this.compileSuperClassField(context, classFile, flags, id);
        } else if (this.isInheritedAttribute(context, id)) {
            this.compileInheritedField(context, classFile, flags, id);
        } else {
            this.compileLocalField(context, classFile, flags, id);
        }
    }

    private void compileInheritedField(Context context, ClassFile classFile, Flags flags, Identifier id) {
        AttributeDeclaration decl = context.getRegisteredDeclaration(AttributeDeclaration.class, id);
        FieldInfo field = decl.toFieldInfo(context);
        classFile.addField(field);
        this.compileInheritedSetterMethod(context, classFile, flags, id, field);
        this.compileInheritedGetterMethod(context, classFile, flags, id, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileInheritedSetterMethod(Context context, ClassFile classFile, Flags flags, Identifier id, FieldInfo field) {
        SetterMethodDeclaration setter = this.findSetter(context, id);
        if (setter != null) {
            SetterMethodDeclaration setterMethodDeclaration = setter;
            synchronized (setterMethodDeclaration) {
                CategoryDeclaration owner = setter.getMemberOf();
                setter.setMemberOf(this);
                try {
                    setter.compile(context, classFile, flags, this.getType(context), field);
                }
                finally {
                    setter.setMemberOf(owner);
                }
            }
        }
        this.compileFieldSetter(context, classFile, flags, id, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileInheritedGetterMethod(Context context, ClassFile classFile, Flags flags, Identifier id, FieldInfo field) {
        GetterMethodDeclaration getter = this.findGetter(context, id);
        if (getter != null) {
            GetterMethodDeclaration getterMethodDeclaration = getter;
            synchronized (getterMethodDeclaration) {
                CategoryDeclaration owner = getter.getMemberOf();
                getter.setMemberOf(this);
                try {
                    getter.compile(context, classFile, flags, this.getType(context), field);
                }
                finally {
                    getter.setMemberOf(owner);
                }
            }
        }
        this.compileFieldGetter(context, classFile, flags, id, field);
    }

    private boolean isInheritedAttribute(Context context, Identifier id) {
        if (this.derivedFrom == null) {
            return false;
        }
        Iterator iter = this.derivedFrom.iterator();
        iter.next();
        while (iter.hasNext()) {
            Identifier derived = (Identifier)iter.next();
            CategoryDeclaration decl = context.getRegisteredDeclaration(CategoryDeclaration.class, derived);
            if (!decl.hasAttribute(context, id)) continue;
            return true;
        }
        return false;
    }

    private void compileLocalField(Context context, ClassFile classFile, Flags flags, Identifier id) {
        AttributeDeclaration decl = context.getRegisteredDeclaration(AttributeDeclaration.class, id);
        FieldInfo field = decl.toFieldInfo(context);
        classFile.addField(field);
        this.compileLocalSetterMethod(context, classFile, flags, id, field);
        this.compileLocalGetterMethod(context, classFile, flags, id, field);
    }

    private void compileSuperClassField(Context context, ClassFile classFile, Flags flags, Identifier id) {
        SetterMethodDeclaration setter;
        AttributeDeclaration decl = context.getRegisteredDeclaration(AttributeDeclaration.class, id);
        FieldInfo field = decl.toFieldInfo(context);
        GetterMethodDeclaration getter = this.findGetter(context, id);
        if (getter != null) {
            getter.compile(context, classFile, flags, this.getType(context), field);
        }
        if ((setter = this.findSetter(context, id)) != null) {
            setter.compile(context, classFile, flags, this.getType(context), field);
        }
    }

    private boolean isSuperClassAttribute(Context context, Identifier id) {
        if (this.derivedFrom == null) {
            return false;
        }
        CategoryDeclaration decl = context.getRegisteredDeclaration(CategoryDeclaration.class, (Identifier)this.derivedFrom.getFirst());
        return decl.hasAttribute(context, id);
    }

    private boolean isCategoryAttribute(Context context, Identifier id) {
        AttributeDeclaration decl = context.getRegisteredDeclaration(AttributeDeclaration.class, id);
        return decl.getType(context) instanceof CategoryType;
    }

    private void compileLocalSetterMethod(Context context, ClassFile classFile, Flags flags, Identifier id, FieldInfo field) {
        SetterMethodDeclaration setter = this.findSetter(context, id);
        if (setter != null) {
            setter.compile(context, classFile, flags, this.getType(context), field);
        } else {
            this.compileFieldSetter(context, classFile, flags, id, field);
        }
    }

    private void compileFieldSetter(Context context, ClassFile classFile, Flags flags, Identifier id, FieldInfo field) {
        String name = CompilerUtils.setterName(field.getName().getValue());
        Descriptor.Method proto = new Descriptor.Method(field.getType(), Void.TYPE);
        MethodInfo method = classFile.newMethod(name, proto);
        method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        ClassConstant fc = new ClassConstant(field.getType());
        method.registerLocal("%value%", IVerifierEntry.VerifierType.ITEM_Object, fc);
        method.addInstruction(Opcode.ALOAD_0, classFile.getThisClass());
        method.addInstruction(Opcode.ALOAD_1, fc);
        FieldConstant f = new FieldConstant(classFile.getThisClass(), field.getName().getValue(), field.getType());
        method.addInstruction(Opcode.PUTFIELD, f);
        if (this.isPromptoRoot(context) && this.isStorableAttribute(context, id)) {
            MethodConstant m = new MethodConstant((Type)((Object)PromptoRoot.class), "setStorable", new Type[]{String.class, Object.class, Void.TYPE});
            method.addInstruction(Opcode.ALOAD_0, classFile.getThisClass());
            method.addInstruction(Opcode.LDC, new StringConstant(field.getName().getValue()));
            method.addInstruction(Opcode.ALOAD_1, new ClassConstant((Type)((Object)Object.class)));
            this.compileGetStorableData(context, method, flags, id);
            method.addInstruction(Opcode.INVOKESPECIAL, m);
        }
        method.addInstruction(Opcode.RETURN, new IOperand[0]);
    }

    private boolean isStorableAttribute(Context context, Identifier id) {
        return context.getRegisteredDeclaration(AttributeDeclaration.class, id).isStorable(context);
    }

    private void compileGetStorableData(Context context, MethodInfo method, Flags flags, Identifier id) {
        IType type = context.getRegisteredDeclaration(AttributeDeclaration.class, id).getType();
        type.compileGetStorableData(context, method, flags);
    }

    @Override
    protected boolean isPromptoRoot(Context context) {
        if (PromptoRoot.class == this.getSuperClass(context).getType()) {
            return true;
        }
        CategoryDeclaration decl = context.getRegisteredDeclaration(CategoryDeclaration.class, (Identifier)this.derivedFrom.getFirst());
        return decl.isPromptoRoot(context);
    }

    protected boolean isPromptoError(Context context) {
        return false;
    }

    private void compileLocalGetterMethod(Context context, ClassFile classFile, Flags flags, Identifier id, FieldInfo field) {
        GetterMethodDeclaration getter = this.findGetter(context, id);
        if (getter != null) {
            getter.compile(context, classFile, flags, this.getType(context), field);
        } else {
            this.compileFieldGetter(context, classFile, flags, id, field);
        }
    }

    private void compileFieldGetter(Context context, ClassFile classFile, Flags flags, Identifier id, FieldInfo field) {
        String name = CompilerUtils.getterName(id.toString());
        Descriptor.Method proto = new Descriptor.Method(field.getType());
        MethodInfo method = classFile.newMethod(name, proto);
        method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        method.addInstruction(Opcode.ALOAD_0, classFile.getThisClass());
        FieldConstant f = new FieldConstant(classFile.getThisClass(), id.toString(), field.getType());
        method.addInstruction(Opcode.GETFIELD, f);
        method.addInstruction(Opcode.ARETURN, new ClassConstant(field.getType()));
    }

    protected void compileEmptyConstructor(Context context, ClassFile classFile, Flags flags) {
        if (this.isStorable(context)) {
            Descriptor.Method proto = new Descriptor.Method(Void.TYPE);
            MethodInfo method = classFile.newMethod("<init>", proto);
            method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_UninitializedThis, classFile.getThisClass());
            method.addInstruction(Opcode.ALOAD_0, classFile.getThisClass());
            MethodConstant m = new MethodConstant(classFile.getSuperClass(), "<init>", Void.TYPE);
            method.addInstruction(Opcode.INVOKESPECIAL, m);
            this.compileNewStorable(context, method, flags);
            method.addInstruction(Opcode.RETURN, new IOperand[0]);
        } else {
            CompilerUtils.compileEmptyConstructor(classFile);
        }
    }

    private void compileCopyConstructor(Context context, ClassFile classFile, Flags flags) {
        if (!this.isStorable(context)) {
            return;
        }
        Descriptor.Method proto = new Descriptor.Method(new Type[]{IStored.class, Void.TYPE});
        MethodInfo method = classFile.newMethod("<init>", proto);
        method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_UninitializedThis, classFile.getThisClass());
        method.addInstruction(Opcode.ALOAD_0, classFile.getThisClass());
        method.addInstruction(Opcode.ALOAD_1, new ClassConstant((Type)((Object)IStored.class)));
        MethodConstant m = new MethodConstant(classFile.getSuperClass(), "<init>", new Type[]{IStored.class, Void.TYPE});
        method.addInstruction(Opcode.INVOKESPECIAL, m);
        this.compileNewStorable(context, method, flags);
        this.compilePopulateFields(context, method, flags);
        method.addInstruction(Opcode.RETURN, new IOperand[0]);
    }

    private void compilePopulateFields(Context context, MethodInfo method, Flags flags) {
        boolean skipSuperClassFields = this.isSuperClassStorable(context);
        this.getAllAttributes(context).forEach(id -> {
            if (skipSuperClassFields && this.isSuperClassAttribute(context, (Identifier)id)) {
                return;
            }
            this.compilePopulateField(context, method, flags, (Identifier)id);
        });
        ClassConstant thisClass = method.getClassFile().getThisClass();
        method.addInstruction(Opcode.ALOAD_0, thisClass);
        FieldConstant field = new FieldConstant(thisClass, "storable", (Type)((Object)IStorable.class));
        method.addInstruction(Opcode.GETFIELD, field);
        InterfaceConstant i = new InterfaceConstant((Type)((Object)IStorable.class), "clear", Void.TYPE);
        method.addInstruction(Opcode.INVOKEINTERFACE, i);
    }

    private void compilePopulateField(Context context, MethodInfo method, Flags flags, Identifier id) {
        ClassConstant thisClass = method.getClassFile().getThisClass();
        method.addInstruction(Opcode.ALOAD_0, thisClass);
        method.addInstruction(Opcode.ALOAD_1, new ClassConstant((Type)((Object)IStored.class)));
        method.addInstruction(Opcode.LDC, new StringConstant(id.toString()));
        InterfaceConstant i = new InterfaceConstant((Type)((Object)IStored.class), "getData", new Type[]{String.class, Object.class});
        method.addInstruction(Opcode.INVOKEINTERFACE, i);
        this.compileConvertFieldToInstance(context, method, flags, id);
        FieldInfo field = context.getRegisteredDeclaration(AttributeDeclaration.class, id).toFieldInfo(context);
        method.addInstruction(Opcode.CHECKCAST, new ClassConstant(field.getType()));
        String setterName = CompilerUtils.setterName(field.getName().getValue());
        MethodConstant m = new MethodConstant(thisClass, setterName, field.getType(), Void.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
    }

    private void compileConvertFieldToInstance(Context context, MethodInfo method, Flags flags, Identifier id) {
        IType type = context.getRegisteredDeclaration(AttributeDeclaration.class, id).getType(context);
        IDeclaration decl = context.getRegisteredDeclaration(IDeclaration.class, type.getTypeNameId());
        if (decl instanceof IEnumeratedDeclaration) {
            Type symbolType = decl instanceof EnumeratedNativeDeclaration ? CompilerUtils.getNativeEnumType(decl.getId()) : CompilerUtils.getCategoryEnumConcreteType(decl.getId());
            method.addInstruction(Opcode.LDC, new ClassConstant(symbolType));
            MethodConstant m = new MethodConstant((Type)((Object)PromptoEnum.class), "getInstance", new Type[]{Object.class, Class.class, PromptoEnum.class});
            method.addInstruction(Opcode.INVOKESTATIC, m);
        } else if (decl instanceof CategoryDeclaration) {
            MethodConstant m = new MethodConstant((Type)((Object)PromptoRoot.class), "newInstanceFromDbIdRef", new Type[]{Object.class, PromptoRoot.class});
            method.addInstruction(Opcode.INVOKESTATIC, m);
        }
    }

    private void compileNewStorable(Context context, MethodInfo method, Flags flags) {
        if (this.isSuperClassStorable(context)) {
            this.compileSetStorableCategories(context, method, flags);
        } else {
            this.compileNewStorableInstance(context, method, flags);
        }
    }

    private void compileSetStorableCategories(Context context, MethodInfo method, Flags flags) {
        ClassConstant thisClass = method.getClassFile().getThisClass();
        method.addInstruction(Opcode.ALOAD_0, thisClass);
        FieldConstant f = new FieldConstant(thisClass, "storable", (Type)((Object)IStorable.class));
        method.addInstruction(Opcode.GETFIELD, f);
        f = new FieldConstant(thisClass, "category", (Type)((Object)String[].class));
        method.addInstruction(Opcode.GETSTATIC, f);
        InterfaceConstant i = new InterfaceConstant((Type)((Object)IStorable.class), "setCategories", new Type[]{String[].class, Void.TYPE});
        method.addInstruction(Opcode.INVOKEINTERFACE, i);
    }

    private void compileNewStorableInstance(Context context, MethodInfo method, Flags flags) {
        ClassConstant thisClass = method.getClassFile().getThisClass();
        method.addInstruction(Opcode.ALOAD_0, thisClass);
        MethodConstant m = new MethodConstant(new ClassConstant((Type)((Object)DataStore.class)), "getInstance", new Type[]{IStore.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        FieldConstant f = new FieldConstant(thisClass, "category", (Type)((Object)String[].class));
        method.addInstruction(Opcode.GETSTATIC, f);
        method.addInstruction(Opcode.ALOAD_0, thisClass);
        m = new MethodConstant(new ClassConstant((Type)((Object)PromptoStorableBase.class)), "getDbIdFactory", new Type[]{IStorable.IDbIdFactory.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        InterfaceConstant i = new InterfaceConstant((Type)((Object)IStore.class), "newStorable", new Type[]{String[].class, IStorable.IDbIdFactory.class, IStorable.class});
        method.addInstruction(Opcode.INVOKEINTERFACE, i);
        f = new FieldConstant(thisClass, "storable", (Type)((Object)IStorable.class));
        method.addInstruction(Opcode.PUTFIELD, f);
    }

    boolean isSuperClassStorable(Context context) {
        if (this.derivedFrom == null || this.derivedFrom.isEmpty()) {
            return false;
        }
        return context.getRegisteredDeclaration(CategoryDeclaration.class, (Identifier)this.derivedFrom.getFirst()).isStorable(context);
    }

    protected void compileMethods(Context context, ClassFile classFile, Flags flags) {
        for (IMethodDeclaration method : this.methods) {
            if (method instanceof GetterMethodDeclaration || method instanceof SetterMethodDeclaration) continue;
            context = context.newMemberContext(this.getType(context));
            method.registerParameters(context);
            method.compile(context, false, classFile);
        }
    }

    @Override
    public void ensureDeclarationOrder(Context context, List<ITranspilable> list, Set<ITranspilable> set) {
        if (set.contains(this)) {
            return;
        }
        if (this.derivedFrom != null) {
            this.derivedFrom.forEach(cat -> {
                CategoryDeclaration decl = context.getRegisteredDeclaration(CategoryDeclaration.class, (Identifier)cat);
                decl.ensureDeclarationOrder(context, list, set);
            });
        }
        list.add(this);
        set.add(this);
    }

    @Override
    public void declare(Transpiler transpiler) {
        if (!transpiler.isDeclared(this)) {
            if (this.declaring) {
                return;
            }
            this.declaring = true;
            IProblemListener listener = transpiler.getContext().getProblemListener();
            listener.pushDeclaration(this);
            try {
                this.doDeclare(transpiler);
            }
            finally {
                listener.popDeclaration();
                this.declaring = false;
            }
        }
    }

    private void doDeclare(Transpiler transpiler) {
        transpiler.declare(this);
        this.declareAttributes(transpiler);
        Transpiler instance = transpiler.newInstanceTranspiler(this.getType(transpiler.getContext()));
        if (this.derivedFrom != null) {
            this.derivedFrom.forEach(cat -> {
                CategoryDeclaration decl = instance.getContext().getRegisteredDeclaration(CategoryDeclaration.class, (Identifier)cat);
                decl.declare(instance);
            });
        } else {
            this.declareRoot(instance);
        }
        if (this.storable) {
            instance.require("DataStore");
            instance.require("Remote");
        }
        this.declareMethods(instance);
        instance.flush();
    }

    private void declareMethods(Transpiler transpiler) {
        this.methods.stream().filter(decl -> !(decl instanceof SetterMethodDeclaration) && !(decl instanceof GetterMethodDeclaration)).forEach(method -> {
            Transpiler t = transpiler.newChildTranspiler(null);
            method.declare(t);
            t.flush();
        });
    }

    protected void declareRoot(Transpiler transpiler) {
        transpiler.require("$Root");
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        this.transpileConstructor(transpiler);
        transpiler = transpiler.newInstanceTranspiler(new CategoryType(this.getId()));
        this.transpileLoaders(transpiler);
        this.transpileMethods(transpiler);
        this.transpileGetterSetters(transpiler);
        transpiler.flush();
        return true;
    }

    private void transpileConstructor(Transpiler transpiler) {
        Identifier parent;
        transpiler.append("function ").append(this.getName()).append("(copyFrom, values, mutable) {");
        transpiler.indent();
        List<String> categories = this.collectCategories(transpiler.getContext());
        if (this.storable) {
            transpiler.append("if(!this.$storable) {").newLine().indent().append("this.$storable = $DataStore.instance.newStorableDocument(['").append(categories.stream().collect(Collectors.joining("', '"))).append("'], this.dbIdListener.bind(this));").newLine().dedent().append("}").newLine();
        }
        this.transpileGetterSetterAttributes(transpiler);
        this.transpileSuperConstructor(transpiler);
        transpiler.append("this.$categories = [").append(categories.stream().collect(Collectors.joining(", "))).append("];").newLine();
        this.transpileLocalAttributes(transpiler);
        transpiler.append("this.$mutable = mutable;").newLine();
        transpiler.append("return this;");
        transpiler.dedent();
        transpiler.append("}");
        transpiler.newLine();
        Identifier identifier = parent = this.derivedFrom != null && this.derivedFrom.size() > 0 ? (Identifier)this.derivedFrom.get(0) : null;
        if (parent != null) {
            transpiler.append(this.getName()).append(".prototype = Object.create(").append(parent.toString()).append(".prototype);").newLine();
        } else {
            transpiler.append(this.getName()).append(".prototype = Object.create($Root.prototype);").newLine();
        }
        transpiler.append(this.getName()).append(".prototype.constructor = ").append(this.getName()).append(";").newLine();
    }

    protected void transpileLoaders(Transpiler transpiler) {
        Set<Identifier> attributes = this.getLocalAttributes(transpiler.getContext());
        if (attributes != null) {
            attributes.stream().filter(attr -> this.isEnumeratedAttribute(transpiler.getContext(), (Identifier)attr)).forEach(attr -> {
                transpiler.append(this.getName()).append(".prototype.load$").append(attr.toString()).append(" = function(name) {").indent();
                transpiler.append("return eval(name);").dedent();
                transpiler.append("};").newLine();
            });
        }
    }

    protected void transpileGetterSetters(Transpiler transpiler) {
        Set<Identifier> names = this.methods.stream().filter(decl -> decl instanceof SetterMethodDeclaration || decl instanceof GetterMethodDeclaration).map(decl -> decl.getId()).collect(Collectors.toSet());
        names.forEach(name -> this.transpileGetterSetter(transpiler, (Identifier)name));
    }

    private void transpileGetterSetter(Transpiler transpiler, Identifier id) {
        Transpiler m;
        GetterMethodDeclaration getter = this.findGetter(transpiler.getContext(), id);
        SetterMethodDeclaration setter = this.findSetter(transpiler.getContext(), id);
        transpiler.append("Object.defineProperty(").append(this.getName()).append(".prototype, '").append(id.toString()).append("', {").indent();
        transpiler.append("get: function() {").indent();
        if (getter != null) {
            m = transpiler.newGetterTranspiler(id.toString());
            getter.transpile(m);
            m.flush();
        } else {
            transpiler.append("return this.$").append(id.toString()).append(";").newLine();
        }
        transpiler.dedent().append("}");
        transpiler.append(",").newLine();
        transpiler.append("set: function(").append(id.toString()).append(") {").indent();
        if (setter != null) {
            m = transpiler.newSetterTranspiler(id.toString());
            m.append(id.toString()).append(" = (function(").append(id.toString()).append(") {").indent();
            setter.transpile(m);
            m.append(";").dedent().append("})(name);").newLine();
            m.flush();
        }
        transpiler.append("this.$").append(id.toString()).append(" = ").append(id.toString()).append(";").newLine();
        transpiler.dedent().append("}");
        transpiler.dedent().append("});").newLine();
    }

    protected void transpileGetterSetterAttributes(Transpiler transpiler) {
        Set<Identifier> allAttributes = this.getAllAttributes(transpiler.getContext());
        if (allAttributes != null) {
            allAttributes.forEach(attr -> {
                if (this.findGetter(transpiler.getContext(), (Identifier)attr) != null || this.findSetter(transpiler.getContext(), (Identifier)attr) != null) {
                    transpiler.append("this.$").append(attr.toString()).append(" = null;").newLine();
                }
            });
        }
    }

    protected void transpileMethods(Transpiler transpiler) {
        this.methods.stream().filter(decl -> !(decl instanceof SetterMethodDeclaration) && !(decl instanceof GetterMethodDeclaration)).forEach(method -> {
            Transpiler t = transpiler.newChildTranspiler(null);
            method.transpile(t);
            t.flush();
        });
    }

    protected void transpileLocalAttributes(Transpiler transpiler) {
        Set<Identifier> attributes = this.getLocalAttributes(transpiler.getContext());
        if (attributes != null) {
            transpiler.append("this.$mutable = true;").newLine();
            transpiler.append("values = Object.assign({}, copyFrom, values);").newLine();
            attributes.forEach(attr -> {
                AttributeDeclaration decl = transpiler.getContext().getRegisteredDeclaration(AttributeDeclaration.class, (Identifier)attr);
                boolean isEnum = this.isEnumeratedAttribute(transpiler.getContext(), (Identifier)attr);
                transpiler.append("this.setMember('").append(attr.toString()).append("', values.hasOwnProperty('").append(attr.toString()).append("') ? values.").append(attr.toString()).append(" : null").append(", ").append(decl.isStorable(transpiler.getContext())).append(", mutable").append(", ").append(isEnum).append(");").newLine();
            });
        }
    }

    private boolean isEnumeratedAttribute(Context context, Identifier attr) {
        IDeclaration decl = context.getRegisteredDeclaration(IDeclaration.class, attr);
        decl = context.getRegisteredDeclaration(IDeclaration.class, decl.getType(context).getTypeNameId());
        return decl instanceof IEnumeratedDeclaration;
    }

    protected void transpileSuperConstructor(Transpiler transpiler) {
        if (this.derivedFrom != null && this.derivedFrom.size() > 0) {
            this.derivedFrom.forEach(derived -> transpiler.append(derived.toString()).append(".call(this, copyFrom, values, mutable);").newLine());
        } else {
            this.transpileRootConstructor(transpiler).newLine();
        }
    }

    protected Transpiler transpileRootConstructor(Transpiler transpiler) {
        return transpiler.append("$Root.call(this);");
    }
}

