/*
 * Decompiled with CFR 0.152.
 */
package prompto.declaration;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import prompto.compiler.ClassConstant;
import prompto.compiler.ClassFile;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Descriptor;
import prompto.compiler.FieldConstant;
import prompto.compiler.FieldInfo;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.InterfaceType;
import prompto.compiler.LocalVariableTableAttribute;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.NameAndTypeConstant;
import prompto.compiler.NamedType;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.compiler.StringConstant;
import prompto.declaration.BaseMethodDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.grammar.Identifier;
import prompto.grammar.ParameterList;
import prompto.intrinsic.PromptoMethod;
import prompto.param.CategoryParameter;
import prompto.param.CodeParameter;
import prompto.param.IParameter;
import prompto.param.ValuedCodeParameter;
import prompto.parser.ISection;
import prompto.problem.IProblemListener;
import prompto.runtime.Context;
import prompto.statement.DeclarationStatement;
import prompto.statement.StatementList;
import prompto.transpiler.Transpiler;
import prompto.type.DictType;
import prompto.type.IType;
import prompto.type.MethodType;
import prompto.type.TextType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.value.CodeValue;
import prompto.value.IValue;

public class ConcreteMethodDeclaration
extends BaseMethodDeclaration
implements IMethodDeclaration {
    StatementList statements;
    DeclarationStatement<IMethodDeclaration> declarationOf;
    Map<Identifier, ValuedCodeParameter> codeParameters;

    public ConcreteMethodDeclaration(Identifier name, ParameterList parameters, IType returnType, StatementList statements) {
        super(name, parameters, returnType);
        if (statements == null) {
            statements = new StatementList();
        }
        this.statements = statements;
        statements.stream().filter(s -> s instanceof DeclarationStatement).map(s -> (DeclarationStatement)s).forEach(s -> s.getDeclaration().setClosureOf(this));
    }

    public StatementList getStatements() {
        return this.statements;
    }

    @Override
    public void setDeclarationOf(DeclarationStatement<IMethodDeclaration> statement) {
        this.declarationOf = statement;
    }

    @Override
    public DeclarationStatement<IMethodDeclaration> getDeclarationOf() {
        return this.declarationOf;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public ISection locateSection(ISection section) {
        return this.statements.locateSection(section);
    }

    @Override
    public void declarationToDialect(CodeWriter writer) {
        if (writer.isGlobalContext()) {
            writer = writer.newLocalWriter();
        }
        this.registerParameters(writer.getContext());
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
    }

    protected void toMDialect(CodeWriter writer) {
        writer.append("def ");
        writer.append(this.getName());
        writer.append(" (");
        this.parameters.toDialect(writer);
        writer.append(")");
        if (this.returnType != null && this.returnType != VoidType.instance()) {
            writer.append("->");
            this.returnType.toDialect(writer);
        }
        writer.append(":\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    protected void toEDialect(CodeWriter writer) {
        writer.append("define ");
        writer.append(this.getName());
        writer.append(" as method ");
        this.parameters.toDialect(writer);
        if (this.returnType != null && this.returnType != VoidType.instance()) {
            writer.append("returning ");
            this.returnType.toDialect(writer);
            writer.append(" ");
        }
        writer.append("doing:\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    protected void toODialect(CodeWriter writer) {
        if (this.returnType != null && this.returnType != VoidType.instance()) {
            this.returnType.toDialect(writer);
            writer.append(" ");
        }
        writer.append("method ");
        writer.append(this.getName());
        writer.append(" (");
        this.parameters.toDialect(writer);
        writer.append(") {\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
        writer.append("}\n");
    }

    @Override
    public IType check(Context context, boolean isStart) {
        if (this.canBeChecked(context, isStart)) {
            return this.fullCheck(context, isStart);
        }
        return VoidType.instance();
    }

    private boolean canBeChecked(Context context, boolean isStart) {
        if (isStart) {
            return !this.isTemplate();
        }
        return true;
    }

    @Override
    public boolean isTemplate() {
        if (this.parameters == null) {
            return false;
        }
        return this.parameters.stream().anyMatch(param -> param instanceof CodeParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IType fullCheck(Context context, boolean isStart) {
        IProblemListener listener = context.getProblemListener();
        listener.pushDeclaration(this);
        try {
            if (isStart) {
                context = context.newLocalContext();
                this.registerParameters(context);
            }
            if (this.parameters != null) {
                this.parameters.check(context);
            }
            IType iType = this.checkStatements(context);
            return iType;
        }
        finally {
            listener.popDeclaration();
        }
    }

    protected IType checkStatements(Context context) {
        return this.statements.check(context, this.returnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IType checkChild(Context context) {
        IProblemListener listener = context.getProblemListener();
        listener.pushDeclaration(this);
        try {
            if (this.parameters != null) {
                this.parameters.check(context);
            }
            Context child = context.newChildContext();
            this.registerParameters(child);
            IType iType = this.checkStatements(child);
            return iType;
        }
        finally {
            listener.popDeclaration();
        }
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        return this.statements.interpret(context);
    }

    @Override
    public void compile(Context context, boolean isStart, ClassFile classFile) {
        this.compile(context, isStart, classFile, this.getName());
    }

    public void compile(Context context, boolean isStart, ClassFile classFile, String methodName) {
        context = this.prepareContext(context, isStart);
        IType returnType = this.check(context, false);
        MethodInfo method = this.createMethodInfo(context, classFile, returnType, methodName);
        this.registerLocals(context, classFile, method);
        this.produceByteCode(context, method, returnType);
    }

    private void produceByteCode(Context context, MethodInfo method, IType returnType) {
        this.statements.compile(context, method, new Flags().withMember(this.memberOf != null));
        if (returnType == VoidType.instance()) {
            method.addInstruction(Opcode.RETURN, new IOperand[0]);
        }
    }

    protected void registerLocals(Context context, ClassFile classFile, MethodInfo method) {
        if (Modifier.isAbstract(classFile.getModifiers())) {
            method.addModifier(8);
        } else {
            method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        }
        List<IParameter> params = this.parameters.stripOutTemplateParameters();
        params.forEach(param -> param.registerLocal(context, method, new Flags()));
        params.forEach(param -> param.extractLocal(context, method, new Flags()));
    }

    @Override
    public String compileTemplate(Context context, boolean isStart, ClassFile classFile) {
        String methodName = this.computeTemplateName(classFile);
        this.compile(context, isStart, classFile, methodName);
        return methodName;
    }

    private String computeTemplateName(ClassFile classFile) {
        String methodName;
        int i = 0;
        while (classFile.hasMethod(methodName = this.getName() + '$' + ++i)) {
        }
        return methodName;
    }

    @Override
    public boolean isEligibleAsMain() {
        IType type;
        IParameter param;
        if (this.parameters.size() == 0) {
            return true;
        }
        if (this.parameters.size() == 1 && (param = (IParameter)this.parameters.getFirst()) instanceof CategoryParameter && (type = ((CategoryParameter)param).getType()) instanceof DictType) {
            return ((DictType)type).getItemType() == TextType.instance();
        }
        return super.isEligibleAsMain();
    }

    public Type compileClosureClass(Context context, MethodInfo method) {
        IType returnType = this.checkChild(context);
        InterfaceType intf = new InterfaceType(this.parameters, returnType);
        Type innerType = this.getClosureClassType(method);
        ClassFile classFile = new ClassFile(innerType);
        classFile.setSuperClass(new ClassConstant((Type)((Object)Object.class)));
        classFile.addAttribute(intf.computeSignature(context, (Type)((Object)Object.class)));
        classFile.addInterface(intf.getInterfaceType());
        classFile.setEnclosingMethod(method);
        LocalVariableTableAttribute locals = method.getLocals();
        this.compileClosureFields(context, classFile, locals);
        this.compileClosureConstructor(context, classFile, locals);
        context = context.newClosureContext(new MethodType(this));
        this.registerParameters(context);
        this.compile(context, false, classFile, intf.getInterfaceMethodName());
        method.getClassFile().addInnerClass(classFile);
        return innerType;
    }

    private Type getClosureClassType(MethodInfo method) {
        String innerClassName = method.getClassFile().getThisClass().getType().getTypeName();
        if (this.closureOf != null && this.closureOf.getMemberOf() != null) {
            innerClassName = innerClassName + "$" + this.closureOf.getName();
        }
        innerClassName = innerClassName + "$" + this.getName();
        return new NamedType(innerClassName);
    }

    private void compileClosureConstructor(Context context, ClassFile classFile, LocalVariableTableAttribute locals) {
        if (locals.getEntries().isEmpty()) {
            CompilerUtils.compileEmptyConstructor(classFile);
        } else {
            Descriptor.Method proto = this.getClosureConstructorProto(locals);
            MethodInfo method = classFile.newMethod("<init>", proto);
            method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_UninitializedThis, classFile.getThisClass());
            locals.getEntries().forEach(local -> {
                String name;
                Type type = ((StackLocal.ObjectLocal)local).getClassName().getType();
                String string = name = "this".equals(local.getName()) ? "this$0" : local.getName();
                if ("this".equals(name)) {
                    name = "this$0";
                    type = CompilerUtils.categoryConcreteTypeFrom(type.getTypeName());
                }
                method.registerLocal(name, IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(type));
            });
            method.addInstruction(Opcode.ALOAD_0, classFile.getThisClass());
            MethodConstant m = new MethodConstant(classFile.getSuperClass(), "<init>", Void.TYPE);
            method.addInstruction(Opcode.INVOKESPECIAL, m);
            locals.getEntries().forEach(local -> {
                method.addInstruction(Opcode.ALOAD_0, classFile.getThisClass());
                Type type = ((StackLocal.ObjectLocal)local).getClassName().getType();
                String name = local.getName();
                if ("this".equals(name)) {
                    name = "this$0";
                    type = CompilerUtils.categoryConcreteTypeFrom(type.getTypeName());
                }
                CompilerUtils.compileALOAD(method, name);
                FieldConstant field = new FieldConstant(classFile.getThisClass(), name, type);
                method.addInstruction(Opcode.PUTFIELD, field);
            });
            method.addInstruction(Opcode.RETURN, new IOperand[0]);
        }
    }

    private Descriptor.Method getClosureConstructorProto(LocalVariableTableAttribute locals) {
        ArrayList list = new ArrayList();
        locals.getEntries().forEach(local -> list.add(((StackLocal.ObjectLocal)local).getClassName().getType()));
        return new Descriptor.Method(list.toArray(new Type[list.size()]), (Type)Void.TYPE);
    }

    private void compileClosureFields(Context context, ClassFile classFile, LocalVariableTableAttribute locals) {
        locals.getEntries().forEach(local -> this.compileClosureField(context, classFile, (StackLocal)local));
    }

    private void compileClosureField(Context context, ClassFile classFile, StackLocal local) {
        Type type = ((StackLocal.ObjectLocal)local).getClassName().getType();
        String name = local.getName();
        if ("this".equals(name)) {
            name = "this$0";
            type = CompilerUtils.categoryConcreteTypeFrom(type.getTypeName());
        }
        FieldInfo field = new FieldInfo(name, type);
        classFile.addField(field);
    }

    public ResultInfo compileMethodInstance(Context context, MethodInfo method, Flags flags) {
        if (this.closureOf != null) {
            return this.compileClosureInstance(context, method, flags);
        }
        return this.compileMethodReference(context, method, flags);
    }

    private ResultInfo compileMethodReference(Context context, MethodInfo method, Flags flags) {
        Type methodsClassType = this.memberOf == null ? CompilerUtils.getGlobalMethodType(this.id) : CompilerUtils.getCategoryConcreteType(this.memberOf.getId());
        method.addInstruction(Opcode.LDC, new ClassConstant(methodsClassType));
        method.addInstruction(Opcode.LDC, new StringConstant(this.id.toString()));
        if (this.memberOf == null) {
            method.addInstruction(Opcode.ACONST_NULL, new ClassConstant((Type)((Object)Object.class)));
        } else {
            method.addInstruction(Opcode.ALOAD_0, new ClassConstant((Type)((Object)Object.class)));
        }
        NameAndTypeConstant nameAndType = new NameAndTypeConstant("newMethodReference", new Descriptor.Method(new Type[]{Class.class, String.class, Object.class, Object.class}));
        MethodConstant mc = new MethodConstant(new ClassConstant((Type)((Object)PromptoMethod.class)), nameAndType);
        method.addInstruction(Opcode.INVOKESTATIC, mc);
        return new ResultInfo(methodsClassType, new ResultInfo.Flag[0]);
    }

    public ResultInfo compileClosureInstance(Context context, MethodInfo method, Flags flags) {
        Type innerType = this.getClosureClassType(method);
        LocalVariableTableAttribute locals = method.getLocals();
        if (locals.getEntries().isEmpty()) {
            return CompilerUtils.compileNewInstance(method, innerType);
        }
        CompilerUtils.compileNewRawInstance(method, innerType);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        locals.getEntries().forEach(local -> CompilerUtils.compileALOAD(method, local.getName()));
        Descriptor.Method proto = this.getClosureConstructorProto(locals);
        MethodConstant c = new MethodConstant(innerType, "<init>", proto);
        method.addInstruction(Opcode.INVOKESPECIAL, c);
        return new ResultInfo(innerType, new ResultInfo.Flag[0]);
    }

    @Override
    public void declare(Transpiler transpiler) {
        if (this.declaring) {
            return;
        }
        IProblemListener listener = transpiler.getContext().getProblemListener();
        listener.pushDeclaration(this);
        this.declaring = true;
        try {
            if (this.returnType != null) {
                this.returnType.declare(transpiler);
            }
            if (this.memberOf != null) {
                this.memberOf.declare(transpiler);
            } else {
                transpiler = transpiler.newLocalTranspiler();
                transpiler.declare(this);
                this.declareParameters(transpiler);
            }
            this.registerParameters(transpiler.getContext());
            this.statements.declare(transpiler);
        }
        finally {
            this.declaring = false;
            listener.popDeclaration();
        }
    }

    @Override
    public void declareChild(Transpiler transpiler) {
        this.declareParameters(transpiler);
        transpiler = transpiler.newChildTranspiler(null);
        this.registerParameters(transpiler.getContext());
        this.statements.declare(transpiler);
    }

    @Override
    public void fullDeclare(Transpiler transpiler, Identifier methodName) {
        ConcreteMethodDeclaration declaration = new ConcreteMethodDeclaration(this.getId(), this.getParameters(), this.returnType, this.statements);
        declaration.memberOf = this.memberOf;
        transpiler.declare(declaration);
        this.statements.declare(transpiler);
        declaration.codeParameters = new HashMap<Identifier, ValuedCodeParameter>();
        this.getParameters().stream().filter(param -> param instanceof CodeParameter).forEach(param -> {
            CodeValue value = (CodeValue)transpiler.getContext().getValue(param.getId());
            concreteMethodDeclaration.codeParameters.put(param.getId(), new ValuedCodeParameter(param.getId(), value));
        });
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        this.registerParameters(transpiler.getContext());
        this.registerCodeArguments(transpiler.getContext());
        this.transpileProlog(transpiler);
        this.statements.transpile(transpiler);
        this.transpileEpilog(transpiler);
        return true;
    }

    private void registerCodeArguments(Context context) {
        if (this.isTemplate()) {
            if (this.codeParameters == null) {
                return;
            }
            this.codeParameters.forEach((k, v) -> context.setValue(v.getId(), v.getValue()));
        }
    }
}

