/*
 * Decompiled with CFR 0.152.
 */
package prompto.declaration;

import java.util.LinkedList;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.ConcreteMethodDeclaration;
import prompto.declaration.EnumeratedNativeDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.declaration.TestMethodDeclaration;
import prompto.runtime.Context;
import prompto.utils.CodeWriter;

public class DeclarationList
extends LinkedList<IDeclaration> {
    private static final long serialVersionUID = 1L;

    public DeclarationList() {
    }

    public DeclarationList(IDeclaration item) {
        this.add(item);
    }

    @Override
    public boolean add(IDeclaration decl) {
        if (decl != null) {
            return super.add(decl);
        }
        return false;
    }

    public void register(Context context) {
        this.registerAttributes(context);
        this.registerCategories(context);
        this.registerEnumerated(context);
        this.registerMethods(context);
        this.registerTests(context);
    }

    private void registerTests(Context context) {
        for (IDeclaration d2 : this.stream().filter(d -> d instanceof TestMethodDeclaration)::iterator) {
            d2.register(context);
        }
    }

    private void registerMethods(Context context) {
        for (IDeclaration d2 : this.stream().filter(d -> d instanceof IMethodDeclaration)::iterator) {
            d2.register(context);
        }
    }

    private void registerEnumerated(Context context) {
        for (IDeclaration d2 : this.stream().filter(d -> d instanceof EnumeratedNativeDeclaration)::iterator) {
            d2.register(context);
        }
    }

    private void registerCategories(Context context) {
        for (IDeclaration d2 : this.stream().filter(d -> d instanceof CategoryDeclaration)::iterator) {
            d2.register(context);
        }
    }

    private void registerAttributes(Context context) {
        for (IDeclaration d2 : this.stream().filter(d -> d instanceof AttributeDeclaration)::iterator) {
            d2.register(context);
        }
    }

    public void check(Context context) {
        for (IDeclaration declaration : this) {
            if (declaration instanceof IMethodDeclaration) {
                ((IMethodDeclaration)declaration).check(context, true);
                continue;
            }
            declaration.check(context);
        }
    }

    public ConcreteMethodDeclaration findMain() {
        for (IDeclaration declaration : this) {
            ConcreteMethodDeclaration method;
            if (!(declaration instanceof ConcreteMethodDeclaration) || !(method = (ConcreteMethodDeclaration)declaration).getName().equals("main")) continue;
            return method;
        }
        return null;
    }

    public void toDialect(CodeWriter writer) {
        for (IDeclaration declaration : this) {
            declaration.toDialect(writer);
            writer.append("\n");
        }
    }
}

