/*
 * Decompiled with CFR 0.152.
 */
package prompto.declaration;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import prompto.compiler.ClassConstant;
import prompto.compiler.ClassFile;
import prompto.compiler.CompilerException;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Descriptor;
import prompto.compiler.FieldConstant;
import prompto.compiler.FieldInfo;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.declaration.ConcreteCategoryDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IEnumeratedDeclaration;
import prompto.error.SyntaxError;
import prompto.expression.CategorySymbol;
import prompto.expression.Symbol;
import prompto.grammar.CategorySymbolList;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoCategorySymbol;
import prompto.intrinsic.PromptoEnum;
import prompto.runtime.Context;
import prompto.transpiler.ITranspilable;
import prompto.transpiler.Transpiler;
import prompto.type.EnumeratedCategoryType;
import prompto.type.IType;
import prompto.type.ListType;
import prompto.utils.CodeWriter;
import prompto.utils.IdentifierList;

public class EnumeratedCategoryDeclaration
extends ConcreteCategoryDeclaration
implements IEnumeratedDeclaration<CategorySymbol> {
    CategorySymbolList symbolsList;
    Map<String, CategorySymbol> symbolsMap;
    EnumeratedCategoryType type;

    public EnumeratedCategoryDeclaration(Identifier name) {
        super(name);
        this.type = new EnumeratedCategoryType(name);
    }

    public EnumeratedCategoryDeclaration(Identifier name, IdentifierList attrs, IdentifierList derived, CategorySymbolList symbols) {
        super(name, attrs, derived, null);
        this.type = new EnumeratedCategoryType(name);
        this.setSymbols(symbols);
    }

    @Override
    public IDeclaration.DeclarationType getDeclarationType() {
        return IDeclaration.DeclarationType.ENUMERATED;
    }

    public CategorySymbolList getSymbolsList() {
        return this.symbolsList;
    }

    @Override
    public Map<String, CategorySymbol> getSymbolsMap() {
        return this.symbolsMap;
    }

    public void setSymbols(CategorySymbolList symbols) {
        this.symbolsMap = new HashMap<String, CategorySymbol>();
        this.symbolsList = symbols;
        for (CategorySymbol s : symbols) {
            s.setType(this.type);
            this.symbolsMap.put(s.getName(), s);
        }
        symbols.setType(new ListType(this.type));
    }

    @Override
    public boolean hasAttribute(Context context, Identifier name) {
        if ("name".equals(name.toString())) {
            return true;
        }
        return super.hasAttribute(context, name);
    }

    @Override
    protected Set<Identifier> getLocalAttributes(Context context) {
        Identifier nameId;
        Set<Identifier> attributes = super.getLocalAttributes(context);
        if (attributes == null) {
            attributes = new HashSet<Identifier>();
        }
        if (!attributes.contains(nameId = new Identifier("name"))) {
            attributes.add(nameId);
        }
        return attributes;
    }

    @Override
    protected void toODialect(CodeWriter writer) {
        writer.append("enumerated category ");
        writer.append(this.getName());
        if (this.attributes != null) {
            writer.append('(');
            this.attributes.toDialect(writer, true);
            writer.append(")");
        }
        if (this.derivedFrom != null) {
            writer.append(" extends ");
            this.derivedFrom.toDialect(writer, true);
        }
        writer.append(" {\n");
        writer.indent();
        for (Symbol symbol : this.symbolsList) {
            ((CategorySymbol)symbol).toDialect(writer);
            writer.append(";\n");
        }
        writer.dedent();
        writer.append("}\n");
    }

    @Override
    protected void toEDialect(CodeWriter writer) {
        writer.append("define ");
        writer.append(this.getName());
        writer.append(" as enumerated ");
        if (this.derivedFrom != null) {
            this.derivedFrom.toDialect(writer, true);
        } else {
            writer.append("category");
        }
        if (this.attributes != null && this.attributes.size() > 0) {
            if (this.attributes.size() == 1) {
                writer.append(" with attribute ");
            } else {
                writer.append(" with attributes ");
            }
            this.attributes.toDialect(writer, true);
            writer.append(", and symbols:\n");
        } else {
            writer.append(" with symbols:\n");
        }
        writer.indent();
        for (Symbol symbol : this.symbolsList) {
            symbol.toDialect(writer);
            writer.append("\n");
        }
        writer.dedent();
    }

    @Override
    protected void toMDialect(CodeWriter writer) {
        writer.append("enum ");
        writer.append(this.getName());
        writer.append("(");
        if (this.derivedFrom != null) {
            this.derivedFrom.toDialect(writer, false);
            if (this.attributes != null && this.attributes.size() > 0) {
                writer.append(", ");
            }
        }
        if (this.attributes != null && this.attributes.size() > 0) {
            this.attributes.toDialect(writer, false);
        }
        writer.append("):\n");
        writer.indent();
        for (Symbol symbol : this.symbolsList) {
            symbol.toDialect(writer);
            writer.append("\n");
        }
        writer.dedent();
    }

    @Override
    public void register(Context context) {
        context.registerDeclaration(this);
        for (Symbol s : this.symbolsList) {
            s.register(context);
        }
    }

    @Override
    public IType check(Context context) {
        super.check(context);
        for (Symbol s : this.symbolsList) {
            s.check(context);
        }
        return this.getType(context);
    }

    @Override
    public EnumeratedCategoryType getType(Context context) {
        return this.type;
    }

    @Override
    protected ClassFile compileConcreteClass(Context context, String fullName) {
        try {
            Type concreteType = CompilerUtils.categoryConcreteParentTypeFrom(fullName);
            ClassFile classFile = new ClassFile(concreteType);
            this.compileSuperClass(context, classFile, new Flags());
            this.compileInterface(context, classFile, new Flags());
            classFile.addInterface((Type)((Object)PromptoEnum.class));
            this.compileCategoryField(context, classFile, new Flags());
            this.compileSymbolFields(context, classFile, new Flags());
            this.compileClassConstructor(context, classFile, new Flags());
            this.compileFields(context, classFile, new Flags());
            this.compileEmptyConstructor(context, classFile, new Flags());
            this.compileSuperConstructor(context, classFile, new Flags());
            this.compileMethods(context, classFile, new Flags());
            this.compileToString(context, classFile, new Flags());
            return classFile;
        }
        catch (SyntaxError e) {
            throw new CompilerException(e);
        }
    }

    private void compileToString(Context context, ClassFile classFile, Flags flags) {
        MethodInfo method = classFile.newMethod("toString", new Descriptor.Method(new Type[]{String.class}));
        StackLocal local = method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        CompilerUtils.compileALOAD(method, local);
        MethodConstant mc = new MethodConstant(classFile.getThisClass(), "getName", new Type[]{String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, mc);
        method.addInstruction(Opcode.ARETURN, new IOperand[0]);
    }

    private void compileSuperConstructor(Context context, ClassFile classFile, Flags flags) {
        if (this.isPromptoError(context)) {
            CompilerUtils.compileSuperConstructor(classFile, String.class);
        }
    }

    @Override
    protected boolean needsClassConstructor(Context context) {
        return true;
    }

    @Override
    protected ClassConstant getSuperClass(Context context) {
        if ("Error".equals(this.getName())) {
            return new ClassConstant((Type)((Object)RuntimeException.class));
        }
        return super.getSuperClass(context);
    }

    @Override
    public boolean isPromptoRoot(Context context) {
        return !this.isPromptoError(context);
    }

    @Override
    public boolean isPromptoError(Context context) {
        if ("Error".equals(this.getName())) {
            return true;
        }
        return super.isPromptoError(context);
    }

    @Override
    protected void compileClassConstructorBody(Context context, MethodInfo method, Flags flags) {
        if (this.isStorable(context)) {
            this.compilePopulateCategoryField(context, method, flags);
        }
        for (CategorySymbol s : this.getSymbolsList()) {
            this.compilePopulateSymbolField(context, method, flags, s);
        }
    }

    @Override
    protected void compileMethods(Context context, ClassFile classFile, Flags flags) {
        this.compileGetSymbolsMethod(context, classFile, new Flags());
        this.compileSymbolOfMethod(context, classFile, new Flags());
        super.compileMethods(context, classFile, flags);
    }

    @Override
    protected void compileFields(Context context, ClassFile classFile, Flags flags) {
        super.compileFields(context, classFile, flags);
        Identifier name = new Identifier("name");
        if (!super.hasAttribute(context, name)) {
            this.compileField(context, classFile, flags, name);
        }
    }

    private void compileGetSymbolsMethod(Context context, ClassFile classFile, Flags flags) {
        MethodInfo method = classFile.newMethod("getSymbols", new Descriptor.Method(new Type[]{List.class}));
        method.addModifier(8);
        method.addInstruction(Opcode.LDC, classFile.getThisClass());
        MethodConstant m = new MethodConstant((Type)((Object)PromptoCategorySymbol.class), "getCategorySymbols", new Descriptor.Method(new Type[]{Class.class, List.class}));
        method.addInstruction(Opcode.INVOKESTATIC, m);
        method.addInstruction(Opcode.ARETURN, new IOperand[0]);
    }

    private void compileSymbolOfMethod(Context context, ClassFile classFile, Flags flags) {
        MethodInfo method = classFile.newMethod("symbolOf", new Descriptor.Method(new Type[]{String.class, classFile.getThisClass().getType()}));
        method.addModifier(8);
        method.addInstruction(Opcode.LDC, classFile.getThisClass());
        method.addInstruction(Opcode.ALOAD_0, new ClassConstant((Type)((Object)String.class)));
        MethodConstant m = new MethodConstant((Type)((Object)PromptoCategorySymbol.class), "categorySymbolOf", new Descriptor.Method(new Type[]{Class.class, String.class, Object.class}));
        method.addInstruction(Opcode.INVOKESTATIC, m);
        method.addInstruction(Opcode.CHECKCAST, classFile.getThisClass());
        method.addInstruction(Opcode.ARETURN, new IOperand[0]);
    }

    private void compilePopulateSymbolField(Context context, MethodInfo method, Flags flags, CategorySymbol symbol) {
        ClassConstant thisClass = method.getClassFile().getThisClass();
        Type fieldType = this.getFieldType(context, thisClass.getType(), symbol);
        if (fieldType == thisClass.getType()) {
            symbol.compileCallConstructor(context, method, flags);
        } else {
            symbol.compileInnerClassAndCallConstructor(context, method, flags, thisClass, fieldType);
        }
        FieldConstant f = new FieldConstant(thisClass, symbol.getName(), fieldType);
        method.addInstruction(Opcode.PUTSTATIC, f);
    }

    private void compileSymbolFields(Context context, ClassFile classFile, Flags flags) {
        this.getSymbolsList().forEach(s -> this.compileSymbolField(context, classFile, flags, (Symbol)s));
    }

    private void compileSymbolField(Context context, ClassFile classFile, Flags flags, Symbol symbol) {
        Type type = this.getFieldType(context, classFile.getThisClass().getType(), symbol);
        FieldInfo field = new FieldInfo(symbol.getName(), type);
        field.clearModifier(4);
        field.addModifier(9);
        classFile.addField(field);
    }

    private Type getFieldType(Context context, Type thisType, Symbol symbol) {
        if (this.isPromptoRoot(context)) {
            return thisType;
        }
        return CompilerUtils.getExceptionType(thisType, symbol.getName());
    }

    public ResultInfo compileGetStaticMember(Context context, MethodInfo method, Flags flags, Identifier id) {
        if ("symbols".equals(id.toString())) {
            Type concreteType = CompilerUtils.getCategoryEnumConcreteType(this.getId());
            String getterName = CompilerUtils.getterName("symbols");
            MethodConstant m = new MethodConstant(concreteType, getterName, new Type[]{List.class});
            method.addInstruction(Opcode.INVOKESTATIC, m);
            return new ResultInfo((Type)((Object)List.class), new ResultInfo.Flag[0]);
        }
        throw new SyntaxError("No such attribute " + id);
    }

    @Override
    public void ensureDeclarationOrder(Context context, List<ITranspilable> list, Set<ITranspilable> set) {
        if (set.contains(this)) {
            return;
        }
        if (this.isUserError(context)) {
            list.add(this);
            set.add(this);
        } else {
            this.symbolsList.forEach(symbol -> symbol.ensureDeclarationOrder(context, list, set));
            super.ensureDeclarationOrder(context, list, set);
        }
    }

    private boolean isUserError(Context context) {
        return this.derivedFrom != null && this.derivedFrom.size() == 1 && ((Identifier)this.derivedFrom.get(0)).toString().equals("Error");
    }

    @Override
    public void declare(Transpiler transpiler) {
        if ("Error".equals(this.getName())) {
            return;
        }
        super.declare(transpiler);
        transpiler.require("List");
        this.symbolsList.forEach(symbol -> symbol.declareArguments(transpiler));
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        if (this.isUserError(transpiler.getContext())) {
            this.transpileUserError(transpiler);
        } else {
            this.transpileEnumerated(transpiler);
        }
        return true;
    }

    private void transpileEnumerated(Transpiler transpiler) {
        super.transpile(transpiler);
        transpiler.newLine();
        transpiler.append(this.getName()).append(".prototype.toString = function() { return this.name; };").newLine();
        if (this.hasAttribute(transpiler.getContext(), new Identifier("text"))) {
            transpiler.append(this.getName()).append(".prototype.getText = function() { return this.text; };").newLine();
        } else {
            transpiler.append(this.getName()).append(".prototype.getText = ").append(this.getName()).append(".prototype.toString;").newLine();
        }
        this.symbolsList.forEach(symbol -> symbol.initialize(transpiler));
        this.transpileSymbols(transpiler);
    }

    private void transpileUserError(Transpiler transpiler) {
        if (transpiler.getEngine().supportsClass()) {
            this.transpileUserErrorClass(transpiler);
        } else {
            this.transpileUserErrorPrototype(transpiler);
        }
        this.symbolsList.forEach(symbol -> symbol.initializeError(transpiler));
        this.transpileSymbols(transpiler);
    }

    private void transpileUserErrorPrototype(Transpiler transpiler) {
        transpiler.append("function ").append(this.getName()).append(" (values) {").indent().append("if (!Error.captureStackTrace)").indent().append("this.stack = (new Error()).stack;").dedent().append("else").indent().append("Error.captureStackTrace(this, this.constructor);").dedent().append("this.message = values.text;").newLine().append("this.promptoName = values.name;").newLine().append("return this;").dedent().append("}").newLine().append(this.getName()).append(".prototype = Object.create(Error.prototype);").newLine().append(this.getName()).append(".prototype.constructor = ").append(this.getName()).append(";").newLine().append(this.getName()).append(".prototype.name = '").append(this.getName()).append("';").newLine().append(this.getName()).append(".prototype.toString = function() { return this.message; };").newLine().append(this.getName()).append(".prototype.getText = function() { return this.message; };").newLine();
    }

    private void transpileUserErrorClass(Transpiler transpiler) {
        transpiler.append("class ").append(this.getName()).append(" extends Error {").indent();
        transpiler.newLine();
        transpiler.append("constructor(values) {").indent();
        transpiler.append("super(values.text);").newLine();
        transpiler.append("this.name = '").append(this.getName()).append("';").newLine();
        transpiler.append("this.promptoName = values.name;").newLine();
        if (this.attributes != null) {
            this.attributes.stream().filter(attr -> !"name".equals(attr.toString()) && !"text".equals(attr.toString())).forEach(attr -> {
                transpiler.append("this.").append(attr.toString()).append(" = values.hasownProperty('").append(attr.toString()).append("') ? values.").append(attr.toString()).append(" : null;");
                transpiler.newLine();
            });
        }
        transpiler.append("return this;").dedent();
        transpiler.append("}").newLine();
        transpiler.append("toString() {").indent().append("return this.message;").dedent().append("}").newLine();
        transpiler.append("getText() {").indent().append("return this.message;").dedent().append("}").newLine();
        transpiler.dedent().append("}").newLine();
    }

    private void transpileSymbols(Transpiler transpiler) {
        Stream<String> names = this.symbolsList.stream().map(symbol -> symbol.getName());
        transpiler.append(this.getName()).append(".symbols = new List(false, [").append(names.collect(Collectors.joining(", "))).append("]);").newLine();
        transpiler.append(this.getName()).append(".symbolOf = function(name) { return eval(name); };").newLine();
    }
}

