/*
 * Decompiled with CFR 0.152.
 */
package prompto.declaration;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import prompto.compiler.ClassConstant;
import prompto.compiler.ClassFile;
import prompto.compiler.CompilerException;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Descriptor;
import prompto.compiler.FieldConstant;
import prompto.compiler.FieldInfo;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.NamedType;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.compiler.StringConstant;
import prompto.declaration.BaseDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IEnumeratedDeclaration;
import prompto.error.InvalidSymbolError;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.NativeSymbol;
import prompto.expression.Symbol;
import prompto.grammar.INamed;
import prompto.grammar.Identifier;
import prompto.grammar.NativeSymbolList;
import prompto.intrinsic.PromptoNativeSymbol;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.EnumeratedNativeType;
import prompto.type.IType;
import prompto.type.ListType;
import prompto.type.NativeType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public class EnumeratedNativeDeclaration
extends BaseDeclaration
implements IEnumeratedDeclaration<NativeSymbol> {
    NativeSymbolList symbolsList;
    Map<String, NativeSymbol> symbolsMap;
    EnumeratedNativeType type;

    public EnumeratedNativeDeclaration(Identifier name, NativeType derivedFrom, NativeSymbolList symbols) {
        super(name);
        this.type = new EnumeratedNativeType(name, derivedFrom);
        this.setSymbols(symbols);
    }

    @Override
    public IDeclaration.DeclarationType getDeclarationType() {
        return IDeclaration.DeclarationType.ENUMERATED;
    }

    public NativeSymbolList getSymbolsList() {
        return this.symbolsList;
    }

    @Override
    public Map<String, NativeSymbol> getSymbolsMap() {
        return this.symbolsMap;
    }

    public void setSymbols(NativeSymbolList symbols) {
        this.symbolsMap = new HashMap<String, NativeSymbol>();
        this.symbolsList = symbols;
        for (NativeSymbol s : symbols) {
            s.setType(this.type);
            this.symbolsMap.put(s.getName(), s);
        }
        symbols.setType(new ListType(this.type));
    }

    @Override
    public void declarationToDialect(CodeWriter writer) {
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
    }

    private void toMDialect(CodeWriter writer) {
        writer.append("enum ");
        writer.append(this.getName());
        writer.append('(');
        this.type.getDerivedFrom().toDialect(writer);
        writer.append("):\n");
        writer.indent();
        for (Symbol s : this.symbolsList) {
            s.toDialect(writer);
            writer.append("\n");
        }
        writer.dedent();
    }

    private void toODialect(CodeWriter writer) {
        writer.append("enumerated ");
        writer.append(this.getName());
        writer.append('(');
        this.type.getDerivedFrom().toDialect(writer);
        writer.append(") {\n");
        writer.indent();
        for (Symbol s : this.symbolsList) {
            s.toDialect(writer);
            writer.append(";\n");
        }
        writer.dedent();
        writer.append("}\n");
    }

    private void toEDialect(CodeWriter writer) {
        writer.append("define ");
        writer.append(this.getName());
        writer.append(" as enumerated ");
        this.type.getDerivedFrom().toDialect(writer);
        writer.append(" with symbols:\n");
        writer.indent();
        for (Symbol s : this.symbolsList) {
            s.toDialect(writer);
            writer.append("\n");
        }
        writer.dedent();
    }

    @Override
    public void register(Context context) {
        context.registerDeclaration(this);
        for (Symbol s : this.symbolsList) {
            s.register(context);
        }
    }

    @Override
    public IType check(Context context) {
        for (Symbol s : this.symbolsList) {
            s.check(context);
        }
        return this.type;
    }

    @Override
    public IType getType(Context context) {
        return this.type;
    }

    public IValue readJSONValue(Context context, JsonNode value) throws PromptoError {
        if (value.isObject() && value.has("name")) {
            value = value.get("name");
        }
        String name = value.asText();
        for (Symbol symbol : this.symbolsList) {
            if (!name.equals(symbol.getName())) continue;
            return symbol.interpret(context);
        }
        name = " is not a valid " + this.getName() + " symbol.";
        throw new InvalidSymbolError(name);
    }

    public ClassFile compile(Context context, String fullName) {
        try {
            ClassFile classFile = new ClassFile(new NamedType(fullName));
            classFile.setSuperClass(new ClassConstant((Type)((Object)PromptoNativeSymbol.class)));
            this.compileSymbolFields(context, classFile, new Flags());
            this.compileNameField(context, classFile, new Flags());
            this.compileValueField(context, classFile, new Flags());
            this.compileValueConstructor(context, classFile, new Flags());
            this.compileFieldGetters(context, classFile, new Flags());
            this.compileClassConstructor(context, classFile, new Flags());
            this.compileGetSymbolsMethod(context, classFile, new Flags());
            this.compileSymbolOfMethod(context, classFile, new Flags());
            return classFile;
        }
        catch (SyntaxError e) {
            throw new CompilerException(e);
        }
    }

    private void compileFieldGetters(Context context, ClassFile classFile, Flags flags) {
        this.compileFieldGetter(context, classFile, flags, "name", (Type)((Object)String.class));
        this.compileFieldGetter(context, classFile, flags, "value", this.type.getDerivedFrom().getJavaType(context));
    }

    private void compileFieldGetter(Context context, ClassFile classFile, Flags flags, String fieldName, Type fieldType) {
        String name = CompilerUtils.getterName(fieldName);
        Descriptor.Method proto = new Descriptor.Method(fieldType);
        MethodInfo method = classFile.newMethod(name, proto);
        method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        method.addInstruction(Opcode.ALOAD_0, classFile.getThisClass());
        FieldConstant f = new FieldConstant(classFile.getThisClass(), fieldName, fieldType);
        method.addInstruction(Opcode.GETFIELD, f);
        method.addInstruction(Opcode.ARETURN, new ClassConstant(fieldType));
    }

    private void compileSymbolFields(Context context, ClassFile classFile, Flags flags) {
        this.getSymbolsList().forEach(s -> this.compileSymbolField(context, classFile, flags, (Symbol)s));
    }

    private void compileSymbolField(Context context, ClassFile classFile, Flags flags, Symbol s) {
        FieldInfo field = new FieldInfo(s.getName(), classFile.getThisClass().getType());
        field.clearModifier(4);
        field.addModifier(9);
        classFile.addField(field);
    }

    private void compileNameField(Context context, ClassFile classFile, Flags flags) {
        FieldInfo field = new FieldInfo("name", (Type)((Object)String.class));
        field.clearModifier(4);
        classFile.addField(field);
    }

    private void compileValueField(Context context, ClassFile classFile, Flags flags) {
        FieldInfo field = new FieldInfo("value", this.type.getDerivedFrom().getJavaType(context));
        field.clearModifier(4);
        classFile.addField(field);
    }

    private void compileValueConstructor(Context context, ClassFile classFile, Flags flags) {
        Descriptor.Method proto = new Descriptor.Method(this.type.getDerivedFrom().getJavaType(context), Void.TYPE);
        MethodInfo method = classFile.newMethod("<init>", proto);
        StackLocal local = method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_UninitializedThis, classFile.getThisClass());
        CompilerUtils.compileALOAD(method, local);
        MethodConstant m = new MethodConstant(classFile.getSuperClass(), "<init>", Void.TYPE);
        method.addInstruction(Opcode.INVOKESPECIAL, m);
        CompilerUtils.compileALOAD(method, local);
        StackLocal value = method.registerLocal("%value%", IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(this.type.getDerivedFrom().getJavaType(context)));
        CompilerUtils.compileALOAD(method, value);
        FieldConstant f = new FieldConstant(method.getClassFile().getThisClass(), "value", this.type.getDerivedFrom().getJavaType(context));
        method.addInstruction(Opcode.PUTFIELD, f);
        method.addInstruction(Opcode.RETURN, new IOperand[0]);
    }

    protected void compileClassConstructor(Context context, ClassFile classFile, Flags flags) {
        MethodInfo method = classFile.newMethod("<clinit>", new Descriptor.Method(Void.TYPE));
        method.addModifier(8);
        for (NativeSymbol s : this.getSymbolsList()) {
            this.compilePopulateSymbolField(context, classFile, method, flags, s);
        }
        method.addInstruction(Opcode.RETURN, new IOperand[0]);
    }

    private void compilePopulateSymbolField(Context context, ClassFile classFile, MethodInfo method, Flags flags, NativeSymbol symbol) {
        symbol.compileCallConstructor(context, method, flags);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        method.addInstruction(Opcode.LDC, new StringConstant(symbol.getName()));
        FieldConstant field = new FieldConstant(classFile.getThisClass(), "name", (Type)((Object)String.class));
        method.addInstruction(Opcode.PUTFIELD, field);
        field = new FieldConstant(classFile.getThisClass(), symbol.getName(), classFile.getThisClass().getType());
        method.addInstruction(Opcode.PUTSTATIC, field);
    }

    private void compileGetSymbolsMethod(Context context, ClassFile classFile, Flags flags) {
        MethodInfo method = classFile.newMethod("getSymbols", new Descriptor.Method(new Type[]{List.class}));
        method.addModifier(8);
        method.addInstruction(Opcode.LDC, classFile.getThisClass());
        MethodConstant m = new MethodConstant((Type)((Object)PromptoNativeSymbol.class), "getNativeSymbols", new Descriptor.Method(new Type[]{Class.class, List.class}));
        method.addInstruction(Opcode.INVOKESTATIC, m);
        method.addInstruction(Opcode.ARETURN, new IOperand[0]);
    }

    private void compileSymbolOfMethod(Context context, ClassFile classFile, Flags flags) {
        MethodInfo method = classFile.newMethod("symbolOf", new Descriptor.Method(new Type[]{String.class, PromptoNativeSymbol.class}));
        method.addModifier(8);
        method.addInstruction(Opcode.LDC, classFile.getThisClass());
        method.addInstruction(Opcode.ALOAD_0, new ClassConstant((Type)((Object)String.class)));
        MethodConstant m = new MethodConstant((Type)((Object)PromptoNativeSymbol.class), "nativeSymbolOf", new Descriptor.Method(new Type[]{Class.class, String.class, PromptoNativeSymbol.class}));
        method.addInstruction(Opcode.INVOKESTATIC, m);
        method.addInstruction(Opcode.ARETURN, new IOperand[0]);
    }

    @Override
    public void declare(Transpiler transpiler) {
        if (!transpiler.isDeclared(this)) {
            transpiler.require("List");
            transpiler.declare(this);
        }
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("function " + this.getName() + "(name, value) { this.name = name; this.value = value; return this; };");
        transpiler.newLine();
        transpiler.append(this.getName()).append(".prototype.toString = function() { return this.name; };");
        transpiler.newLine();
        this.symbolsList.forEach(symbol -> symbol.initialize(transpiler));
        List names = this.symbolsList.stream().map(INamed::getName).collect(Collectors.toList());
        transpiler.append(this.getName()).append(".symbols = new List(false, [").append(names.stream().collect(Collectors.joining(", "))).append("]);").newLine();
        transpiler.append(this.getName()).append(".symbolOf = function(name) { return eval(name); };");
        return true;
    }

    public ResultInfo compileGetStaticMember(Context context, MethodInfo method, Flags flags, Identifier id) {
        if ("symbols".equals(id.toString())) {
            Type concreteType = CompilerUtils.getNativeEnumType(this.getId());
            String getterName = CompilerUtils.getterName("symbols");
            MethodConstant m = new MethodConstant(concreteType, getterName, new Type[]{List.class});
            method.addInstruction(Opcode.INVOKESTATIC, m);
            return new ResultInfo((Type)((Object)List.class), new ResultInfo.Flag[0]);
        }
        throw new SyntaxError("No such field " + id);
    }
}

