/*
 * Decompiled with CFR 0.152.
 */
package prompto.declaration;

import prompto.compiler.ClassFile;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Descriptor;
import prompto.compiler.FieldInfo;
import prompto.compiler.Flags;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.MethodInfo;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.ConcreteMethodDeclaration;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.runtime.Context;
import prompto.statement.IStatement;
import prompto.statement.StatementList;
import prompto.transpiler.Transpiler;
import prompto.type.CategoryType;
import prompto.type.IType;
import prompto.utils.CodeWriter;

public class GetterMethodDeclaration
extends ConcreteMethodDeclaration
implements IExpression {
    public GetterMethodDeclaration(Identifier id, StatementList statements) {
        super(id, null, null, statements);
    }

    public static String getNameAsKey(Identifier id) {
        return "getter:" + id.toString();
    }

    @Override
    public String getNameAsKey() {
        return GetterMethodDeclaration.getNameAsKey(this.getId());
    }

    @Override
    protected void toODialect(CodeWriter writer) {
        writer.append("getter ");
        writer.append(this.getName());
        writer.append(" {\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
        writer.append("}\n");
    }

    @Override
    protected void toEDialect(CodeWriter writer) {
        writer.append("define ");
        writer.append(this.getName());
        writer.append(" as getter doing:\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    @Override
    protected void toMDialect(CodeWriter writer) {
        writer.append("def ");
        writer.append(this.getName());
        writer.append(" getter():\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    @Override
    public IType check(Context context) {
        AttributeDeclaration decl = context.getRegisteredDeclaration(AttributeDeclaration.class, this.getId());
        return decl.getType();
    }

    public void compile(Context context, ClassFile classFile, Flags flags, CategoryType type, FieldInfo field) {
        String name = CompilerUtils.getterName(this.getName());
        Descriptor.Method proto = new Descriptor.Method(field.getType());
        MethodInfo method = classFile.newMethod(name, proto);
        method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        context = context.newInstanceContext(type, false).newChildContext();
        for (IStatement stmt : this.statements) {
            stmt.compile(context, method, flags);
        }
    }

    @Override
    public void declare(Transpiler transpiler) {
        super.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        this.statements.transpile(transpiler);
        return true;
    }
}

