/*
 * Decompiled with CFR 0.152.
 */
package prompto.declaration;

import java.lang.reflect.Type;
import prompto.compiler.FieldInfo;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.GetterMethodDeclaration;
import prompto.grammar.Identifier;
import prompto.java.JavaNativeCall;
import prompto.runtime.Context;
import prompto.statement.IStatement;
import prompto.statement.StatementList;
import prompto.type.IType;
import prompto.value.IValue;

public class NativeGetterMethodDeclaration
extends GetterMethodDeclaration {
    JavaNativeCall statement = this.findNativeStatement();

    public NativeGetterMethodDeclaration(Identifier id, StatementList statements) {
        super(id, statements);
    }

    private JavaNativeCall findNativeStatement() {
        for (IStatement statement : this.statements) {
            if (!(statement instanceof JavaNativeCall)) continue;
            return (JavaNativeCall)statement;
        }
        return null;
    }

    @Override
    public IType checkChild(Context context) {
        return this.check(context);
    }

    @Override
    public IValue interpret(Context context) {
        return this.doInterpretNative(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IValue doInterpretNative(Context context) {
        context.enterStatement(this.statement);
        try {
            IValue result = this.statement.interpretNative(context, this.returnType);
            if (result != null) {
                IValue iValue = result;
                return iValue;
            }
        }
        finally {
            context.leaveStatement(this.statement);
        }
        return null;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        if (this.statement != null) {
            AttributeDeclaration decl = context.getRegisteredDeclaration(AttributeDeclaration.class, this.getId());
            FieldInfo field = decl.toFieldInfo(context);
            return this.statement.compile(context, method, flags.withInline(true).withMember(true).withGetter(field));
        }
        method.addInstruction(Opcode.ACONST_NULL, new IOperand[0]);
        return new ResultInfo((Type)((Object)Object.class), new ResultInfo.Flag[0]);
    }
}

