/*
 * Decompiled with CFR 0.152.
 */
package prompto.declaration;

import prompto.compiler.ClassFile;
import prompto.compiler.CompilerException;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.declaration.ConcreteMethodDeclaration;
import prompto.error.NullReferenceError;
import prompto.error.PromptoError;
import prompto.grammar.ArgumentList;
import prompto.grammar.Identifier;
import prompto.grammar.ParameterList;
import prompto.java.JavaNativeCall;
import prompto.runtime.Context;
import prompto.statement.IStatement;
import prompto.statement.NativeCall;
import prompto.statement.StatementList;
import prompto.type.IType;
import prompto.type.TypeMap;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public class NativeMethodDeclaration
extends ConcreteMethodDeclaration {
    JavaNativeCall statement = this.findCall(JavaNativeCall.class);

    public NativeMethodDeclaration(Identifier name, ParameterList arguments, IType returnType, StatementList instructions) {
        super(name, arguments, returnType, instructions);
    }

    public <T extends NativeCall> T findCall(Class<T> klass) {
        for (IStatement statement : this.statements) {
            if (!klass.isAssignableFrom(statement.getClass())) continue;
            return (T)((NativeCall)statement);
        }
        return null;
    }

    @Override
    protected IType checkStatements(Context context) {
        if (this.statement != null && context.getProblemListener().isCheckNative()) {
            return this.checkNative(context);
        }
        if (this.returnType != null) {
            return this.returnType;
        }
        return VoidType.instance();
    }

    private IType checkNative(Context context) {
        IType inferred = this.returnType == VoidType.instance() ? this.checkNativeVoid(context) : this.checkNativeType(context);
        return inferred.anyfy();
    }

    private IType checkNativeType(Context context) {
        IType type;
        TypeMap types = new TypeMap();
        if (this.returnType != null) {
            types.put(this.returnType.getTypeNameId(), this.returnType);
        }
        if ((type = this.statement.checkNative(context, this.returnType)) == null) {
            type = this.returnType;
        }
        if (type != VoidType.instance()) {
            types.put(type.getTypeNameId(), type);
        }
        type = types.inferType(context);
        if (this.returnType != null) {
            return this.returnType;
        }
        return type;
    }

    private IType checkNativeVoid(Context context) {
        IType type = this.statement.checkNative(context, this.returnType);
        if (type == null) {
            type = this.returnType;
        }
        if (type != VoidType.instance()) {
            context.getProblemListener().reportIllegalReturn(this.statement);
        }
        return this.returnType;
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        try {
            return this.doInterpretNative(context);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw new NullReferenceError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IValue doInterpretNative(Context context) throws PromptoError {
        context.enterStatement(this.statement);
        try {
            IValue result = this.statement.interpretNative(context, this.returnType);
            if (result != null) {
                IValue iValue = result;
                return iValue;
            }
        }
        finally {
            context.leaveStatement(this.statement);
        }
        return null;
    }

    @Override
    public void compile(Context context, boolean isStart, ClassFile classFile) {
        this.compileGlobal(context, classFile);
    }

    public void compileGlobal(Context context, ClassFile classFile) {
        try {
            context = context.newLocalContext();
            this.registerParameters(context);
            IType returnType = this.checkNative(context);
            MethodInfo method = this.createMethodInfo(context, classFile, returnType, this.getName());
            this.registerLocals(context, classFile, method);
            if (this.statement != null) {
                this.statement.compile(context, method, new Flags());
            }
            if (returnType == VoidType.instance()) {
                method.addInstruction(Opcode.RETURN, new IOperand[0]);
            }
        }
        catch (PromptoError e) {
            throw new CompilerException(e);
        }
    }

    public ResultInfo compileMember(Context context, MethodInfo method, Flags flags, ArgumentList assignments) {
        try {
            this.compileParameters(context, method, flags, assignments);
            return this.statement.compile(context, method, new Flags().withMember(true).withInline(true));
        }
        catch (PromptoError e) {
            throw new CompilerException(e);
        }
    }

    @Override
    protected void toMDialect(CodeWriter writer) {
        writer.append("def ");
        if (this.memberOf == null) {
            writer.append("native ");
        }
        writer.append(this.getName());
        writer.append(" (");
        this.parameters.toDialect(writer);
        writer.append(")");
        if (this.returnType != null && this.returnType != VoidType.instance()) {
            writer.append("->");
            this.returnType.toDialect(writer);
        }
        writer.append(":\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    @Override
    protected void toODialect(CodeWriter writer) {
        if (this.returnType != null && this.returnType != VoidType.instance()) {
            this.returnType.toDialect(writer);
            writer.append(" ");
        }
        if (this.memberOf == null) {
            writer.append("native ");
        }
        writer.append("method ");
        writer.append(this.getName());
        writer.append(" (");
        this.parameters.toDialect(writer);
        writer.append(") {\n");
        writer.indent();
        for (IStatement statement : this.statements) {
            statement.toDialect(writer);
            writer.newLine();
        }
        writer.dedent();
        writer.append("}\n");
    }

    @Override
    protected void toEDialect(CodeWriter writer) {
        writer.append("define ");
        writer.append(this.getName());
        writer.append(" as ");
        if (this.memberOf == null) {
            writer.append("native ");
        }
        writer.append("method ");
        this.parameters.toDialect(writer);
        if (this.returnType != null && this.returnType != VoidType.instance()) {
            writer.append("returning ");
            this.returnType.toDialect(writer);
            writer.append(" ");
        }
        writer.append("doing:\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
        writer.append("\n");
    }
}

