/*
 * Decompiled with CFR 0.152.
 */
package prompto.declaration;

import prompto.declaration.ConcreteMethodDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.grammar.Operator;
import prompto.grammar.ParameterList;
import prompto.param.IParameter;
import prompto.runtime.Context;
import prompto.statement.StatementList;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;

public class OperatorMethodDeclaration
extends ConcreteMethodDeclaration
implements IExpression,
IMethodDeclaration {
    Operator operator;

    public OperatorMethodDeclaration(Operator op, IParameter arg, IType returnType, StatementList stmts) {
        super(new Identifier(OperatorMethodDeclaration.getNameAsKey(op)), new ParameterList(arg), returnType, stmts);
        this.operator = op;
    }

    @Override
    public IType check(Context context) {
        return this.check(context);
    }

    public static String getNameAsKey(Operator operator) {
        return "operator_" + operator.name();
    }

    @Override
    public String getNameAsKey() {
        return OperatorMethodDeclaration.getNameAsKey(this.operator);
    }

    @Override
    protected void toMDialect(CodeWriter writer) {
        writer.append("def operator ");
        writer.append(this.operator.getToken());
        writer.append(" (");
        this.parameters.toDialect(writer);
        writer.append(")");
        if (this.returnType != null && this.returnType != VoidType.instance()) {
            writer.append("->");
            this.returnType.toDialect(writer);
        }
        writer.append(":\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    @Override
    protected void toEDialect(CodeWriter writer) {
        writer.append("define ");
        writer.append(this.operator.getToken());
        writer.append(" as operator ");
        this.parameters.toDialect(writer);
        if (this.returnType != null && this.returnType != VoidType.instance()) {
            writer.append("returning ");
            this.returnType.toDialect(writer);
            writer.append(" ");
        }
        writer.append("doing:\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
    }

    @Override
    protected void toODialect(CodeWriter writer) {
        if (this.returnType != null && this.returnType != VoidType.instance()) {
            this.returnType.toDialect(writer);
            writer.append(" ");
        }
        writer.append("operator ");
        writer.append(this.operator.getToken());
        writer.append(" (");
        this.parameters.toDialect(writer);
        writer.append(") {\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
        writer.append("}\n");
    }

    @Override
    public void declare(Transpiler transpiler) {
        super.declare(transpiler);
    }
}

