/*
 * Decompiled with CFR 0.152.
 */
package prompto.declaration;

import java.lang.reflect.Type;
import prompto.compiler.ClassConstant;
import prompto.compiler.ClassFile;
import prompto.compiler.CompilerException;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Descriptor;
import prompto.compiler.FieldConstant;
import prompto.compiler.FieldInfo;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.ConcreteCategoryDeclaration;
import prompto.declaration.GetterMethodDeclaration;
import prompto.declaration.SetterMethodDeclaration;
import prompto.error.SyntaxError;
import prompto.grammar.Identifier;
import prompto.grammar.MethodDeclarationList;
import prompto.intrinsic.PromptoRoot;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.CategoryType;
import prompto.utils.CodeWriter;
import prompto.utils.IdentifierList;

public class SingletonCategoryDeclaration
extends ConcreteCategoryDeclaration {
    public SingletonCategoryDeclaration(Identifier name, IdentifierList attributes, MethodDeclarationList methods) {
        super(name, attributes, null, methods);
    }

    @Override
    protected void categoryTypeToEDialect(CodeWriter writer) {
        writer.append("singleton");
    }

    @Override
    protected void categoryTypeToODialect(CodeWriter writer) {
        writer.append("singleton");
    }

    @Override
    protected void categoryTypeToMDialect(CodeWriter writer) {
        writer.append("singleton");
    }

    @Override
    public ClassFile compile(Context context, String fullName) {
        try {
            Type concreteType = CompilerUtils.singletonTypeFrom(fullName);
            ClassFile classFile = new ClassFile(concreteType);
            classFile.addModifier(1024);
            classFile.setSuperClass(new ClassConstant((Type)((Object)PromptoRoot.class)));
            this.compileFields(context, classFile, new Flags());
            this.compileEmptyConstructor(context, classFile, new Flags());
            this.compileMethods(context, classFile, new Flags());
            return classFile;
        }
        catch (SyntaxError e) {
            throw new CompilerException(e);
        }
    }

    @Override
    protected void compileField(Context context, ClassFile classFile, Flags flags, Identifier id) {
        AttributeDeclaration decl = context.getRegisteredDeclaration(AttributeDeclaration.class, id);
        FieldInfo field = decl.toFieldInfo(context);
        field.addModifier(8);
        classFile.addField(field);
        this.compileStaticSetterMethod(context, classFile, flags, id, field);
        this.compileStaticGetterMethod(context, classFile, flags, id, field);
    }

    private void compileStaticGetterMethod(Context context, ClassFile classFile, Flags flags, Identifier id, FieldInfo field) {
        GetterMethodDeclaration getter = this.findGetter(context, id);
        if (getter != null) {
            getter.compile(context, classFile, flags, this.getType(context), field);
        } else {
            this.compileStaticFieldGetter(context, classFile, flags, id, field);
        }
    }

    private void compileStaticFieldGetter(Context context, ClassFile classFile, Flags flags, Identifier id, FieldInfo field) {
        String name = CompilerUtils.getterName(id.toString());
        Descriptor.Method proto = new Descriptor.Method(field.getType());
        MethodInfo method = classFile.newMethod(name, proto);
        method.addModifier(8);
        FieldConstant f = new FieldConstant(classFile.getThisClass(), id.toString(), field.getType());
        method.addInstruction(Opcode.GETSTATIC, f);
        method.addInstruction(Opcode.ARETURN, new ClassConstant(field.getType()));
    }

    private void compileStaticSetterMethod(Context context, ClassFile classFile, Flags flags, Identifier id, FieldInfo field) {
        SetterMethodDeclaration setter = this.findSetter(context, id);
        if (setter != null) {
            setter.compile(context, classFile, flags, this.getType(context), field);
        } else {
            this.compileStaticFieldSetter(context, classFile, flags, id, field);
        }
    }

    private void compileStaticFieldSetter(Context context, ClassFile classFile, Flags flags, Identifier id, FieldInfo field) {
        String name = CompilerUtils.setterName(field.getName().getValue());
        Descriptor.Method proto = new Descriptor.Method(field.getType(), Void.TYPE);
        MethodInfo method = classFile.newMethod(name, proto);
        method.addModifier(8);
        ClassConstant fc = new ClassConstant(field.getType());
        method.registerLocal("%value%", IVerifierEntry.VerifierType.ITEM_Object, fc);
        method.addInstruction(Opcode.ALOAD_0, fc);
        FieldConstant f = new FieldConstant(classFile.getThisClass(), field.getName().getValue(), field.getType());
        method.addInstruction(Opcode.PUTSTATIC, f);
        method.addInstruction(Opcode.RETURN, new IOperand[0]);
    }

    public ResultInfo compileGetStaticMember(Context context, MethodInfo method, Flags flags, Identifier id) {
        Type concreteType = CompilerUtils.getCategorySingletonType(this.getId());
        String getterName = CompilerUtils.getterName(id.toString());
        AttributeDeclaration decl = context.getRegisteredDeclaration(AttributeDeclaration.class, id);
        FieldInfo field = decl.toFieldInfo(context);
        MethodConstant m = new MethodConstant(concreteType, getterName, field.getType());
        method.addInstruction(Opcode.INVOKESTATIC, m);
        return new ResultInfo(field.getType(), new ResultInfo.Flag[0]);
    }

    public ResultInfo compileSetStaticMember(Context context, MethodInfo method, Flags flags, Identifier id) {
        Type concreteType = CompilerUtils.getCategorySingletonType(this.getId());
        String setterName = CompilerUtils.setterName(id.toString());
        AttributeDeclaration decl = context.getRegisteredDeclaration(AttributeDeclaration.class, id);
        FieldInfo field = decl.toFieldInfo(context);
        MethodConstant m = new MethodConstant(concreteType, setterName, field.getType(), Void.TYPE);
        method.addInstruction(Opcode.INVOKESTATIC, m);
        return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        CategoryType type = new CategoryType(this.getId());
        transpiler = transpiler.newInstanceTranspiler(type);
        this.doTranspile(transpiler);
        transpiler.flush();
        return true;
    }

    private void doTranspile(Transpiler transpiler) {
        transpiler.append("function ").append(this.getName()).append("() {").indent();
        transpiler.append("$Root.call(this);").newLine();
        transpiler.append("this.$mutable = true;").newLine();
        transpiler.append("return this;").dedent();
        transpiler.append("};").newLine();
        transpiler.append(this.getName()).append(".prototype = Object.create($Root.prototype);").newLine();
        transpiler.append(this.getName()).append(".prototype.constructor = ").append(this.getName()).append(";").newLine();
        transpiler.append(this.getName()).append(".instance = new ").append(this.getName()).append("();").newLine();
        if (this.attributes != null) {
            this.attributes.forEach(attr -> transpiler.append(this.getName()).append(".instance.").append(attr.toString()).append(" = null;").newLine());
        }
        this.methods.forEach(method -> {
            Transpiler m = transpiler.newChildTranspiler(null);
            method.transpile(m);
            m.flush();
        });
    }
}

