/*
 * Decompiled with CFR 0.152.
 */
package prompto.declaration;

import java.io.PrintStream;
import java.lang.reflect.Type;
import prompto.compiler.ClassFile;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Descriptor;
import prompto.compiler.ExceptionHandler;
import prompto.compiler.FieldConstant;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.OffsetListenerConstant;
import prompto.compiler.Opcode;
import prompto.compiler.StackState;
import prompto.compiler.StringConstant;
import prompto.declaration.BaseDeclaration;
import prompto.declaration.IDeclaration;
import prompto.error.ExecutionError;
import prompto.error.PromptoError;
import prompto.expression.SymbolExpression;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoException;
import prompto.parser.Assertion;
import prompto.runtime.Context;
import prompto.statement.IStatement;
import prompto.statement.StatementList;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.VoidType;
import prompto.utils.AssertionList;
import prompto.utils.CodeWriter;
import prompto.value.IInstance;
import prompto.value.IValue;

public class TestMethodDeclaration
extends BaseDeclaration {
    StatementList statements;
    AssertionList assertions;
    SymbolExpression error;

    public TestMethodDeclaration(Identifier name, StatementList stmts, AssertionList exps, SymbolExpression error) {
        super(name);
        this.statements = stmts;
        this.assertions = exps;
        this.error = error;
    }

    @Override
    public IDeclaration.DeclarationType getDeclarationType() {
        return IDeclaration.DeclarationType.TEST;
    }

    public StatementList getStatements() {
        return this.statements;
    }

    public AssertionList getAssertions() {
        return this.assertions;
    }

    @Override
    public IType check(Context context) {
        context = context.newLocalContext();
        for (IStatement statement : this.statements) {
            this.checkStatement(context, statement);
        }
        if (this.assertions != null) {
            for (Assertion assertion : this.assertions) {
                context = assertion.check(context);
            }
        }
        return VoidType.instance();
    }

    private void checkStatement(Context context, IStatement statement) {
        IType type = statement.check(context);
        if (type != null && type != VoidType.instance()) {
            context.getProblemListener().reportIllegalReturn(statement);
        }
    }

    @Override
    public void register(Context context) {
        context.registerDeclaration(this);
    }

    @Override
    public IType getType(Context context) {
        return VoidType.instance();
    }

    public void interpret(Context context) throws PromptoError {
        if (this.interpretBody(context)) {
            this.interpretError(context);
            this.interpretAsserts(context);
        }
    }

    private void interpretError(Context context) {
        if (this.error != null) {
            this.printFailedAssertion(context, this.error.getName().toString(), "no error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interpretAsserts(Context context) throws PromptoError {
        if (this.assertions == null) {
            return;
        }
        context.enterTest(this);
        try {
            boolean success = true;
            for (Assertion assertion : this.assertions) {
                success &= assertion.interpret(context, this);
            }
            if (success) {
                this.printSuccess(context);
            }
        }
        finally {
            context.leaveSection(this);
        }
    }

    public void printFailedAssertion(Context context, String expected, String actual) {
        String message = this.buildFailedAssertionMessagePrefix(expected);
        System.out.println(message + actual);
    }

    public String buildFailedAssertionMessagePrefix(String expected) {
        return this.getName() + " test failed while verifying: " + expected + ", found: ";
    }

    public void printMissingError(Context context, String expected, String actual) {
        String message = this.buildMissingErrorMessagePrefix(expected);
        System.out.println(message + actual);
    }

    public String buildMissingErrorMessagePrefix(String expected) {
        return this.getName() + " test failed while expecting: " + expected + ", found: ";
    }

    private void printSuccess(Context context) {
        System.out.println(this.buildSuccessMessage());
    }

    public String buildSuccessMessage() {
        return this.getName() + " test successful";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean interpretBody(Context context) throws PromptoError {
        context.enterTest(this);
        try {
            this.statements.interpret(context);
            boolean bl = true;
            return bl;
        }
        catch (ExecutionError e) {
            this.interpretError(context, e);
            boolean bl = false;
            return bl;
        }
        finally {
            context.leaveSection(this);
        }
    }

    private void interpretError(Context context, ExecutionError e) throws PromptoError {
        IValue expectedError;
        IValue actual = e.interpret(context, new Identifier("__test_error__"));
        IValue iValue = expectedError = this.error == null ? null : this.error.interpret(context);
        if (expectedError != null && expectedError.equals(actual)) {
            this.printSuccess(context);
        } else {
            String actualName = ((IInstance)actual).getMember(context, new Identifier("name"), false).toString();
            String expectedName = this.error == null ? "SUCCESS" : this.error.getName().toString();
            this.printMissingError(context, expectedName, actualName);
        }
    }

    @Override
    public void declarationToDialect(CodeWriter writer) {
        if (writer.isGlobalContext()) {
            writer = writer.newLocalWriter();
        }
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
    }

    protected void toMDialect(CodeWriter writer) {
        writer.append("def test ");
        writer.append(this.getName());
        writer.append(" ():\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
        writer.append("verifying:");
        if (this.error != null) {
            writer.append(" ");
            this.error.toDialect(writer);
            writer.append("\n");
        } else {
            writer.append("\n");
            writer.indent();
            this.assertions.toDialect(writer);
            writer.dedent();
        }
    }

    protected void toEDialect(CodeWriter writer) {
        writer.append("define ");
        writer.append(this.getName());
        writer.append(" as test method doing:\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
        writer.append("and verifying");
        if (this.error != null) {
            writer.append(" ");
            this.error.toDialect(writer);
            writer.append("\n");
        } else {
            writer.append(":\n");
            writer.indent();
            this.assertions.toDialect(writer);
            writer.dedent();
        }
    }

    protected void toODialect(CodeWriter writer) {
        writer.append("test method ");
        writer.append(this.getName());
        writer.append(" () {\n");
        writer.indent();
        this.statements.toDialect(writer);
        writer.dedent();
        writer.append("} verifying ");
        if (this.error != null) {
            this.error.toDialect(writer);
            writer.append(";\n");
        } else {
            writer.append("{\n");
            writer.indent();
            this.assertions.toDialect(writer);
            writer.dedent();
            writer.append("}\n");
        }
    }

    public ClassFile compile(Context context, String fullName) {
        context = context.newLocalContext();
        Type type = CompilerUtils.abstractTypeFrom(fullName);
        ClassFile classFile = new ClassFile(type);
        classFile.addModifier(1024);
        Descriptor.Method proto = new Descriptor.Method(Void.TYPE);
        MethodInfo method = classFile.newMethod("run", proto);
        method.addModifier(8);
        if (this.error != null) {
            this.compileTestWithError(context, method, new Flags());
        } else {
            this.compileTestWithAsserts(context, method, new Flags());
        }
        return classFile;
    }

    private void compileTestWithAsserts(Context context, MethodInfo method, Flags flags) {
        this.statements.forEach(s -> s.compile(context, method, flags));
        method.addInstruction(Opcode.ICONST_0, new IOperand[0]);
        this.assertions.forEach(a -> a.compile(context, method, flags, this));
        this.compileCheckSuccess(context, method, flags);
        method.addInstruction(Opcode.RETURN, new IOperand[0]);
    }

    private void compileCheckSuccess(Context context, MethodInfo method, Flags flags) {
        OffsetListenerConstant finalListener = method.addOffsetListener(new OffsetListenerConstant());
        method.activateOffsetListener(finalListener);
        method.addInstruction(Opcode.IFNE, finalListener);
        StackState finalState = method.captureStackState();
        this.compileSuccess(context, method, flags);
        method.restoreFullStackState(finalState);
        method.placeLabel(finalState);
        method.inhibitOffsetListener(finalListener);
    }

    public void compileSuccess(Context context, MethodInfo method, Flags flags) {
        String message = this.buildSuccessMessage();
        method.addInstruction(Opcode.LDC, new StringConstant(message));
        this.compilePrintResult(context, method, flags);
    }

    public void compileFailure(Context context, MethodInfo method, Flags flags) {
        this.compilePrintResult(context, method, flags);
    }

    public void compilePrintResult(Context context, MethodInfo method, Flags flags) {
        FieldConstant fc = new FieldConstant((Type)((Object)System.class), "out", (Type)((Object)PrintStream.class));
        method.addInstruction(Opcode.GETSTATIC, fc);
        method.addInstruction(Opcode.SWAP, new IOperand[0]);
        MethodConstant mc = new MethodConstant((Type)((Object)PrintStream.class), "println", new Type[]{String.class, Void.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, mc);
    }

    private void compileTestWithError(Context context, MethodInfo method, Flags flags) {
        ExceptionHandler expected = this.installExpectedExceptionHandler(context, method, flags);
        ExceptionHandler unexpected = this.installUnexpectedExceptionHandler(context, method, flags);
        this.statements.compile(context, method, flags);
        this.compileMissingExceptionHandler(context, method, flags);
        method.addInstruction(Opcode.RETURN, new IOperand[0]);
        this.compileExpectedExceptionHandler(context, method, flags, expected);
        method.addInstruction(Opcode.RETURN, new IOperand[0]);
        this.compileUnexpectedExceptionHandler(context, method, flags, unexpected);
        method.addInstruction(Opcode.RETURN, new IOperand[0]);
    }

    private void compileUnexpectedExceptionHandler(Context context, MethodInfo method, Flags flags, ExceptionHandler handler) {
        method.placeExceptionHandler(handler);
        MethodConstant mc = new MethodConstant((Type)((Object)PromptoException.class), "getExceptionTypeName", new Type[]{Object.class, String.class});
        method.addInstruction(Opcode.INVOKESTATIC, mc);
        String message = this.buildMissingErrorMessagePrefix(this.error.getName().toString());
        method.addInstruction(Opcode.LDC, new StringConstant(message));
        method.addInstruction(Opcode.SWAP, new IOperand[0]);
        mc = new MethodConstant((Type)((Object)String.class), "concat", new Type[]{String.class, String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, mc);
        this.compilePrintResult(context, method, flags);
    }

    private void compileExpectedExceptionHandler(Context context, MethodInfo method, Flags flags, ExceptionHandler handler) {
        method.placeExceptionHandler(handler);
        method.addInstruction(Opcode.POP, new IOperand[0]);
        this.compileSuccess(context, method, flags);
    }

    private void compileMissingExceptionHandler(Context context, MethodInfo method, Flags flags) {
        String message = this.buildMissingErrorMessagePrefix(this.error.getName().toString()) + "no error";
        method.addInstruction(Opcode.LDC, new StringConstant(message));
        this.compilePrintResult(context, method, flags);
    }

    private ExceptionHandler installUnexpectedExceptionHandler(Context context, MethodInfo method, Flags flags) {
        ExceptionHandler handler = method.registerExceptionHandler((Type)((Object)Throwable.class));
        method.activateOffsetListener(handler);
        return handler;
    }

    private ExceptionHandler installExpectedExceptionHandler(Context context, MethodInfo method, Flags flags) {
        Object type = null;
        switch (this.error.getName()) {
            case "DIVIDE_BY_ZERO": {
                type = ArithmeticException.class;
                break;
            }
            case "INDEX_OUT_OF_RANGE": {
                type = IndexOutOfBoundsException.class;
                break;
            }
            case "NULL_REFERENCE": {
                type = NullPointerException.class;
                break;
            }
            default: {
                type = this.error.getJavaType(context);
            }
        }
        ExceptionHandler handler = method.registerExceptionHandler((Type)type);
        method.activateOffsetListener(handler);
        return handler;
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("NativeError");
        transpiler.declare(this);
        transpiler = transpiler.newLocalTranspiler();
        this.statements.declare(transpiler);
        if (this.assertions != null) {
            this.assertions.declare(transpiler);
        }
        if (this.error != null) {
            this.error.declare(transpiler);
        }
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler = transpiler.newLocalTranspiler();
        if (this.error != null) {
            this.transpileExpectedError(transpiler);
        } else {
            this.transpileAssertions(transpiler);
        }
        transpiler.flush();
        return true;
    }

    private void transpileAssertions(Transpiler transpiler) {
        transpiler.append("function ").append(this.getTranspiledName()).append("() {");
        transpiler.indent();
        transpiler.append("try {");
        transpiler.indent();
        this.statements.transpile(transpiler);
        transpiler.append("var success = true;").newLine();
        this.assertions.forEach(assertion -> {
            transpiler.append("if(");
            assertion.transpile(transpiler);
            transpiler.append(")").indent();
            transpiler.append("success &= true;").dedent();
            transpiler.append("else {").indent();
            transpiler.append("success = false;").newLine();
            transpiler.printTestName(this.getName()).append("failed while verifying: ");
            transpiler.escape();
            transpiler.append(assertion.getExpected(transpiler.getContext(), this.getDialect(), transpiler.getEscapeMode()));
            transpiler.unescape();
            transpiler.append(", found: ' + ");
            transpiler.escape();
            assertion.transpileFound(transpiler, this.getDialect());
            transpiler.unescape();
            transpiler.append(");");
            transpiler.dedent();
            transpiler.append("}").newLine();
        });
        transpiler.append("if (success)").indent().printTestName(this.getName()).append("successful');").dedent();
        transpiler.dedent();
        transpiler.append("} catch (e) {");
        transpiler.indent();
        transpiler.printTestName(this.getName()).append("failed with error: ' + e.name);");
        transpiler.dedent();
        transpiler.append("}");
        transpiler.dedent();
        transpiler.append("}");
        transpiler.newLine();
        transpiler.flush();
    }

    public String getTranspiledName() {
        String name = this.getName();
        return name.substring(1, name.length() - 1).replaceAll("\\W", "_");
    }

    private void transpileExpectedError(Transpiler transpiler) {
        transpiler.append("function ").append(this.getTranspiledName()).append("() {");
        transpiler.indent();
        transpiler.append("try {");
        transpiler.indent();
        this.statements.transpile(transpiler);
        transpiler.printTestName(this.getName()).append("failed while expecting: ").append(this.error.getName()).append(", found: no error');");
        transpiler.dedent();
        transpiler.append("} catch (e) {");
        transpiler.indent();
        transpiler.append("if(e instanceof NativeErrors.").append(this.error.getName()).append(") {").indent();
        transpiler.printTestName(this.getName()).append("successful');").dedent();
        transpiler.append("} else {").indent();
        transpiler.printTestName(this.getName()).append("failed while expecting: ").append(this.error.getName()).append(", found: ' + translateError(e));").dedent();
        transpiler.append("}");
        transpiler.dedent();
        transpiler.append("}");
        transpiler.dedent();
        transpiler.append("}");
        transpiler.newLine();
        transpiler.flush();
    }
}

