/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.lang.reflect.Type;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.OffsetListenerConstant;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.ShortOperand;
import prompto.compiler.StackLocal;
import prompto.compiler.StackState;
import prompto.compiler.StringConstant;
import prompto.declaration.TestMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IAssertion;
import prompto.expression.IExpression;
import prompto.expression.IPredicateExpression;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.store.IQueryBuilder;
import prompto.store.IStore;
import prompto.transpiler.Transpiler;
import prompto.type.BooleanType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.BooleanValue;
import prompto.value.IValue;

public class AndExpression
implements IPredicateExpression,
IAssertion {
    IExpression left;
    IExpression right;

    public AndExpression(IExpression left, IExpression right) {
        this.left = left;
        this.right = right;
    }

    public IExpression getLeft() {
        return this.left;
    }

    public IExpression getRight() {
        return this.right;
    }

    public String toString() {
        return this.left.toString() + " and " + this.right.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        this.left.toDialect(writer);
        writer.append(this.operatorToDialect(writer.getDialect()));
        this.right.toDialect(writer);
    }

    private String operatorToDialect(Dialect dialect) {
        switch (dialect) {
            case E: 
            case M: {
                return " and ";
            }
            case O: {
                return " && ";
            }
        }
        throw new RuntimeException("Unsupported: " + dialect.name());
    }

    @Override
    public IType check(Context context) {
        IType lt = this.left.check(context);
        IType rt = this.right.check(context);
        if (!(lt instanceof BooleanType) || !(rt instanceof BooleanType)) {
            throw new SyntaxError("Cannot combine " + lt.getTypeName() + " and " + rt.getTypeName());
        }
        return BooleanType.instance();
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IValue lval = this.left.interpret(context);
        if (!(lval instanceof BooleanValue)) {
            throw new SyntaxError("Illegal: " + lval.getClass().getSimpleName() + " and ..., expected a Boolean");
        }
        if (!((BooleanValue)lval).getValue()) {
            return lval;
        }
        IValue rval = this.right.interpret(context);
        if (!(rval instanceof BooleanValue)) {
            throw new SyntaxError("Illegal: Boolean and " + rval.getClass().getSimpleName());
        }
        return rval;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ResultInfo li = this.left.compile(context, method, flags.withPrimitive(true));
        if (BooleanValue.class == li.getType()) {
            CompilerUtils.BooleanToboolean(method);
        }
        OffsetListenerConstant finalOffset = method.addOffsetListener(new OffsetListenerConstant());
        method.activateOffsetListener(finalOffset);
        method.addInstruction(Opcode.IFEQ, finalOffset);
        ResultInfo ri = this.right.compile(context, method, flags.withPrimitive(true));
        if (BooleanValue.class == ri.getType()) {
            CompilerUtils.BooleanToboolean(method);
        }
        method.addInstruction(Opcode.IFEQ, new ShortOperand(7));
        StackState branchState = method.captureStackState();
        method.addInstruction(Opcode.ICONST_1, new IOperand[0]);
        method.addInstruction(Opcode.GOTO, new ShortOperand(4));
        method.restoreFullStackState(branchState);
        method.placeLabel(branchState);
        method.inhibitOffsetListener(finalOffset);
        method.addInstruction(Opcode.ICONST_0, new IOperand[0]);
        StackState lastState = method.captureStackState();
        method.placeLabel(lastState);
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }

    @Override
    public void compileQuery(Context context, MethodInfo method, Flags flags) {
        ((IPredicateExpression)this.left).compileQuery(context, method, flags);
        ((IPredicateExpression)this.right).compileQuery(context, method, flags);
        InterfaceConstant m = new InterfaceConstant((Type)((Object)IQueryBuilder.class), "and", new Type[]{IQueryBuilder.class});
        method.addInstruction(Opcode.INVOKEINTERFACE, m);
    }

    @Override
    public boolean interpretAssert(Context context, TestMethodDeclaration test) throws PromptoError {
        IValue lval = this.left.interpret(context);
        if (!(lval instanceof BooleanValue)) {
            throw new SyntaxError("Illegal: " + lval.getClass().getSimpleName() + " and ..., expected a Boolean");
        }
        IValue rval = BooleanValue.FALSE;
        if (((BooleanValue)lval).getValue()) {
            rval = this.right.interpret(context);
            if (!(rval instanceof BooleanValue)) {
                throw new SyntaxError("Illegal: Boolean and " + rval.getClass().getSimpleName());
            }
            if (rval == BooleanValue.TRUE) {
                return true;
            }
        }
        String expected = this.buildExpectedMessage(context, test);
        String actual = lval.toString() + this.operatorToDialect(test.getDialect()) + rval.toString();
        test.printFailedAssertion(context, expected, actual);
        return false;
    }

    @Override
    public void interpretQuery(Context context, IQueryBuilder query, IStore store) throws PromptoError {
        if (!(this.left instanceof IPredicateExpression)) {
            throw new SyntaxError("Not a predicate: " + this.left.toString());
        }
        ((IPredicateExpression)this.left).interpretQuery(context, query, store);
        if (!(this.right instanceof IPredicateExpression)) {
            throw new SyntaxError("Not a predicate: " + this.left.toString());
        }
        ((IPredicateExpression)this.right).interpretQuery(context, query, store);
        query.and();
    }

    private String buildExpectedMessage(Context context, TestMethodDeclaration test) {
        CodeWriter writer = new CodeWriter(test.getDialect(), context);
        this.toDialect(writer);
        return writer.toString();
    }

    @Override
    public void compileAssert(Context context, MethodInfo method, Flags flags, TestMethodDeclaration test) {
        context = context.newChildContext();
        StackState finalState = method.captureStackState();
        ResultInfo info = this.left.compile(context, method, flags.withPrimitive(true));
        if (BooleanValue.class == info.getType()) {
            CompilerUtils.BooleanToboolean(method);
        }
        String leftName = method.nextTransientName("left");
        StackLocal left = method.registerLocal(leftName, IVerifierEntry.VerifierType.ITEM_Integer, new ClassConstant(Boolean.TYPE));
        CompilerUtils.compileISTORE(method, left);
        info = this.right.compile(context, method, flags.withPrimitive(true));
        if (BooleanValue.class == info.getType()) {
            CompilerUtils.BooleanToboolean(method);
        }
        String rightName = method.nextTransientName("right");
        StackLocal right = method.registerLocal(rightName, IVerifierEntry.VerifierType.ITEM_Integer, new ClassConstant(Boolean.TYPE));
        CompilerUtils.compileISTORE(method, right);
        CompilerUtils.compileILOAD(method, left);
        CompilerUtils.compileILOAD(method, right);
        method.addInstruction(Opcode.IADD, new IOperand[0]);
        method.addInstruction(Opcode.ICONST_2, new IOperand[0]);
        method.addInstruction(Opcode.ISUB, new IOperand[0]);
        OffsetListenerConstant finalListener = method.addOffsetListener(new OffsetListenerConstant());
        method.activateOffsetListener(finalListener);
        method.addInstruction(Opcode.IFEQ, finalListener);
        method.addInstruction(Opcode.ICONST_1, new IOperand[0]);
        method.addInstruction(Opcode.IADD, new IOperand[0]);
        String message = this.buildExpectedMessage(context, test);
        message = test.buildFailedAssertionMessagePrefix(message);
        method.addInstruction(Opcode.LDC, new StringConstant(message));
        CompilerUtils.compileILOAD(method, left);
        MethodConstant valueOf = new MethodConstant((Type)((Object)String.class), "valueOf", new Type[]{Boolean.TYPE, String.class});
        method.addInstruction(Opcode.INVOKESTATIC, valueOf);
        MethodConstant concat = new MethodConstant((Type)((Object)String.class), "concat", new Type[]{String.class, String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, concat);
        method.addInstruction(Opcode.LDC, new StringConstant(this.operatorToDialect(test.getDialect())));
        method.addInstruction(Opcode.INVOKEVIRTUAL, concat);
        CompilerUtils.compileILOAD(method, right);
        method.addInstruction(Opcode.INVOKESTATIC, valueOf);
        method.addInstruction(Opcode.INVOKEVIRTUAL, concat);
        test.compileFailure(context, method, flags);
        method.unregisterLocal(right);
        method.unregisterLocal(left);
        method.restoreFullStackState(finalState);
        method.placeLabel(finalState);
        method.inhibitOffsetListener(finalListener);
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.left.declare(transpiler);
        this.right.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        this.left.transpile(transpiler);
        transpiler.append(" && ");
        this.right.transpile(transpiler);
        return false;
    }

    @Override
    public void transpileFound(Transpiler transpiler, Dialect dialect) {
        transpiler.append("(");
        this.left.transpile(transpiler);
        transpiler.append(") + '").append(this.operatorToDialect(dialect)).append("' + (");
        this.right.transpile(transpiler);
        transpiler.append(")");
    }

    @Override
    public void declareQuery(Transpiler transpiler) {
        this.left.declare(transpiler);
        this.right.declare(transpiler);
    }

    @Override
    public void transpileQuery(Transpiler transpiler, String builderName) {
        this.left.transpileQuery(transpiler, builderName);
        this.right.transpileQuery(transpiler, builderName);
        transpiler.append(builderName).append(".and();").newLine();
    }
}

