/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.function.Predicate;
import prompto.compiler.ClassConstant;
import prompto.compiler.ClassFile;
import prompto.compiler.Descriptor;
import prompto.compiler.Flags;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.MethodInfo;
import prompto.compiler.ResultInfo;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.parser.Dialect;
import prompto.parser.Section;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.statement.ReturnStatement;
import prompto.statement.StatementList;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.IterableType;
import prompto.utils.CodeWriter;
import prompto.utils.IdentifierList;
import prompto.value.BooleanValue;
import prompto.value.IValue;
import prompto.value.IntegerValue;

public class ArrowExpression
extends Section
implements IExpression {
    IdentifierList args;
    String argsSuite;
    String arrowSuite;
    StatementList statements;

    public ArrowExpression(IdentifierList args, String argsSuite, String arrowSuite) {
        this.args = args;
        this.argsSuite = argsSuite;
        this.arrowSuite = arrowSuite;
    }

    public IdentifierList getArgs() {
        return this.args;
    }

    @Override
    public IType check(Context context) {
        return this.check(context, null);
    }

    public IType check(Context context, IType returnType) {
        return this.statements.check(context, returnType);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        return this.statements.interpret(context);
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.statements.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        this.statements.transpile(transpiler);
        return false;
    }

    public void transpileArguments(Transpiler transpiler) {
        if (this.args != null && this.args.size() > 0) {
            this.args.forEach(arg -> {
                transpiler.append((Identifier)arg);
                transpiler.append(", ");
            });
            transpiler.trimLast(", ".length());
        }
    }

    @Override
    public void toDialect(CodeWriter writer) {
        this.argsToDialect(writer);
        if (this.argsSuite != null) {
            writer.append(this.argsSuite);
        }
        writer.append("=>");
        if (this.arrowSuite != null) {
            writer.append(this.arrowSuite);
        }
        this.bodyToDialect(writer);
    }

    public String toString() {
        return this.toString(Context.newGlobalsContext());
    }

    public String toString(Context context) {
        try {
            CodeWriter writer = new CodeWriter(Dialect.E, context);
            this.toDialect(writer);
            return writer.toString();
        }
        catch (Throwable t) {
            return "";
        }
    }

    private void bodyToDialect(CodeWriter writer) {
        if (this.statements.size() == 1 && this.statements.getFirst() instanceof ReturnStatement) {
            ((ReturnStatement)this.statements.getFirst()).getExpression().toDialect(writer);
        } else {
            writer.append("{").newLine().indent();
            this.statements.toDialect(writer);
            writer.newLine().dedent().append("}").newLine();
        }
    }

    private void argsToDialect(CodeWriter writer) {
        if (this.args == null || this.args.isEmpty()) {
            writer.append("()");
        } else if (this.args.size() == 1) {
            writer.append(((Identifier)this.args.getFirst()).toString());
        } else {
            writer.append("(");
            this.args.toDialect(writer, false);
            writer.append(")");
        }
    }

    public void setExpression(IExpression expression) {
        ReturnStatement stmt = new ReturnStatement(expression);
        this.statements = new StatementList(stmt);
    }

    public void setStatements(StatementList statements) {
        this.statements = statements;
    }

    public StatementList getStatements() {
        return this.statements;
    }

    public Predicate<IValue> getFilter(Context context, IType itemType) {
        if (this.args == null || this.args.size() != 1) {
            throw new SyntaxError("Expecting 1 parameter only!");
        }
        Context local = this.registerArrowArgs(context.newChildContext(), itemType);
        return o -> {
            local.setValue((Identifier)this.args.get(0), (IValue)o);
            IValue result = this.statements.interpret(local);
            if (result instanceof BooleanValue) {
                return ((BooleanValue)result).getValue();
            }
            throw new SyntaxError("Expecting a Boolean result!");
        };
    }

    public void declareFilter(Transpiler transpiler, IType itemType) {
        if (this.args == null || this.args.size() != 1) {
            throw new SyntaxError("Expecting 1 parameter only!");
        }
        transpiler = transpiler.newChildTranspiler(null);
        transpiler.getContext().registerValue(new Variable((Identifier)this.args.get(0), itemType));
        this.statements.declare(transpiler);
    }

    public void transpileFilter(Transpiler transpiler, IType itemType) {
        if (this.args == null || this.args.size() != 1) {
            throw new SyntaxError("Expecting 1 parameter only!");
        }
        transpiler = transpiler.newChildTranspiler(null);
        transpiler.getContext().registerValue(new Variable((Identifier)this.args.get(0), itemType));
        transpiler.append("function(").append((Identifier)this.args.get(0)).append(") { ");
        this.statements.transpile(transpiler);
        transpiler.append(" }");
        transpiler.flush();
    }

    public void compileFilter(Context context, ClassFile classFile, IType paramIType, Type paramType) {
        if (this.args == null || this.args.size() != 1) {
            throw new SyntaxError("Expecting 1 parameter only!");
        }
        context = context.newChildContext();
        context.registerValue(new Variable((Identifier)this.args.get(0), paramIType));
        Descriptor.Method proto = new Descriptor.Method(paramType, Boolean.TYPE);
        MethodInfo method = classFile.newMethod("test", proto);
        method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        method.registerLocal(((Identifier)this.args.get(0)).toString(), IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(paramType));
        this.statements.compile(context, method, new Flags().withPrimitive(true));
    }

    public void filterToDialect(CodeWriter writer, IExpression source) {
        if (this.args == null || this.args.size() != 1) {
            throw new SyntaxError("Expecting 1 parameter only!");
        }
        IType sourceType = source.check(writer.getContext());
        IType itemType = ((IterableType)sourceType).getItemType();
        writer = writer.newChildWriter();
        writer.getContext().registerValue(new Variable((Identifier)this.args.get(0), itemType));
        switch (writer.getDialect()) {
            case E: 
            case M: {
                source.toDialect(writer);
                writer.append(" filtered where ");
                this.toDialect(writer);
                break;
            }
            case O: {
                writer.append("filtered (");
                source.toDialect(writer);
                writer.append(") where (");
                this.toDialect(writer);
                writer.append(")");
            }
        }
    }

    public Comparator<? extends IValue> getComparator(Context context, IType itemType, boolean descending) {
        int size = this.args == null ? 0 : this.args.size();
        switch (size) {
            case 1: {
                return this.getComparator1Arg(context, itemType, descending);
            }
            case 2: {
                return this.getComparator2Args(context, itemType, descending);
            }
        }
        throw new SyntaxError("Expecting 1 or 2 parameters only!");
    }

    private Comparator<? extends IValue> getComparator1Arg(Context context, IType itemType, boolean descending) {
        return (o1, o2) -> {
            Context local = this.registerArrowArgs(context.newLocalContext(), itemType);
            local.setValue((Identifier)this.args.get(0), (IValue)o1);
            IValue key1 = this.statements.interpret(local);
            local.setValue((Identifier)this.args.get(0), (IValue)o2);
            IValue key2 = this.statements.interpret(local);
            int result = key1.compareTo(context, key2);
            return descending ? -result : result;
        };
    }

    private Comparator<? extends IValue> getComparator2Args(Context context, IType itemType, boolean descending) {
        return (o1, o2) -> {
            Context local = this.registerArrowArgs(context.newLocalContext(), itemType);
            local.setValue((Identifier)this.args.get(0), (IValue)o1);
            local.setValue((Identifier)this.args.get(1), (IValue)o2);
            IValue value = this.statements.interpret(local);
            if (!(value instanceof IntegerValue)) {
                throw new SyntaxError("Expecting an Integer as result of key body!");
            }
            long result = ((IntegerValue)value).longValue();
            return (int)(descending ? -result : result);
        };
    }

    private Context registerArrowArgs(Context context, IType itemType) {
        if (this.args != null) {
            this.args.forEach(arg -> {
                Variable param = new Variable((Identifier)arg, itemType);
                context.registerValue(param);
            });
        }
        return context;
    }

    public void transpileSortedComparator(Transpiler transpiler, IType itemType, boolean descending) {
        int size = this.args == null ? 0 : this.args.size();
        switch (size) {
            case 1: {
                this.transpileSortedComparator1Arg(transpiler, itemType, descending);
                break;
            }
            case 2: {
                this.transpileSortedComparator2Args(transpiler, itemType, descending);
                break;
            }
            default: {
                throw new SyntaxError("Expecting 1 or 2 parameters only!");
            }
        }
    }

    private void transpileSortedComparator1Arg(Transpiler transpiler, IType itemType, boolean descending) {
        transpiler = transpiler.newLocalTranspiler();
        this.registerArrowArgs(transpiler.getContext(), itemType);
        transpiler.append("function(o1, o2) { ");
        transpiler.append("var $key = function(");
        transpiler.append((Identifier)this.args.getFirst());
        transpiler.append(") { ");
        this.statements.transpile(transpiler);
        transpiler.append(" }; ");
        transpiler.append("o1 = $key(o1); ");
        transpiler.append("o2 = $key(o2); ");
        if (descending) {
            transpiler.append("return o1 === o2 ? 0 : o1 > o2 ? -1 : 1;");
        } else {
            transpiler.append("return o1 === o2 ? 0 : o1 > o2 ? 1 : -1;");
        }
        transpiler.append(" }");
        transpiler.flush();
    }

    private void transpileSortedComparator2Args(Transpiler transpiler, IType itemType, boolean descending) {
        transpiler = transpiler.newLocalTranspiler();
        this.registerArrowArgs(transpiler.getContext(), itemType);
        if (descending) {
            transpiler.append("function(");
            this.args.transpile(transpiler);
            transpiler.append(") { return -(");
        }
        transpiler.append("function(");
        this.args.transpile(transpiler);
        transpiler.append(") {");
        this.statements.transpile(transpiler);
        transpiler.append("}");
        if (descending) {
            transpiler.append(")(");
            this.args.transpile(transpiler);
            transpiler.append("); }");
        }
        transpiler.flush();
    }

    public void compileGetKeyMethod(Context context, ClassFile classFile, IType paramIType) {
        Identifier arg = (Identifier)this.args.get(0);
        Type paramType = paramIType.getJavaType(context);
        Descriptor.Method proto = new Descriptor.Method(new Type[]{paramType, Object.class});
        MethodInfo method = classFile.newMethod("getKey", proto);
        method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        context = context.newChildContext();
        context.registerValue(new Variable(arg, paramIType));
        method.registerLocal(arg.toString(), IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(paramType));
        this.statements.compile(context, method, new Flags());
    }

    public void compileComparatorMethodBody(Context context, MethodInfo method, IType paramIType) {
        context = context.newChildContext();
        context.registerValue(new Variable((Identifier)this.args.get(0), paramIType));
        context.registerValue(new Variable((Identifier)this.args.get(1), paramIType));
        this.statements.compile(context, method, new Flags().withReturnType(Integer.TYPE));
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        return this.statements.compile(context, method, new Flags());
    }
}

