/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.InterfaceType;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StringConstant;
import prompto.declaration.IDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.grammar.ParameterList;
import prompto.intrinsic.PromptoProxy;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.AnyType;
import prompto.type.DecimalType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.IterableType;
import prompto.type.MethodType;
import prompto.type.NativeType;
import prompto.utils.CodeWriter;
import prompto.value.DecimalValue;
import prompto.value.IValue;
import prompto.value.IntegerValue;
import prompto.value.NullValue;

public class CastExpression
implements IExpression {
    IExpression expression;
    IType type;
    boolean mutable;

    public CastExpression(IExpression expression, IType type, boolean mutable) {
        this.expression = expression;
        this.type = type.anyfy();
        this.mutable = mutable;
    }

    public String toString() {
        return this.expression.toString() + " as " + (this.mutable ? "mutable " : "") + this.type.toString();
    }

    @Override
    public IType check(Context context) {
        IType actual = this.expression.check(context).anyfy();
        IType target = this.getTargetType(context);
        if (actual == AnyType.instance()) {
            return target;
        }
        if (target.isAssignableFrom(context, actual)) {
            return target;
        }
        if (actual.isAssignableFrom(context, target)) {
            return target;
        }
        throw new SyntaxError("Cannot cast " + actual.toString() + " to " + target.toString());
    }

    private IType getTargetType(Context context) {
        return CastExpression.getTargetType(context, this.type, this.mutable);
    }

    private static IType getTargetType(Context context, IType type, boolean mutable) {
        if (type instanceof IterableType) {
            IType itemType = CastExpression.getTargetType(context, ((IterableType)type).getItemType(), false);
            return ((IterableType)type).withItemType(itemType).asMutable(context, mutable);
        }
        if (type instanceof NativeType) {
            return type.asMutable(context, mutable);
        }
        return CastExpression.getTargetAtomicType(context, type, mutable);
    }

    private static IType getTargetAtomicType(Context context, IType type, boolean mutable) {
        IDeclaration decl = context.getRegisteredDeclaration(IDeclaration.class, type.getTypeNameId());
        if (decl == null) {
            context.getProblemListener().reportUnknownIdentifier(type, type.getTypeName());
            return null;
        }
        if (decl instanceof Context.MethodDeclarationMap) {
            Context.MethodDeclarationMap map = (Context.MethodDeclarationMap)decl;
            if (map.size() == 1) {
                return new MethodType(map.getFirst());
            }
            context.getProblemListener().reportAmbiguousIdentifier(type, type.getTypeName());
            return null;
        }
        return decl.getType(context).asMutable(context, mutable);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IValue value = this.expression.interpret(context);
        if (value != null && value != NullValue.instance()) {
            IType target = this.getTargetType(context);
            if (target == DecimalType.instance() && value instanceof IntegerValue) {
                value = new DecimalValue(((IntegerValue)value).doubleValue());
            } else if (target == IntegerType.instance() && value instanceof DecimalValue) {
                value = new IntegerValue(((DecimalValue)value).longValue());
            } else if (target.isMoreSpecificThan(context, value.getType())) {
                value.setType(target);
            }
        }
        return value;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        IType target = this.getTargetType(context);
        if (target instanceof MethodType) {
            return this.compileWithProxy(context, method, flags, (MethodType)target);
        }
        return this.compileCast(context, method, flags, target);
    }

    private ResultInfo compileWithProxy(Context context, MethodInfo method, Flags flags, MethodType target) {
        IMethodDeclaration decl = target.getMethod();
        ParameterList args = decl.getParameters();
        this.expression.compile(context, method, flags);
        ClassConstant dest = new ClassConstant(target.getJavaType(context));
        method.addInstruction(Opcode.LDC, dest);
        InterfaceType intf = new InterfaceType(args, decl.getReturnType());
        String methodName = intf.getInterfaceMethodName();
        method.addInstruction(Opcode.LDC, new StringConstant(methodName));
        List<Type> javaTypes = args.stream().map(arg -> arg.getJavaType(context)).collect(Collectors.toList());
        CompilerUtils.compileClassConstantsArray(method, javaTypes);
        MethodConstant m = new MethodConstant((Type)((Object)PromptoProxy.class), "newProxy", new Type[]{Object.class, Class.class, String.class, Class[].class, Object.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        method.addInstruction(Opcode.CHECKCAST, dest);
        return new ResultInfo(dest.getType(), new ResultInfo.Flag[0]);
    }

    public ResultInfo compileCast(Context context, MethodInfo method, Flags flags, IType target) {
        ResultInfo src = this.expression.compile(context, method, flags);
        Type dest = target.getJavaType(context);
        if (dest == Long.class) {
            return CompilerUtils.numberToLong(method, src);
        }
        if (dest == Double.class) {
            return CompilerUtils.numberToDouble(method, src);
        }
        ClassConstant c = new ClassConstant(dest);
        method.addInstruction(Opcode.CHECKCAST, c);
        return new ResultInfo(dest, new ResultInfo.Flag[0]);
    }

    @Override
    public void toDialect(CodeWriter writer) {
        switch (writer.getDialect()) {
            case E: 
            case M: {
                this.expression.toDialect(writer);
                writer.append(" as ");
                if (this.mutable) {
                    writer.append("mutable ");
                }
                this.type.toDialect(writer);
                break;
            }
            case O: {
                writer.append("(");
                if (this.mutable) {
                    writer.append("mutable ");
                }
                this.type.toDialect(writer);
                writer.append(")");
                this.expression.toDialect(writer);
            }
        }
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.expression.declare(transpiler);
        IType target = this.getTargetType(transpiler.getContext());
        target.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        IType expType = this.expression.check(transpiler.getContext());
        IType target = this.getTargetType(transpiler.getContext());
        if (expType == DecimalType.instance() && target == IntegerType.instance()) {
            transpiler.append("Math.floor(");
            this.expression.transpile(transpiler);
            transpiler.append(")");
        } else {
            this.expression.transpile(transpiler);
        }
        return false;
    }
}

