/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IOperatorFunction;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.OffsetListenerConstant;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.compiler.StackState;
import prompto.compiler.StringConstant;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.TestMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IAssertion;
import prompto.expression.IExpression;
import prompto.expression.IPredicateExpression;
import prompto.expression.InstanceExpression;
import prompto.expression.MemberSelector;
import prompto.expression.UnresolvedIdentifier;
import prompto.grammar.CmpOp;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoDate;
import prompto.intrinsic.PromptoDateTime;
import prompto.intrinsic.PromptoTime;
import prompto.intrinsic.PromptoVersion;
import prompto.parser.Dialect;
import prompto.parser.Section;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.store.AttributeInfo;
import prompto.store.IQueryBuilder;
import prompto.store.IStore;
import prompto.transpiler.Transpiler;
import prompto.type.CharacterType;
import prompto.type.DateTimeType;
import prompto.type.DateType;
import prompto.type.DecimalType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.TextType;
import prompto.type.TimeType;
import prompto.type.VersionType;
import prompto.utils.CodeWriter;
import prompto.utils.StoreUtils;
import prompto.value.BooleanValue;
import prompto.value.IInstance;
import prompto.value.IValue;

public class CompareExpression
extends Section
implements IPredicateExpression,
IAssertion {
    IExpression left;
    CmpOp operator;
    IExpression right;
    static Map<Class<?>, IOperatorFunction> testers = CompareExpression.createTesters();

    public CompareExpression(IExpression left, CmpOp operator, IExpression right) {
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    public String toString() {
        return this.left.toString() + " " + this.operator.toString() + " " + this.right.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        this.left.toDialect(writer);
        writer.append(" ");
        writer.append(this.operator.toString());
        writer.append(" ");
        this.right.toDialect(writer);
    }

    @Override
    public IType check(Context context) {
        IType lt = this.left.check(context);
        IType rt = this.right.check(context);
        return lt.checkCompare(context, rt, this);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IValue lval = this.left.interpret(context);
        IValue rval = this.right.interpret(context);
        return this.compare(context, lval, rval);
    }

    private BooleanValue compare(Context context, IValue lval, IValue rval) throws PromptoError {
        int cmp = lval.compareTo(context, rval);
        switch (this.operator) {
            case GT: {
                return BooleanValue.valueOf(cmp > 0);
            }
            case LT: {
                return BooleanValue.valueOf(cmp < 0);
            }
            case GTE: {
                return BooleanValue.valueOf(cmp >= 0);
            }
            case LTE: {
                return BooleanValue.valueOf(cmp <= 0);
            }
        }
        throw new SyntaxError("Illegal compare operand: " + this.operator.toString());
    }

    private static Map<Class<?>, IOperatorFunction> createTesters() {
        HashMap map = new HashMap();
        map.put(Character.TYPE, CharacterType::compileCompareTo);
        map.put(Character.class, CharacterType::compileCompareTo);
        map.put(String.class, TextType::compileCompareTo);
        map.put(Double.TYPE, DecimalType::compileCompareTo);
        map.put(Double.class, DecimalType::compileCompareTo);
        map.put(Long.TYPE, IntegerType::compileCompareTo);
        map.put(Long.class, IntegerType::compileCompareTo);
        map.put(PromptoDate.class, DateType::compileCompareTo);
        map.put(PromptoDateTime.class, DateTimeType::compileCompareTo);
        map.put(PromptoTime.class, TimeType::compileCompareTo);
        map.put(PromptoVersion.class, VersionType::compileCompareTo);
        return map;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ResultInfo lval = this.left.compile(context, method, flags.withPrimitive(true));
        IOperatorFunction tester = testers.get(lval.getType());
        if (tester == null) {
            System.err.println("Missing IOperatorFunction for compare " + lval.getType().getTypeName());
            throw new SyntaxError("Cannot compare " + lval.getType().getTypeName() + " with " + this.right.check(context).getFamilyInfo(context));
        }
        return tester.compile(context, method, flags.withCmpOp(this.operator), lval, this.right);
    }

    @Override
    public void interpretQuery(Context context, IQueryBuilder query, IStore store) throws PromptoError {
        String name = null;
        IValue value = null;
        if (this.left instanceof UnresolvedIdentifier) {
            name = ((UnresolvedIdentifier)this.left).getName();
            value = this.right.interpret(context);
        } else if (this.left instanceof InstanceExpression) {
            name = ((InstanceExpression)this.left).getName();
            value = this.right.interpret(context);
        } else if (this.right instanceof UnresolvedIdentifier) {
            name = ((UnresolvedIdentifier)this.right).getName();
            value = this.left.interpret(context);
        } else if (this.right instanceof InstanceExpression) {
            name = ((InstanceExpression)this.right).getName();
            value = this.left.interpret(context);
        }
        if (name == null) {
            throw new SyntaxError("Unable to interpret predicate");
        }
        AttributeInfo info = StoreUtils.getAttributeInfo(context, name, store);
        if (value instanceof IInstance) {
            value = ((IInstance)value).getMember(context, new Identifier("dbId"), false);
        }
        IQueryBuilder.MatchOp matchOp = this.getMatchOp();
        query.verify(info, matchOp, value == null ? null : value.getStorableData());
        switch (this.operator) {
            case GTE: 
            case LTE: {
                query.not();
                break;
            }
        }
    }

    private IQueryBuilder.MatchOp getMatchOp() {
        switch (this.operator) {
            case GT: 
            case LTE: {
                return IQueryBuilder.MatchOp.GREATER;
            }
            case LT: 
            case GTE: {
                return IQueryBuilder.MatchOp.LESSER;
            }
        }
        throw new IllegalArgumentException(this.operator.name());
    }

    @Override
    public void compileQuery(Context context, MethodInfo method, Flags flags) {
        boolean reverse = this.compileAttributeInfo(context, method, flags);
        IQueryBuilder.MatchOp match = this.getMatchOp();
        CompilerUtils.compileJavaEnum(context, method, flags, match);
        if (reverse) {
            this.left.compile(context, method, flags);
        } else {
            this.right.compile(context, method, flags);
        }
        InterfaceConstant m = new InterfaceConstant((Type)((Object)IQueryBuilder.class), "verify", new Type[]{AttributeInfo.class, IQueryBuilder.MatchOp.class, Object.class, IQueryBuilder.class});
        method.addInstruction(Opcode.INVOKEINTERFACE, m);
        switch (this.operator) {
            case GTE: 
            case LTE: {
                m = new InterfaceConstant((Type)((Object)IQueryBuilder.class), "not", new Type[]{IQueryBuilder.class});
                method.addInstruction(Opcode.INVOKEINTERFACE, m);
                break;
            }
        }
    }

    private boolean compileAttributeInfo(Context context, MethodInfo method, Flags flags) {
        boolean reverse;
        String name = this.readFieldName(this.left);
        boolean bl = reverse = name == null;
        if (reverse) {
            name = this.readFieldName(this.right);
        }
        AttributeInfo info = context.findAttribute(name).getAttributeInfo(context);
        CompilerUtils.compileAttributeInfo(context, method, flags, info);
        return reverse;
    }

    private String readFieldName(IExpression exp) {
        if (exp instanceof UnresolvedIdentifier || exp instanceof InstanceExpression || exp instanceof MemberSelector) {
            return exp.toString();
        }
        return null;
    }

    @Override
    public boolean interpretAssert(Context context, TestMethodDeclaration test) throws PromptoError {
        IValue rval;
        IValue lval = this.left.interpret(context);
        BooleanValue result = this.compare(context, lval, rval = this.right.interpret(context));
        if (result == BooleanValue.TRUE) {
            return true;
        }
        String expected = this.buildExpectedMessage(context, test);
        String actual = lval.toString() + " " + this.operator.toString() + " " + rval.toString();
        test.printFailedAssertion(context, expected, actual);
        return false;
    }

    private String buildExpectedMessage(Context context, TestMethodDeclaration test) {
        CodeWriter writer = new CodeWriter(test.getDialect(), context);
        this.toDialect(writer);
        return writer.toString();
    }

    @Override
    public void compileAssert(Context context, MethodInfo method, Flags flags, TestMethodDeclaration test) {
        context = context.newChildContext();
        StackState finalState = method.captureStackState();
        IType leftType = this.left.check(context);
        ResultInfo leftInfo = this.left.compile(context, method, flags.withPrimitive(false));
        String leftName = method.nextTransientName("left");
        StackLocal left = method.registerLocal(leftName, IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(leftInfo.getType()));
        CompilerUtils.compileASTORE(method, left);
        IType rightType = this.right.check(context);
        ResultInfo rightInfo = this.right.compile(context, method, flags.withPrimitive(false));
        String rightName = method.nextTransientName("right");
        StackLocal right = method.registerLocal(rightName, IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(rightInfo.getType()));
        CompilerUtils.compileASTORE(method, right);
        InstanceExpression newLeft = new InstanceExpression(new Identifier(leftName));
        context.registerValue(new Variable(new Identifier(leftName), leftType));
        InstanceExpression newRight = new InstanceExpression(new Identifier(rightName));
        context.registerValue(new Variable(new Identifier(rightName), rightType));
        CompareExpression newExp = new CompareExpression(newLeft, this.operator, newRight);
        ResultInfo info = newExp.compile(context, method, flags.withPrimitive(true));
        if (BooleanValue.class == info.getType()) {
            CompilerUtils.BooleanToboolean(method);
        }
        OffsetListenerConstant finalListener = method.addOffsetListener(new OffsetListenerConstant());
        method.activateOffsetListener(finalListener);
        method.addInstruction(Opcode.IFNE, finalListener);
        method.addInstruction(Opcode.ICONST_1, new IOperand[0]);
        method.addInstruction(Opcode.IADD, new IOperand[0]);
        String message = this.buildExpectedMessage(context, test);
        message = test.buildFailedAssertionMessagePrefix(message);
        method.addInstruction(Opcode.LDC, new StringConstant(message));
        CompilerUtils.compileALOAD(method, left);
        MethodConstant toString = new MethodConstant(leftInfo.getType(), "toString", new Type[]{String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, toString);
        MethodConstant concat = new MethodConstant((Type)((Object)String.class), "concat", new Type[]{String.class, String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, concat);
        method.addInstruction(Opcode.LDC, new StringConstant(" " + this.operator.toString() + " "));
        method.addInstruction(Opcode.INVOKEVIRTUAL, concat);
        CompilerUtils.compileALOAD(method, right);
        toString = new MethodConstant(rightInfo.getType(), "toString", new Type[]{String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, toString);
        method.addInstruction(Opcode.INVOKEVIRTUAL, concat);
        test.compileFailure(context, method, flags);
        method.unregisterLocal(right);
        method.unregisterLocal(left);
        method.restoreFullStackState(finalState);
        method.placeLabel(finalState);
        method.inhibitOffsetListener(finalListener);
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.left.declare(transpiler);
        this.right.declare(transpiler);
        IType lt = this.left.check(transpiler.getContext());
        IType rt = this.right.check(transpiler.getContext());
        lt.declareCompare(transpiler, rt);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        IType lt = this.left.check(transpiler.getContext());
        IType rt = this.right.check(transpiler.getContext());
        lt.transpileCompare(transpiler, rt, this.operator, this.left, this.right);
        return false;
    }

    @Override
    public void transpileQuery(Transpiler transpiler, String builderName) {
        String name = null;
        IExpression value = null;
        if (this.left instanceof UnresolvedIdentifier || this.left instanceof InstanceExpression || this.left instanceof MemberSelector) {
            name = this.left.toString();
            value = this.right;
        } else if (this.right instanceof UnresolvedIdentifier || this.right instanceof InstanceExpression || this.right instanceof MemberSelector) {
            name = this.right.toString();
            value = this.left;
        }
        AttributeDeclaration decl = transpiler.getContext().findAttribute(name);
        AttributeInfo info = decl == null ? null : decl.getAttributeInfo(transpiler.getContext());
        IQueryBuilder.MatchOp matchOp = this.getMatchOp();
        transpiler.append(builderName).append(".verify(").append(info.toTranspiled()).append(", MatchOp.").append(matchOp.name()).append(", ");
        value.transpile(transpiler);
        transpiler.append(");").newLine();
        if (this.operator == CmpOp.GTE || this.operator == CmpOp.LTE) {
            transpiler.append(builderName).append(".not();").newLine();
        }
    }

    @Override
    public void transpileFound(Transpiler transpiler, Dialect dialect) {
        transpiler.append("(");
        this.left.transpile(transpiler);
        transpiler.append(") + '").append(this.operator.toString()).append("' + (");
        this.right.transpile(transpiler);
        transpiler.append(")");
    }
}

