/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import prompto.compiler.CompilerUtils;
import prompto.compiler.FieldInfo;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.OffsetListenerConstant;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackState;
import prompto.compiler.StringConstant;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.ConcreteWidgetDeclaration;
import prompto.declaration.NativeCategoryDeclaration;
import prompto.declaration.NativeWidgetDeclaration;
import prompto.error.NotMutableError;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.expression.InstanceExpression;
import prompto.expression.UnresolvedIdentifier;
import prompto.grammar.Argument;
import prompto.grammar.ArgumentList;
import prompto.grammar.Identifier;
import prompto.intrinsic.IMutable;
import prompto.intrinsic.PromptoDocument;
import prompto.param.AttributeParameter;
import prompto.parser.Dialect;
import prompto.parser.Section;
import prompto.runtime.Context;
import prompto.transpiler.ITranspilable;
import prompto.transpiler.Transpiler;
import prompto.type.CategoryType;
import prompto.type.DocumentType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.DocumentValue;
import prompto.value.IInstance;
import prompto.value.IValue;
import prompto.value.NullValue;

public class ConstructorExpression
extends Section
implements IExpression {
    CategoryType type;
    boolean checked;
    IExpression copyFrom = null;
    ArgumentList arguments;

    public ConstructorExpression(CategoryType type, IExpression copyFrom, ArgumentList assignments, boolean checked) {
        this.type = type;
        this.copyFrom = copyFrom;
        this.arguments = assignments;
        this.checked = checked;
    }

    public CategoryType getType() {
        return this.type;
    }

    public String toString() {
        CodeWriter writer = new CodeWriter(Dialect.E, Context.newGlobalsContext());
        this.toDialect(writer);
        return writer.toString();
    }

    public ArgumentList getArguments() {
        return this.arguments;
    }

    public void setCopyFrom(IExpression copyFrom) {
        this.copyFrom = copyFrom;
    }

    public IExpression getCopyFrom() {
        return this.copyFrom;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        Context context = writer.getContext();
        CategoryDeclaration cd = context.getRegisteredDeclaration(CategoryDeclaration.class, this.type.getTypeNameId());
        if (cd == null) {
            context.getProblemListener().reportUnknownCategory(this, this.type.getTypeName());
        }
        this.checkFirstHomonym(context, cd);
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
    }

    private void toMDialect(CodeWriter writer) {
        this.toODialect(writer);
    }

    private void toODialect(CodeWriter writer) {
        this.type.toDialect(writer);
        ArgumentList arguments = new ArgumentList();
        if (this.copyFrom != null) {
            arguments.add(new Argument(new AttributeParameter(new Identifier("from")), this.copyFrom));
        }
        if (this.arguments != null) {
            arguments.addAll(this.arguments);
        }
        arguments.toDialect(writer);
    }

    private void toEDialect(CodeWriter writer) {
        this.type.toDialect(writer);
        if (this.copyFrom != null) {
            writer.append(" from ");
            writer.append(this.copyFrom.toString());
            if (this.arguments != null && this.arguments.size() > 0) {
                writer.append(",");
            }
        }
        if (this.arguments != null) {
            this.arguments.toDialect(writer);
        }
    }

    public void checkFirstHomonym(Context context, CategoryDeclaration decl) {
        if (this.checked) {
            return;
        }
        if (this.arguments != null && this.arguments.size() > 0) {
            this.checkFirstHomonym(context, decl, (Argument)this.arguments.get(0));
        }
        this.checked = true;
    }

    private void checkFirstHomonym(Context context, CategoryDeclaration decl, Argument argument) {
        if (argument.getParameter() == null) {
            IExpression exp = argument.getExpression();
            Identifier name = null;
            if (exp instanceof UnresolvedIdentifier) {
                name = ((UnresolvedIdentifier)exp).getId();
            } else if (exp instanceof InstanceExpression) {
                name = ((InstanceExpression)exp).getId();
            }
            if (name != null && decl.hasAttribute(context, name)) {
                argument.setParameter(new AttributeParameter(name));
                argument.setExpression(null);
            }
        }
    }

    @Override
    public IType check(Context context) {
        IType cft;
        CategoryDeclaration cd = context.getRegisteredDeclaration(CategoryDeclaration.class, this.type.getTypeNameId());
        if (cd == null) {
            context.getProblemListener().reportUnknownCategory(this, this.type.getTypeName());
        }
        this.checkFirstHomonym(context, cd);
        cd.checkConstructorContext(context);
        if (this.copyFrom != null && !((cft = this.copyFrom.check(context)) instanceof CategoryType) && cft != DocumentType.instance()) {
            throw new SyntaxError("Cannot copy from " + cft.getTypeName());
        }
        if (this.arguments != null) {
            context = context.newChildContext();
            for (Argument argument : this.arguments) {
                if (!cd.hasAttribute(context, argument.getParameterId())) {
                    throw new SyntaxError("\"" + argument.getParameterId() + "\" is not an attribute of " + this.type.getTypeName());
                }
                argument.check(context);
            }
        }
        return cd.getType(context).asMutable(context, this.type.isMutable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IValue interpret(Context context) throws PromptoError {
        CategoryDeclaration cd = context.getRegisteredDeclaration(CategoryDeclaration.class, this.type.getTypeNameId());
        if (cd == null) {
            context.getProblemListener().reportUnknownCategory(this, this.type.getTypeName());
        }
        this.checkFirstHomonym(context, cd);
        IInstance instance = this.type.newInstance(context);
        instance.setMutable(true);
        try {
            if (this.copyFrom != null) {
                IValue value;
                IValue copyFrom;
                IValue copyObj = this.copyFrom.interpret(context);
                if (copyObj instanceof IInstance) {
                    copyFrom = (IInstance)copyObj;
                    for (Identifier id : copyFrom.getMemberIds()) {
                        if ("dbId".equals(id.toString()) || !cd.hasAttribute(context, id)) continue;
                        value = copyFrom.getMember(context, id, false);
                        if (value != null && value.isMutable() && !this.type.isMutable()) {
                            throw new NotMutableError();
                        }
                        instance.setMember(context, id, value);
                    }
                } else if (copyObj instanceof DocumentValue) {
                    copyFrom = (DocumentValue)copyObj;
                    for (Identifier id : ((DocumentValue)copyFrom).getMemberIds()) {
                        if ("dbId".equals(id.toString()) || !cd.hasAttribute(context, id)) continue;
                        value = ((DocumentValue)copyFrom).getMember(context, id, false);
                        if (value != null && value.isMutable() && !this.type.isMutable()) {
                            throw new NotMutableError();
                        }
                        if (value != NullValue.instance()) {
                            AttributeDeclaration decl = context.getRegisteredDeclaration(AttributeDeclaration.class, id);
                            value = decl.getType(context).convertIValueToIValue(context, value);
                        }
                        instance.setMember(context, id, value);
                    }
                }
            }
            if (this.arguments != null) {
                for (Argument argument : this.arguments) {
                    Identifier argId = argument.getParameterId();
                    if (cd.hasAttribute(context, argId)) {
                        IValue value = argument.getExpression().interpret(context);
                        if (value != null && value.isMutable() && !this.type.isMutable()) {
                            throw new NotMutableError();
                        }
                        instance.setMember(context, argId, value);
                        continue;
                    }
                    context.getProblemListener().reportUnknownMember(argId, argId.toString());
                }
            }
        }
        finally {
            instance.setMutable(this.type.isMutable());
        }
        return instance;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        CategoryDeclaration cd = context.getRegisteredDeclaration(CategoryDeclaration.class, this.type.getTypeNameId());
        if (cd == null) {
            context.getProblemListener().reportUnknownCategory(this, this.type.getTypeName());
        }
        this.checkFirstHomonym(context, cd);
        Type klass = this.getConcreteType(context);
        ResultInfo result = CompilerUtils.compileNewInstance(method, klass);
        this.compileSetMutable(context, method, flags, result, true);
        this.compileCopyFrom(context, method, flags, result);
        this.compileAssignments(context, method, flags, result);
        this.compileSetMutable(context, method, flags, result, this.type.isMutable());
        return new ResultInfo(this.getInterfaceType(context), new ResultInfo.Flag[0]);
    }

    private void compileSetMutable(Context context, MethodInfo method, Flags flags, ResultInfo thisInfo, boolean set) {
        if (thisInfo.isPromptoCategory()) {
            method.addInstruction(Opcode.DUP, new IOperand[0]);
            method.addInstruction(set ? Opcode.ICONST_1 : Opcode.ICONST_0, new IOperand[0]);
            MethodConstant m = new MethodConstant(thisInfo.getType(), "setMutable", Boolean.TYPE, Void.TYPE);
            method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        }
    }

    private void compileAssignments(Context context, MethodInfo method, Flags flags, ResultInfo thisInfo) {
        if (this.arguments != null) {
            this.arguments.forEach(a -> this.compileAssignment(context, method, flags, thisInfo, (Argument)a));
        }
    }

    private void compileAssignment(Context context, MethodInfo method, Flags flags, ResultInfo thisInfo, Argument argument) {
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        ResultInfo valueInfo = argument.getExpression().compile(context, method, flags);
        this.compileCheckImmutable(context, method, flags, valueInfo);
        AttributeDeclaration decl = context.getRegisteredDeclaration(AttributeDeclaration.class, argument.getParameterId());
        FieldInfo field = decl.toFieldInfo(context);
        if (field.getType() == Boolean.class && !valueInfo.isPromptoAttribute()) {
            CompilerUtils.booleanToBoolean(method, valueInfo);
        } else if (field.getType() == Double.class && !valueInfo.isPromptoAttribute()) {
            CompilerUtils.numberToDouble(method, valueInfo);
        } else if (field.getType() == Long.class && !valueInfo.isPromptoAttribute()) {
            CompilerUtils.numberToLong(method, valueInfo);
        }
        MethodConstant m = new MethodConstant(thisInfo.getType(), CompilerUtils.setterName(field.getName().getValue()), field.getType(), Void.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
    }

    private void compileCheckImmutable(Context context, MethodInfo method, Flags flags, ResultInfo valueInfo) {
        if (!this.type.isMutable() && valueInfo.isPromptoCategory()) {
            StackState stackState = method.captureStackState();
            method.addInstruction(Opcode.DUP, new IOperand[0]);
            OffsetListenerConstant offsetListener = method.addOffsetListener(new OffsetListenerConstant());
            method.activateOffsetListener(offsetListener);
            method.addInstruction(Opcode.IFNULL, offsetListener);
            method.addInstruction(Opcode.DUP, new IOperand[0]);
            InterfaceConstant m = new InterfaceConstant((Type)((Object)IMutable.class), "checkImmutable", Void.TYPE);
            method.addInstruction(Opcode.INVOKEINTERFACE, m);
            method.inhibitOffsetListener(offsetListener);
            method.restoreFullStackState(stackState);
            method.placeLabel(stackState);
        }
    }

    private void compileCopyFrom(Context context, MethodInfo method, Flags flags, ResultInfo thisInfo) {
        if (this.copyFrom == null) {
            return;
        }
        CategoryDeclaration thisCd = context.getRegisteredDeclaration(CategoryDeclaration.class, this.type.getTypeNameId());
        IType otherType = this.copyFrom.check(context);
        if (otherType == DocumentType.instance()) {
            this.compileCopyFromDocument(context, method, flags, thisCd, thisInfo);
        } else {
            CategoryDeclaration otherCd = context.getRegisteredDeclaration(CategoryDeclaration.class, otherType.getTypeNameId());
            this.compileCopyFromInstance(context, method, flags, thisCd, otherCd, thisInfo);
        }
    }

    private void compileCopyFromDocument(Context context, MethodInfo method, Flags flags, CategoryDeclaration thisCd, ResultInfo thisInfo) {
        ResultInfo copyFromInfo = this.copyFrom.compile(context, method, flags.withPrimitive(false));
        Set<Identifier> attrIds = thisCd.getAllAttributes(context);
        for (Identifier attrId : attrIds) {
            this.compileCopyAttributeFromDocument(context, method, flags, thisCd, attrId, thisInfo, copyFromInfo);
        }
        method.addInstruction(Opcode.POP, new IOperand[0]);
    }

    private void compileCopyAttributeFromDocument(Context context, MethodInfo method, Flags flags, CategoryDeclaration thisCd, Identifier attrId, ResultInfo thisInfo, ResultInfo copyFromInfo) {
        if (this.willBeAssigned(attrId)) {
            return;
        }
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        method.addInstruction(Opcode.LDC, new StringConstant(attrId.toString()));
        MethodConstant m = new MethodConstant((Type)((Object)PromptoDocument.class), "get", new Type[]{Object.class, Object.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        AttributeDeclaration decl = context.getRegisteredDeclaration(AttributeDeclaration.class, attrId);
        FieldInfo field = decl.toFieldInfo(context);
        decl.getType(context).compileConvertObjectToExact(context, method, flags);
        method.addInstruction(Opcode.DUP_X2, new IOperand[0]);
        method.addInstruction(Opcode.POP, new IOperand[0]);
        method.addInstruction(Opcode.DUP_X2, new IOperand[0]);
        method.addInstruction(Opcode.POP, new IOperand[0]);
        method.addInstruction(Opcode.DUP_X2, new IOperand[0]);
        method.addInstruction(Opcode.SWAP, new IOperand[0]);
        m = new MethodConstant(thisInfo.getType(), CompilerUtils.setterName(attrId.toString()), field.getType(), Void.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
    }

    private void compileCopyFromInstance(Context context, MethodInfo method, Flags flags, CategoryDeclaration thisCd, CategoryDeclaration otherCd, ResultInfo thisInfo) {
        ResultInfo copyFromInfo = this.copyFrom.compile(context, method, flags.withPrimitive(false));
        Set<Identifier> attrIds = thisCd.getAllAttributes(context);
        for (Identifier attrId : attrIds) {
            this.compileCopyAttributeFromInstance(context, method, flags, thisCd, otherCd, attrId, thisInfo, copyFromInfo);
        }
        method.addInstruction(Opcode.POP, new IOperand[0]);
    }

    private void compileCopyAttributeFromInstance(Context context, MethodInfo method, Flags flags, CategoryDeclaration thisCd, CategoryDeclaration otherCd, Identifier attrId, ResultInfo thisInfo, ResultInfo copyFromInfo) {
        if (this.willBeAssigned(attrId) || !otherCd.hasAttribute(context, attrId)) {
            return;
        }
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        AttributeDeclaration decl = context.getRegisteredDeclaration(AttributeDeclaration.class, attrId);
        FieldInfo field = decl.toFieldInfo(context);
        InterfaceConstant i = new InterfaceConstant(copyFromInfo.getType(), CompilerUtils.getterName(attrId.toString()), field.getType());
        method.addInstruction(Opcode.INVOKEINTERFACE, i);
        method.addInstruction(Opcode.DUP_X2, new IOperand[0]);
        method.addInstruction(Opcode.POP, new IOperand[0]);
        method.addInstruction(Opcode.DUP_X2, new IOperand[0]);
        method.addInstruction(Opcode.POP, new IOperand[0]);
        method.addInstruction(Opcode.DUP_X2, new IOperand[0]);
        method.addInstruction(Opcode.SWAP, new IOperand[0]);
        MethodConstant m = new MethodConstant(thisInfo.getType(), CompilerUtils.setterName(attrId.toString()), field.getType(), Void.TYPE);
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
    }

    private boolean willBeAssigned(Identifier name) {
        if (this.arguments != null) {
            for (Argument argument : this.arguments) {
                if (!name.equals(argument.getParameterId())) continue;
                return true;
            }
        }
        return false;
    }

    private Type getInterfaceType(Context context) {
        CategoryDeclaration cd = context.getRegisteredDeclaration(CategoryDeclaration.class, this.type.getTypeNameId());
        if (cd instanceof NativeCategoryDeclaration) {
            return ((NativeCategoryDeclaration)cd).getBoundClass(false);
        }
        return CompilerUtils.getCategoryInterfaceType(cd.getId());
    }

    private Type getConcreteType(Context context) {
        CategoryDeclaration cd = context.getRegisteredDeclaration(CategoryDeclaration.class, this.type.getTypeNameId());
        if (cd instanceof NativeCategoryDeclaration) {
            return ((NativeCategoryDeclaration)cd).getBoundClass(false);
        }
        return CompilerUtils.getCategoryConcreteType(cd.getId());
    }

    @Override
    public void declare(Transpiler transpiler) {
        CategoryDeclaration cd = transpiler.getContext().getRegisteredDeclaration(CategoryDeclaration.class, this.type.getTypeNameId());
        this.checkFirstHomonym(transpiler.getContext(), cd);
        cd.declare(transpiler);
        if (this.copyFrom != null) {
            this.copyFrom.declare(transpiler);
        }
        if (this.arguments != null) {
            this.arguments.declare(transpiler, null);
        }
    }

    public void ensureDeclarationOrder(Context context, List<ITranspilable> list, Set<ITranspilable> set) {
        CategoryDeclaration cd = context.getRegisteredDeclaration(CategoryDeclaration.class, this.type.getTypeNameId());
        cd.ensureDeclarationOrder(context, list, set);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        CategoryDeclaration cd = transpiler.getContext().getRegisteredDeclaration(CategoryDeclaration.class, this.type.getTypeNameId());
        this.checkFirstHomonym(transpiler.getContext(), cd);
        if (cd instanceof NativeWidgetDeclaration) {
            this.transpileNativeWidget(transpiler, (NativeWidgetDeclaration)cd);
        } else if (cd instanceof ConcreteWidgetDeclaration) {
            this.transpileConcreteWidget(transpiler, (ConcreteWidgetDeclaration)cd);
        } else if (cd instanceof NativeCategoryDeclaration) {
            this.transpileNative(transpiler, (NativeCategoryDeclaration)cd);
        } else {
            this.transpileConcrete(transpiler);
        }
        return false;
    }

    private void transpileConcrete(Transpiler transpiler) {
        transpiler = transpiler.newInstanceTranspiler(this.type);
        transpiler.append("new ").append(this.type.getTypeName()).append("(");
        if (this.copyFrom != null) {
            this.copyFrom.transpile(transpiler);
        } else {
            transpiler.append("null");
        }
        transpiler.append(", ");
        this.transpileAssignments(transpiler);
        transpiler.append(", ");
        transpiler.append(this.type.isMutable());
        transpiler.append(")");
        transpiler.flush();
    }

    private void transpileConcreteWidget(Transpiler transpiler, ConcreteWidgetDeclaration decl) {
        transpiler = transpiler.newInstanceTranspiler(this.type);
        transpiler.append("new ").append(this.type.getTypeName()).append("()");
        transpiler.flush();
    }

    private void transpileAssignments(Transpiler transpiler) {
        if (this.arguments != null) {
            transpiler.append("{");
            this.arguments.forEach(argument -> {
                transpiler.append(argument.getParameter().getName()).append(":");
                argument.getExpression().transpile(transpiler);
                transpiler.append(", ");
            });
            transpiler.trimLast(2);
            transpiler.append("}");
        } else {
            transpiler.append("null");
        }
    }

    private void transpileNative(Transpiler transpiler, NativeCategoryDeclaration decl) {
        String bound = decl.getTranspiledBoundClass();
        transpiler.append("new_").append(bound).append("(");
        this.transpileAssignments(transpiler);
        transpiler.append(")");
    }

    private void transpileNativeWidget(Transpiler transpiler, NativeWidgetDeclaration decl) {
        String bound = decl.getTranspiledBoundClass();
        transpiler.append("new ").append(bound).append("()");
    }
}

