/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.stream.StreamSupport;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.OffsetListenerConstant;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.compiler.StackState;
import prompto.compiler.StringConstant;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.TestMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IAssertion;
import prompto.expression.IExpression;
import prompto.expression.IPredicateExpression;
import prompto.expression.InstanceExpression;
import prompto.expression.MemberSelector;
import prompto.expression.UnresolvedIdentifier;
import prompto.grammar.ContOp;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoString;
import prompto.parser.Dialect;
import prompto.parser.Section;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.store.AttributeInfo;
import prompto.store.Family;
import prompto.store.FamilyInfo;
import prompto.store.IQueryBuilder;
import prompto.store.IStore;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.utils.StoreUtils;
import prompto.value.BooleanValue;
import prompto.value.IContainer;
import prompto.value.IInstance;
import prompto.value.IIterable;
import prompto.value.IValue;

public class ContainsExpression
extends Section
implements IPredicateExpression,
IAssertion {
    IExpression left;
    ContOp operator;
    IExpression right;

    public ContainsExpression(IExpression left, ContOp operator, IExpression right) {
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    public String toString() {
        return this.left.toString() + " " + this.operator.toString() + " " + this.right.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        this.left.toDialect(writer);
        writer.append(" ");
        writer.append(this.operator.toString());
        writer.append(" ");
        this.right.toDialect(writer);
    }

    @Override
    public IType check(Context context) {
        IType lt = this.left.check(context);
        IType rt = this.right.check(context);
        switch (this.operator) {
            case IN: 
            case NOT_IN: {
                return rt.checkContains(context, lt);
            }
            case HAS: 
            case NOT_HAS: {
                return lt.checkContains(context, rt);
            }
        }
        return lt.checkContainsAllOrAny(context, rt);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IValue lval = this.left.interpret(context);
        IValue rval = this.right.interpret(context);
        return this.interpret(context, lval, rval);
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ResultInfo result = this.compileOperator(context, method, flags.withPrimitive(true));
        if (this.operator.name().startsWith("NOT_")) {
            return this.compileNot(context, method, flags, result);
        }
        if (!flags.toPrimitive() && Boolean.TYPE == result.getType()) {
            return CompilerUtils.booleanToBoolean(method);
        }
        return result;
    }

    private ResultInfo compileNot(Context context, MethodInfo method, Flags flags, ResultInfo info) {
        if (BooleanValue.class == info.getType()) {
            CompilerUtils.BooleanToboolean(method);
        }
        CompilerUtils.reverseBoolean(method);
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }

    private ResultInfo compileOperator(Context context, MethodInfo method, Flags flags) {
        switch (this.operator) {
            case IN: 
            case NOT_IN: {
                return this.compileContains(context, method, flags, this.right, this.left);
            }
            case HAS: 
            case NOT_HAS: {
                return this.compileContains(context, method, flags, this.left, this.right);
            }
            case HAS_ALL: 
            case NOT_HAS_ALL: {
                return this.compileContainsAll(context, method, flags, this.left, this.right);
            }
            case HAS_ANY: 
            case NOT_HAS_ANY: {
                return this.compileContainsAny(context, method, flags, this.left, this.right);
            }
        }
        throw new UnsupportedOperationException("Uknown operator: " + this.operator.name());
    }

    private ResultInfo compileContains(Context context, MethodInfo method, Flags flags, IExpression left, IExpression right) {
        ResultInfo linfo = left.compile(context, method, flags);
        right.compile(context, method, flags.withPrimitive(false));
        if (String.class == linfo.getType()) {
            MethodConstant m = new MethodConstant((Type)((Object)PromptoString.class), "contains", new Type[]{String.class, Object.class, Boolean.TYPE});
            method.addInstruction(Opcode.INVOKESTATIC, m);
            if (flags.toPrimitive()) {
                return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
            }
            return CompilerUtils.booleanToBoolean(method);
        }
        MethodConstant m = new MethodConstant(linfo.getType(), "contains", new Type[]{Object.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }

    private ResultInfo compileContainsAll(Context context, MethodInfo method, Flags flags, IExpression left, IExpression right) {
        ResultInfo linfo = left.compile(context, method, flags);
        right.compile(context, method, flags.withPrimitive(false));
        if (String.class == linfo.getType()) {
            MethodConstant m = new MethodConstant((Type)((Object)PromptoString.class), "containsAll", new Type[]{String.class, Object.class, Boolean.TYPE});
            method.addInstruction(Opcode.INVOKESTATIC, m);
            if (flags.toPrimitive()) {
                return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
            }
            return CompilerUtils.booleanToBoolean(method);
        }
        MethodConstant m = new MethodConstant(linfo.getType(), "containsAll", new Type[]{Collection.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }

    private ResultInfo compileContainsAny(Context context, MethodInfo method, Flags flags, IExpression left, IExpression right) {
        ResultInfo linfo = left.compile(context, method, flags);
        right.compile(context, method, flags.withPrimitive(false));
        if (String.class == linfo.getType()) {
            MethodConstant m = new MethodConstant((Type)((Object)PromptoString.class), "containsAny", new Type[]{String.class, Object.class, Boolean.TYPE});
            method.addInstruction(Opcode.INVOKESTATIC, m);
            if (flags.toPrimitive()) {
                return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
            }
            return CompilerUtils.booleanToBoolean(method);
        }
        MethodConstant m = new MethodConstant(linfo.getType(), "containsAny", new Type[]{Collection.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }

    private IValue interpret(Context context, IValue lval, IValue rval) throws PromptoError {
        Boolean result = null;
        switch (this.operator) {
            case IN: 
            case NOT_IN: {
                if (rval instanceof IContainer) {
                    result = ((IContainer)rval).hasItem(context, lval);
                    break;
                }
                if (!(rval instanceof IIterable)) break;
                result = this.containsOne(context, (IIterable)rval, lval);
                break;
            }
            case HAS: 
            case NOT_HAS: {
                if (lval instanceof IContainer) {
                    result = ((IContainer)lval).hasItem(context, rval);
                    break;
                }
                if (!(lval instanceof IIterable)) break;
                result = this.containsOne(context, (IIterable)lval, rval);
                break;
            }
            case HAS_ALL: 
            case NOT_HAS_ALL: {
                if (!(lval instanceof IContainer) || !(rval instanceof IContainer)) break;
                result = this.containsAll(context, (IContainer)lval, (IContainer)rval);
                break;
            }
            case HAS_ANY: 
            case NOT_HAS_ANY: {
                if (!(lval instanceof IContainer) || !(rval instanceof IContainer)) break;
                result = this.containsAny(context, (IContainer)lval, (IContainer)rval);
            }
        }
        if (result != null) {
            if (this.operator.name().startsWith("NOT_")) {
                result = result == false;
            }
            return BooleanValue.valueOf(result);
        }
        if (this.operator.name().endsWith("IN")) {
            IValue tmp = lval;
            lval = rval;
            rval = tmp;
        }
        String lowerName = this.operator.name().toLowerCase().replace('_', ' ');
        throw new SyntaxError("Illegal comparison: " + lval.getClass().getSimpleName() + " " + lowerName + " " + rval.getClass().getSimpleName());
    }

    private Boolean containsOne(Context context, IIterable<?> container, IValue item) {
        return StreamSupport.stream(container.getIterable(context).spliterator(), false).anyMatch(o -> o.equals(item));
    }

    public boolean containsAll(Context context, IContainer<?> container, IContainer<?> items) throws PromptoError {
        for (IValue item : items.getIterable(context)) {
            if (container.hasItem(context, item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(Context context, IContainer<?> container, IContainer<?> items) throws PromptoError {
        for (IValue item : items.getIterable(context)) {
            if (!container.hasItem(context, item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean interpretAssert(Context context, TestMethodDeclaration test) throws PromptoError {
        IValue rval;
        IValue lval = this.left.interpret(context);
        IValue result = this.interpret(context, lval, rval = this.right.interpret(context));
        if (result == BooleanValue.TRUE) {
            return true;
        }
        String expected = this.buildExpectedMessage(context, test);
        String actual = lval.toString() + " " + this.operator.toString() + " " + rval.toString();
        test.printFailedAssertion(context, expected, actual);
        return false;
    }

    private String buildExpectedMessage(Context context, TestMethodDeclaration test) {
        CodeWriter writer = new CodeWriter(test.getDialect(), context);
        this.toDialect(writer);
        return writer.toString();
    }

    @Override
    public void compileAssert(Context context, MethodInfo method, Flags flags, TestMethodDeclaration test) {
        context = context.newChildContext();
        StackState finalState = method.captureStackState();
        IType leftType = this.left.check(context);
        ResultInfo leftInfo = this.left.compile(context, method, flags.withPrimitive(false));
        String leftName = method.nextTransientName("left");
        StackLocal left = method.registerLocal(leftName, IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(leftInfo.getType()));
        CompilerUtils.compileASTORE(method, left);
        IType rightType = this.right.check(context);
        ResultInfo rightInfo = this.right.compile(context, method, flags.withPrimitive(true));
        String rightName = method.nextTransientName("right");
        StackLocal right = method.registerLocal(rightName, IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(rightInfo.getType()));
        CompilerUtils.compileASTORE(method, right);
        InstanceExpression newLeft = new InstanceExpression(new Identifier(leftName));
        context.registerValue(new Variable(new Identifier(leftName), leftType));
        InstanceExpression newRight = new InstanceExpression(new Identifier(rightName));
        context.registerValue(new Variable(new Identifier(rightName), rightType));
        ContainsExpression newExp = new ContainsExpression(newLeft, this.operator, newRight);
        ResultInfo info = newExp.compile(context, method, flags.withPrimitive(true));
        if (BooleanValue.class == info.getType()) {
            CompilerUtils.BooleanToboolean(method);
        }
        OffsetListenerConstant finalListener = method.addOffsetListener(new OffsetListenerConstant());
        method.activateOffsetListener(finalListener);
        method.addInstruction(Opcode.IFNE, finalListener);
        method.addInstruction(Opcode.ICONST_1, new IOperand[0]);
        method.addInstruction(Opcode.IADD, new IOperand[0]);
        String message = this.buildExpectedMessage(context, test);
        message = test.buildFailedAssertionMessagePrefix(message);
        method.addInstruction(Opcode.LDC, new StringConstant(message));
        CompilerUtils.compileALOAD(method, left);
        MethodConstant toString = new MethodConstant(leftInfo.getType(), "toString", new Type[]{String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, toString);
        MethodConstant concat = new MethodConstant((Type)((Object)String.class), "concat", new Type[]{String.class, String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, concat);
        method.addInstruction(Opcode.LDC, new StringConstant(" " + this.operator.toString() + " "));
        method.addInstruction(Opcode.INVOKEVIRTUAL, concat);
        CompilerUtils.compileALOAD(method, right);
        toString = new MethodConstant(rightInfo.getType(), "toString", new Type[]{String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, toString);
        method.addInstruction(Opcode.INVOKEVIRTUAL, concat);
        test.compileFailure(context, method, flags);
        method.unregisterLocal(right);
        method.unregisterLocal(left);
        method.restoreFullStackState(finalState);
        method.placeLabel(finalState);
        method.inhibitOffsetListener(finalListener);
    }

    @Override
    public void interpretQuery(Context context, IQueryBuilder query, IStore store) throws PromptoError {
        boolean reverse;
        IValue value = null;
        String name = this.readFieldName(this.left);
        boolean bl = reverse = name == null;
        if (name != null) {
            value = this.right.interpret(context);
        } else {
            name = this.readFieldName(this.right);
            if (name != null) {
                value = this.left.interpret(context);
            } else {
                throw new SyntaxError("Unable to interpret predicate");
            }
        }
        AttributeInfo fieldInfo = StoreUtils.getAttributeInfo(context, name, store);
        FamilyInfo valueInfo = value.getType().getFamilyInfo(context);
        IQueryBuilder.MatchOp matchOp = this.getMatchOp(context, fieldInfo, valueInfo, this.operator, reverse);
        if (value instanceof IInstance) {
            value = ((IInstance)value).getMember(context, new Identifier("dbId"), false);
        }
        Object data = value == null ? null : value.getStorableData();
        query.verify(fieldInfo, matchOp, data);
        if (this.operator.name().startsWith("NOT_")) {
            query.not();
        }
    }

    @Override
    public void compileQuery(Context context, MethodInfo method, Flags flags) {
        boolean reverse;
        IType valueType = null;
        String name = this.readFieldName(this.left);
        boolean bl = reverse = name == null;
        if (name != null) {
            valueType = this.right.check(context);
        } else {
            name = this.readFieldName(this.right);
            if (name != null) {
                valueType = this.left.check(context);
            } else {
                throw new SyntaxError("Unable to interpret predicate");
            }
        }
        AttributeInfo fieldInfo = context.findAttribute(name).getAttributeInfo(context);
        CompilerUtils.compileAttributeInfo(context, method, flags, fieldInfo);
        FamilyInfo valueInfo = valueType.getFamilyInfo(context);
        IQueryBuilder.MatchOp match = this.getMatchOp(context, fieldInfo, valueInfo, this.operator, reverse);
        CompilerUtils.compileJavaEnum(context, method, flags, match);
        if (reverse) {
            this.left.compile(context, method, flags);
        } else {
            this.right.compile(context, method, flags);
        }
        InterfaceConstant m = new InterfaceConstant((Type)((Object)IQueryBuilder.class), "verify", new Type[]{AttributeInfo.class, IQueryBuilder.MatchOp.class, Object.class, IQueryBuilder.class});
        method.addInstruction(Opcode.INVOKEINTERFACE, m);
        if (this.operator.name().startsWith("NOT_")) {
            m = new InterfaceConstant((Type)((Object)IQueryBuilder.class), "not", new Type[]{IQueryBuilder.class});
            method.addInstruction(Opcode.INVOKEINTERFACE, m);
        }
    }

    private IQueryBuilder.MatchOp getMatchOp(Context context, FamilyInfo fieldInfo, FamilyInfo valueInfo, ContOp operator, boolean reverse) {
        if (reverse) {
            if ((operator = operator.reverse()) == null) {
                context.getProblemListener().reportIllegalOperation(this, "Cannot reverse " + (Object)((Object)this.operator));
            }
            return this.getMatchOp(context, valueInfo, fieldInfo, operator, false);
        }
        if (fieldInfo.getFamily() == Family.TEXT && (valueInfo.getFamily() == Family.TEXT || valueInfo.getFamily() == Family.CHARACTER)) {
            switch (operator) {
                case HAS: 
                case NOT_HAS: {
                    return IQueryBuilder.MatchOp.CONTAINS;
                }
            }
        }
        if (valueInfo.isCollection()) {
            switch (operator) {
                case IN: 
                case NOT_IN: {
                    return IQueryBuilder.MatchOp.IN;
                }
            }
        }
        if (fieldInfo.isCollection()) {
            switch (operator) {
                case HAS: 
                case NOT_HAS: {
                    return IQueryBuilder.MatchOp.CONTAINS;
                }
            }
        }
        throw new SyntaxError("Unsupported operator: " + operator.name());
    }

    private String readFieldName(IExpression exp) {
        if (exp instanceof UnresolvedIdentifier || exp instanceof InstanceExpression || exp instanceof MemberSelector) {
            return exp.toString();
        }
        return null;
    }

    @Override
    public void declare(Transpiler transpiler) {
        IType lt = this.left.check(transpiler.getContext());
        IType rt = this.right.check(transpiler.getContext());
        switch (this.operator) {
            case IN: 
            case NOT_IN: {
                rt.declareContains(transpiler, lt, this.right, this.left);
                break;
            }
            case HAS: 
            case NOT_HAS: {
                lt.declareContains(transpiler, rt, this.left, this.right);
                break;
            }
            default: {
                lt.declareContainsAllOrAny(transpiler, rt, this.left, this.right);
            }
        }
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        IType lt = this.left.check(transpiler.getContext());
        IType rt = this.right.check(transpiler.getContext());
        switch (this.operator) {
            case NOT_IN: {
                transpiler.append("!");
            }
            case IN: {
                rt.transpileContains(transpiler, lt, this.right, this.left);
                return false;
            }
            case NOT_HAS: {
                transpiler.append("!");
            }
            case HAS: {
                lt.transpileContains(transpiler, rt, this.left, this.right);
                return false;
            }
            case NOT_HAS_ALL: {
                transpiler.append("!");
            }
            case HAS_ALL: {
                lt.transpileContainsAll(transpiler, rt, this.left, this.right);
                return false;
            }
            case NOT_HAS_ANY: {
                transpiler.append("!");
            }
            case HAS_ANY: {
                lt.transpileContainsAny(transpiler, rt, this.left, this.right);
                return false;
            }
        }
        throw new UnsupportedOperationException("Unsupported " + (Object)((Object)this.operator));
    }

    @Override
    public void transpileQuery(Transpiler transpiler, String builderName) {
        boolean reverse = false;
        IExpression value = null;
        String name = this.readFieldName(this.left);
        if (name != null) {
            value = this.right;
        } else {
            reverse = true;
            name = this.readFieldName(this.right);
            if (name != null) {
                value = this.left;
            } else {
                throw new SyntaxError("Unable to transpile predicate");
            }
        }
        AttributeDeclaration decl = transpiler.getContext().findAttribute(name);
        AttributeInfo fieldInfo = decl.getAttributeInfo(transpiler.getContext());
        IType valueType = value.check(transpiler.getContext());
        FamilyInfo valueInfo = valueType.getFamilyInfo(transpiler.getContext());
        IQueryBuilder.MatchOp matchOp = this.getMatchOp(transpiler.getContext(), fieldInfo, valueInfo, this.operator, reverse);
        transpiler.append(builderName).append(".verify(").append(fieldInfo.toTranspiled()).append(", MatchOp.").append(matchOp.name()).append(", ");
        value.transpile(transpiler);
        transpiler.append(");").newLine();
        if (this.operator.name().indexOf("NOT_") == 0) {
            transpiler.append(builderName).append(".not();").newLine();
        }
    }

    @Override
    public void transpileFound(Transpiler transpiler, Dialect dialect) {
        transpiler.append("(");
        this.left.transpile(transpiler);
        transpiler.append(") + '").append(this.operator.toString()).append("' + (");
        this.right.transpile(transpiler);
        transpiler.append(")");
    }
}

