/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.util.HashMap;
import java.util.Map;
import prompto.compiler.Flags;
import prompto.compiler.IOperatorFunction;
import prompto.compiler.MethodInfo;
import prompto.compiler.ResultInfo;
import prompto.declaration.CategoryDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.DecimalType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public class DivideExpression
implements IExpression {
    IExpression left;
    IExpression right;
    static Map<Class<?>, IOperatorFunction> dividers = DivideExpression.createDividers();

    public DivideExpression(IExpression left, IExpression right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        this.left.toDialect(writer);
        writer.append(" / ");
        this.right.toDialect(writer);
    }

    @Override
    public IType check(Context context) {
        IType lt = this.left.check(context);
        IType rt = this.right.check(context);
        return lt.checkDivide(context, rt);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IValue lval = this.left.interpret(context);
        IValue rval = this.right.interpret(context);
        return lval.divide(context, rval);
    }

    private static Map<Class<?>, IOperatorFunction> createDividers() {
        HashMap map = new HashMap();
        map.put(Double.TYPE, DecimalType::compileDivide);
        map.put(Double.class, DecimalType::compileDivide);
        map.put(Long.TYPE, IntegerType::compileDivide);
        map.put(Long.class, IntegerType::compileDivide);
        return map;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ResultInfo lval = this.left.compile(context, method, flags);
        IOperatorFunction divider = dividers.get(lval.getType());
        if (divider == null && lval.getType().getTypeName().startsWith("\u03c0.\u03c7.")) {
            divider = CategoryDeclaration::compileDivide;
        }
        if (divider == null) {
            System.err.println("Missing IOperatorFunction for divide " + lval.getType().getTypeName());
            throw new SyntaxError("Cannot divide " + lval.getType().getTypeName() + " by " + this.right.check(context).getFamilyInfo(context));
        }
        return divider.compile(context, method, flags, lval, this.right);
    }

    @Override
    public void declare(Transpiler transpiler) {
        IType lt = this.left.check(transpiler.getContext());
        IType rt = this.right.check(transpiler.getContext());
        lt.declareDivide(transpiler, rt, this.left, this.right);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        IType lt = this.left.check(transpiler.getContext());
        IType rt = this.right.check(transpiler.getContext());
        lt.transpileDivide(transpiler, rt, this.left, this.right);
        return false;
    }
}

