/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Type;
import java.security.InvalidParameterException;
import java.util.Map;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.expression.IExpression;
import prompto.intrinsic.PromptoDocument;
import prompto.parser.ECleverParser;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.DocumentType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.utils.Logger;
import prompto.value.BlobValue;
import prompto.value.ConcreteInstance;
import prompto.value.DocumentValue;
import prompto.value.IValue;
import prompto.value.NullValue;

public class DocumentExpression
implements IExpression {
    private static Logger logger = new Logger();
    IExpression source;

    public DocumentExpression(IExpression source) {
        this.source = source;
    }

    @Override
    public IType check(Context context) {
        if (this.source != null) {
            this.source.check(context);
        }
        return DocumentType.instance();
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        if (this.source == null) {
            return new DocumentValue();
        }
        IValue value = this.source.interpret(context);
        return this.documentFromValue(context, value);
    }

    private DocumentValue documentFromValue(Context context, IValue value) {
        if (value instanceof BlobValue) {
            return this.documentFromBlob(context, (BlobValue)value);
        }
        if (value instanceof ConcreteInstance) {
            return (DocumentValue)value.toDocumentValue(context);
        }
        if (value == NullValue.instance()) {
            return new DocumentValue();
        }
        throw new UnsupportedOperationException();
    }

    private DocumentValue documentFromBlob(Context context, BlobValue blob) {
        if (!"application/zip".equals(blob.getMimeType())) {
            throw new UnsupportedOperationException("Unsupported mime type: " + blob.getMimeType());
        }
        try {
            Map<String, byte[]> parts = PromptoDocument.readParts(blob.getData());
            JsonNode value = PromptoDocument.readValue(parts);
            JsonNode field = value.get("type");
            if (field == null) {
                throw new InvalidParameterException("Expecting a 'type' field!");
            }
            IType type = new ECleverParser(field.asText()).parse_standalone_type();
            if (type != DocumentType.instance()) {
                throw new InvalidParameterException("Expecting a Document type!");
            }
            field = value.get("value");
            if (field == null) {
                throw new InvalidParameterException("Expecting a 'value' field!");
            }
            return (DocumentValue)type.readJSONValue(context, field, parts);
        }
        catch (Throwable t) {
            logger.error(() -> "While parsing blob data", t);
            throw new ReadWriteError(t.getMessage());
        }
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ResultInfo doc = CompilerUtils.compileNewInstance(method, PromptoDocument.class);
        if (this.source != null) {
            method.addInstruction(Opcode.DUP, new IOperand[0]);
            this.source.compile(context, method, flags);
            MethodConstant m = new MethodConstant((Type)((Object)PromptoDocument.class), "populateFrom", new Type[]{Object.class, Void.TYPE});
            method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        }
        return doc;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append("Document");
        switch (writer.getDialect()) {
            case E: {
                if (this.source == null) break;
                writer.append(" from ");
                this.source.toDialect(writer);
                break;
            }
            case O: 
            case M: {
                writer.append('(');
                if (this.source != null) {
                    writer.append("from = ");
                    this.source.toDialect(writer);
                }
                writer.append(')');
            }
        }
    }

    public String toString() {
        return "Document";
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("Document");
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        if (this.source != null) {
            this.source.transpile(transpiler);
            transpiler.append(".toDocument()");
        } else {
            transpiler.append("new Document()");
        }
        return false;
    }
}

