/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IOperatorFunction;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.OffsetListenerConstant;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.ShortOperand;
import prompto.compiler.StackLocal;
import prompto.compiler.StackState;
import prompto.compiler.StringConstant;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.TestMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IAssertion;
import prompto.expression.IExpression;
import prompto.expression.IPredicateExpression;
import prompto.expression.InstanceExpression;
import prompto.expression.MemberSelector;
import prompto.expression.NativeSymbol;
import prompto.expression.TypeExpression;
import prompto.expression.UnresolvedIdentifier;
import prompto.grammar.EqOp;
import prompto.grammar.INamed;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoAny;
import prompto.intrinsic.PromptoDate;
import prompto.intrinsic.PromptoDateTime;
import prompto.intrinsic.PromptoDict;
import prompto.intrinsic.PromptoList;
import prompto.intrinsic.PromptoPeriod;
import prompto.intrinsic.PromptoRange;
import prompto.intrinsic.PromptoSet;
import prompto.intrinsic.PromptoTime;
import prompto.intrinsic.PromptoVersion;
import prompto.literal.NullLiteral;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.runtime.LinkedValue;
import prompto.runtime.LinkedVariable;
import prompto.runtime.Variable;
import prompto.store.AttributeInfo;
import prompto.store.DataStore;
import prompto.store.IQueryBuilder;
import prompto.store.IStore;
import prompto.transpiler.Transpiler;
import prompto.type.AnyType;
import prompto.type.BooleanType;
import prompto.type.CharacterType;
import prompto.type.ContainerType;
import prompto.type.DateTimeType;
import prompto.type.DateType;
import prompto.type.DecimalType;
import prompto.type.DictType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.ListType;
import prompto.type.NullType;
import prompto.type.PeriodType;
import prompto.type.RangeType;
import prompto.type.SetType;
import prompto.type.TextType;
import prompto.type.TimeType;
import prompto.type.UuidType;
import prompto.type.VersionType;
import prompto.utils.CodeWriter;
import prompto.utils.StoreUtils;
import prompto.value.BooleanValue;
import prompto.value.IInstance;
import prompto.value.IValue;
import prompto.value.NullValue;
import prompto.value.TypeValue;

public class EqualsExpression
implements IPredicateExpression,
IAssertion {
    IExpression left;
    EqOp operator;
    IExpression right;
    static final String VOWELS = "AEIO";
    static Map<Class<?>, IOperatorFunction> EQUALS_COMPILERS = EqualsExpression.createEqualsCompilers();
    static Map<Class<?>, IOperatorFunction> CONTAINS_COMPILERS = EqualsExpression.createContainsCompilers();

    public EqualsExpression(IExpression left, EqOp operator, IExpression right) {
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    public String toString() {
        return this.left.toString() + ' ' + this.operator.toString() + ' ' + this.right.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        String name;
        this.left.toDialect(writer);
        writer.append(" ");
        writer.append(this.operator.toString(writer.getDialect()));
        if ((this.operator == EqOp.IS_A || this.operator == EqOp.IS_NOT_A) && VOWELS.indexOf((name = this.right.toString()).charAt(0)) >= 0) {
            writer.append("n");
        }
        writer.append(" ");
        this.right.toDialect(writer);
    }

    @Override
    public IType check(Context context) {
        IType rt;
        IType lt = this.left.check(context);
        if (lt instanceof ContainerType) {
            lt = ((ContainerType)lt).getItemType();
        }
        if ((rt = this.right.check(context)) instanceof ContainerType) {
            rt = ((ContainerType)rt).getItemType();
        }
        switch (this.operator) {
            case CONTAINS: 
            case NOT_CONTAINS: {
                if (lt == TextType.instance() && (rt == TextType.instance() || rt == CharacterType.instance())) break;
                throw new SyntaxError("'contains' only operates on textual values!");
            }
        }
        return BooleanType.instance();
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IValue rval;
        IValue lval = this.left.interpret(context);
        if (lval == null) {
            lval = NullValue.instance();
        }
        if ((rval = this.right.interpret(context)) == null) {
            rval = NullValue.instance();
        }
        return this.interpret(context, lval, rval);
    }

    private IValue interpret(Context context, IValue lval, IValue rval) throws PromptoError {
        boolean equal = false;
        switch (this.operator) {
            case IS: {
                equal = lval == rval;
                break;
            }
            case IS_NOT: {
                equal = lval != rval;
                break;
            }
            case IS_A: {
                equal = this.interpretIsA(context, lval, rval);
                break;
            }
            case IS_NOT_A: {
                equal = !this.interpretIsA(context, lval, rval);
                break;
            }
            case EQUALS: {
                equal = this.interpretEquals(context, lval, rval);
                break;
            }
            case NOT_EQUALS: {
                equal = !this.interpretEquals(context, lval, rval);
                break;
            }
            case ROUGHLY: {
                equal = lval.roughly(context, rval);
                break;
            }
            case CONTAINS: {
                equal = this.interpretContains(context, lval, rval);
                break;
            }
            case NOT_CONTAINS: {
                equal = !this.interpretContains(context, lval, rval);
            }
        }
        return BooleanValue.valueOf(equal);
    }

    private boolean interpretIsA(Context context, IValue lval, IValue rval) throws PromptoError {
        IType actual = lval.getType();
        if (actual == NullType.instance()) {
            return false;
        }
        IType expected = ((TypeValue)rval).getValue();
        return expected.isAssignableFrom(context, actual);
    }

    private boolean interpretEquals(Context context, IValue lval, IValue rval) throws PromptoError {
        if (lval == rval) {
            return true;
        }
        if (lval == NullValue.instance() || rval == NullValue.instance()) {
            return false;
        }
        return lval.equals(rval);
    }

    private boolean interpretContains(Context context, IValue lval, IValue rval) throws PromptoError {
        if (lval == rval) {
            return true;
        }
        if (lval == NullValue.instance() || rval == NullValue.instance()) {
            return false;
        }
        return lval.contains(context, rval);
    }

    public Context downCastForCheck(Context context) {
        try {
            return this.downCast(context, false);
        }
        catch (PromptoError e) {
            throw new RuntimeException("Should never get there!");
        }
    }

    public Context downCastForInterpret(Context context) throws PromptoError {
        return this.downCast(context, true);
    }

    private Context downCast(Context context, boolean setValue) throws PromptoError {
        Identifier name;
        if (this.operator == EqOp.IS_A && (name = this.readLeftName()) != null) {
            INamed value = context.getRegisteredValue(INamed.class, name);
            IType type = ((TypeExpression)this.right).getType();
            Context local = context.newChildContext();
            value = new LinkedVariable(type, value);
            local.registerValue(value, false);
            if (setValue) {
                local.setValue(name, new LinkedValue(context, type));
            }
            context = local;
        }
        return context;
    }

    public Context prepareAutodowncast(Context context, MethodInfo method) {
        Identifier name;
        if (this.operator == EqOp.IS_A && (name = this.readLeftName()) != null) {
            IType type = ((TypeExpression)this.right).getType();
            ClassConstant c = new ClassConstant(type.getJavaType(context));
            StackLocal local = method.getRegisteredLocal(name.toString());
            ((StackLocal.ObjectLocal)local).markForAutodowncast(c);
            return this.downCastForCheck(context);
        }
        return context;
    }

    public void cancelAutodowncast(Context context, MethodInfo method) {
        Identifier name;
        if (this.operator == EqOp.IS_A && (name = this.readLeftName()) != null) {
            StackLocal local = method.getRegisteredLocal(name.toString());
            ((StackLocal.ObjectLocal)local).unmarkForAutodowncast();
        }
    }

    private Identifier readLeftName() {
        if (this.left instanceof InstanceExpression) {
            return ((InstanceExpression)this.left).getId();
        }
        if (this.left instanceof UnresolvedIdentifier) {
            return ((UnresolvedIdentifier)this.left).getId();
        }
        return null;
    }

    @Override
    public boolean interpretAssert(Context context, TestMethodDeclaration test) throws PromptoError {
        IValue rval;
        IValue lval = this.left.interpret(context);
        IValue result = this.interpret(context, lval, rval = this.right.interpret(context));
        if (result == BooleanValue.TRUE) {
            return true;
        }
        String expected = this.buildExpectedMessage(context, test);
        String actual = lval.toString() + " " + this.operator.toString(test.getDialect()) + " " + rval.toString();
        test.printFailedAssertion(context, expected, actual);
        return false;
    }

    private String buildExpectedMessage(Context context, TestMethodDeclaration test) {
        CodeWriter writer = new CodeWriter(test.getDialect(), context);
        this.toDialect(writer);
        return writer.toString();
    }

    @Override
    public void compileAssert(Context context, MethodInfo method, Flags flags, TestMethodDeclaration test) {
        context = context.newChildContext();
        StackState finalState = method.captureStackState();
        IType leftType = this.left.check(context);
        ResultInfo leftInfo = this.left.compile(context, method, flags.withPrimitive(false));
        String leftName = method.nextTransientName("left");
        StackLocal left = method.registerLocal(leftName, IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(leftInfo.getType()));
        CompilerUtils.compileASTORE(method, left);
        IType rightType = this.right.check(context);
        ResultInfo rightInfo = this.right.compile(context, method, flags.withPrimitive(false));
        String rightName = method.nextTransientName("right");
        StackLocal right = method.registerLocal(rightName, IVerifierEntry.VerifierType.ITEM_Object, new ClassConstant(rightInfo.getType()));
        CompilerUtils.compileASTORE(method, right);
        InstanceExpression newLeft = new InstanceExpression(new Identifier(leftName));
        context.registerValue(new Variable(new Identifier(leftName), leftType));
        InstanceExpression newRight = new InstanceExpression(new Identifier(rightName));
        context.registerValue(new Variable(new Identifier(rightName), rightType));
        EqualsExpression newExp = new EqualsExpression(newLeft, this.operator, newRight);
        ResultInfo info = newExp.compile(context, method, flags.withPrimitive(true));
        if (BooleanValue.class == info.getType()) {
            CompilerUtils.BooleanToboolean(method);
        }
        OffsetListenerConstant finalListener = method.addOffsetListener(new OffsetListenerConstant());
        method.activateOffsetListener(finalListener);
        method.addInstruction(Opcode.IFNE, finalListener);
        method.addInstruction(Opcode.ICONST_1, new IOperand[0]);
        method.addInstruction(Opcode.IADD, new IOperand[0]);
        String message = this.buildExpectedMessage(context, test);
        message = test.buildFailedAssertionMessagePrefix(message);
        method.addInstruction(Opcode.LDC, new StringConstant(message));
        CompilerUtils.compileALOAD(method, left);
        MethodConstant stringValueOf = new MethodConstant((Type)((Object)String.class), "valueOf", new Type[]{Object.class, String.class});
        method.addInstruction(Opcode.INVOKESTATIC, stringValueOf);
        MethodConstant concat = new MethodConstant((Type)((Object)String.class), "concat", new Type[]{String.class, String.class});
        method.addInstruction(Opcode.INVOKEVIRTUAL, concat);
        method.addInstruction(Opcode.LDC, new StringConstant(" " + this.operator.toString(test.getDialect()) + " "));
        method.addInstruction(Opcode.INVOKEVIRTUAL, concat);
        CompilerUtils.compileALOAD(method, right);
        method.addInstruction(Opcode.INVOKESTATIC, stringValueOf);
        method.addInstruction(Opcode.INVOKEVIRTUAL, concat);
        test.compileFailure(context, method, flags);
        method.unregisterLocal(right);
        method.unregisterLocal(left);
        method.restoreFullStackState(finalState);
        method.placeLabel(finalState);
        method.inhibitOffsetListener(finalListener);
    }

    @Override
    public void interpretQuery(Context context, IQueryBuilder query, IStore store) throws PromptoError {
        IValue value = null;
        String name = this.readFieldName(this.left);
        if (name != null) {
            value = this.right.interpret(context);
        } else {
            name = this.readFieldName(this.right);
            if (name != null) {
                value = this.left.interpret(context);
            } else {
                throw new SyntaxError("Unable to interpret predicate");
            }
        }
        if (value instanceof IInstance) {
            value = ((IInstance)value).getMember(context, new Identifier("dbId"), false);
        }
        Object data = null;
        if (value != null) {
            data = "dbId".equals(name) ? DataStore.getInstance().convertToDbId(value) : value.getStorableData();
        }
        AttributeInfo info = StoreUtils.getAttributeInfo(context, name, store);
        IQueryBuilder.MatchOp match = this.getMatchOp();
        query.verify(info, match, data);
        if (this.operator == EqOp.NOT_EQUALS || this.operator == EqOp.NOT_CONTAINS) {
            query.not();
        }
    }

    private IQueryBuilder.MatchOp getMatchOp() {
        switch (this.operator) {
            case EQUALS: 
            case NOT_EQUALS: {
                return IQueryBuilder.MatchOp.EQUALS;
            }
            case ROUGHLY: {
                return IQueryBuilder.MatchOp.ROUGHLY;
            }
            case CONTAINS: 
            case NOT_CONTAINS: {
                return IQueryBuilder.MatchOp.CONTAINS;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void compileQuery(Context context, MethodInfo method, Flags flags) {
        boolean reverse = this.compileAttributeInfo(context, method, flags);
        IQueryBuilder.MatchOp match = this.getMatchOp();
        CompilerUtils.compileJavaEnum(context, method, flags, match);
        if (reverse) {
            this.left.compile(context, method, flags);
        } else {
            this.right.compile(context, method, flags);
        }
        InterfaceConstant m = new InterfaceConstant((Type)((Object)IQueryBuilder.class), "verify", new Type[]{AttributeInfo.class, IQueryBuilder.MatchOp.class, Object.class, IQueryBuilder.class});
        method.addInstruction(Opcode.INVOKEINTERFACE, m);
        if (this.operator == EqOp.NOT_EQUALS) {
            m = new InterfaceConstant((Type)((Object)IQueryBuilder.class), "not", new Type[]{IQueryBuilder.class});
            method.addInstruction(Opcode.INVOKEINTERFACE, m);
        }
    }

    private boolean compileAttributeInfo(Context context, MethodInfo method, Flags flags) {
        boolean reverse;
        String name = this.readFieldName(this.left);
        boolean bl = reverse = name == null;
        if (reverse) {
            name = this.readFieldName(this.right);
        }
        AttributeInfo info = context.findAttribute(name).getAttributeInfo(context);
        CompilerUtils.compileAttributeInfo(context, method, flags, info);
        return reverse;
    }

    private String readFieldName(IExpression exp) {
        if (exp instanceof UnresolvedIdentifier || exp instanceof InstanceExpression || exp instanceof MemberSelector) {
            return exp.toString();
        }
        return null;
    }

    private static Map<Class<?>, IOperatorFunction> createEqualsCompilers() {
        HashMap map = new HashMap();
        map.put(Boolean.TYPE, BooleanType::compileEquals);
        map.put(Boolean.class, BooleanType::compileEquals);
        map.put(Character.TYPE, CharacterType::compileEquals);
        map.put(Character.class, CharacterType::compileEquals);
        map.put(String.class, TextType::compileEquals);
        map.put(Double.TYPE, DecimalType::compileEquals);
        map.put(Double.class, DecimalType::compileEquals);
        map.put(Long.TYPE, IntegerType::compileEquals);
        map.put(Long.class, IntegerType::compileEquals);
        map.put(PromptoAny.class, AnyType::compileEquals);
        map.put(PromptoRange.Long.class, RangeType::compileEquals);
        map.put(PromptoRange.Character.class, RangeType::compileEquals);
        map.put(PromptoRange.Date.class, RangeType::compileEquals);
        map.put(PromptoRange.Time.class, RangeType::compileEquals);
        map.put(PromptoDate.class, DateType::compileEquals);
        map.put(PromptoDateTime.class, DateTimeType::compileEquals);
        map.put(PromptoTime.class, TimeType::compileEquals);
        map.put(PromptoPeriod.class, PeriodType::compileEquals);
        map.put(PromptoVersion.class, VersionType::compileEquals);
        map.put(PromptoDict.class, DictType::compileEquals);
        map.put(PromptoSet.class, SetType::compileEquals);
        map.put(PromptoList.class, ListType::compileEquals);
        map.put(UUID.class, UuidType::compileEquals);
        map.put(Object.class, AnyType::compileEquals);
        return map;
    }

    private static Map<Class<?>, IOperatorFunction> createContainsCompilers() {
        HashMap map = new HashMap();
        map.put(String.class, TextType::compileContains);
        return map;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        switch (this.operator) {
            case EQUALS: {
                return this.compileEquals(context, method, flags.withReverse(false));
            }
            case NOT_EQUALS: {
                return this.compileEquals(context, method, flags.withReverse(true));
            }
            case ROUGHLY: {
                return this.compileEquals(context, method, flags.withReverse(false).withRoughly(true));
            }
            case CONTAINS: {
                return this.compileContains(context, method, flags.withReverse(false));
            }
            case NOT_CONTAINS: {
                return this.compileContains(context, method, flags.withReverse(true));
            }
            case IS: {
                return this.compileIs(context, method, flags.withReverse(false));
            }
            case IS_NOT: {
                return this.compileIs(context, method, flags.withReverse(true));
            }
            case IS_A: {
                return this.compileIsA(context, method, flags.withReverse(false));
            }
            case IS_NOT_A: {
                return this.compileIsA(context, method, flags.withReverse(true));
            }
        }
        throw new UnsupportedOperationException();
    }

    private ResultInfo compileIsA(Context context, MethodInfo method, Flags flags) {
        this.right.compile(context, method, flags.withPrimitive(false));
        this.left.compile(context, method, flags.withPrimitive(false));
        MethodConstant m = new MethodConstant((Type)((Object)Class.class), "isInstance", new Type[]{Object.class, Boolean.TYPE});
        method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        if (flags.isReverse()) {
            CompilerUtils.reverseBoolean(method);
        }
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }

    public ResultInfo compileIs(Context context, MethodInfo method, Flags flags) {
        if (this.left.equals(this.right)) {
            method.addInstruction(flags.isReverse() ? Opcode.ICONST_0 : Opcode.ICONST_1, new IOperand[0]);
        } else if (this.left instanceof NullLiteral) {
            this.compileIsNull(context, method, flags, this.right);
        } else if (this.right instanceof NullLiteral) {
            this.compileIsNull(context, method, flags, this.left);
        } else {
            this.compileIsInstance(context, method, flags);
        }
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }

    private void compileIsNull(Context context, MethodInfo method, Flags flags, IExpression value) {
        StackState initialState = method.captureStackState();
        value.compile(context, method, flags.withPrimitive(false));
        Opcode opcode = flags.isReverse() ? Opcode.IFNONNULL : Opcode.IFNULL;
        method.addInstruction(opcode, new ShortOperand(7));
        this.compileIsEpilogue(context, method, flags, initialState);
    }

    private void compileIsEpilogue(Context context, MethodInfo method, Flags flags, StackState initialState) {
        method.addInstruction(Opcode.ICONST_0, new IOperand[0]);
        method.addInstruction(Opcode.GOTO, new ShortOperand(4));
        method.restoreFullStackState(initialState);
        method.placeLabel(initialState);
        method.addInstruction(Opcode.ICONST_1, new IOperand[0]);
        StackState lastState = method.captureStackState();
        method.placeLabel(lastState);
    }

    private void compileIsInstance(Context context, MethodInfo method, Flags flags) {
        StackState initialState = method.captureStackState();
        this.left.compile(context, method, flags.withPrimitive(false));
        this.right.compile(context, method, flags.withPrimitive(false));
        Opcode opcode = flags.isReverse() ? Opcode.IF_ACMPNE : Opcode.IF_ACMPEQ;
        method.addInstruction(opcode, new ShortOperand(7));
        this.compileIsEpilogue(context, method, flags, initialState);
    }

    public ResultInfo compileEquals(Context context, MethodInfo method, Flags flags) {
        ResultInfo lval = this.left.compile(context, method, flags.withPrimitive(true));
        IOperatorFunction compiler = this.getEqualsCompiler(lval.getType());
        if (compiler == null) {
            System.err.println("Missing IOperatorFunction for = " + lval.getType().getTypeName());
            throw new SyntaxError("Cannot check equality of " + lval.getType().getTypeName() + " with " + this.right.check(context).getFamilyInfo(context));
        }
        return compiler.compile(context, method, flags, lval, this.right);
    }

    private IOperatorFunction getEqualsCompiler(Type type) {
        IOperatorFunction function = EQUALS_COMPILERS.get(type);
        if (function == null && CompilerUtils.isEnumNativeType(type)) {
            return NativeSymbol::compileEquals;
        }
        return function;
    }

    public ResultInfo compileContains(Context context, MethodInfo method, Flags flags) {
        ResultInfo lval = this.left.compile(context, method, flags.withPrimitive(true));
        IOperatorFunction compiler = CONTAINS_COMPILERS.get(lval.getType());
        if (compiler == null) {
            System.err.println("Missing IOperatorFunction for 'contains' " + lval.getType().getTypeName());
            throw new SyntaxError("Cannot check that " + lval.getType().getTypeName() + " contains " + this.right.check(context).getFamilyInfo(context));
        }
        return compiler.compile(context, method, flags, lval, this.right);
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.left.declare(transpiler);
        this.right.declare(transpiler);
        if (this.operator == EqOp.ROUGHLY) {
            transpiler.require("removeAccents");
        }
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        switch (this.operator) {
            case EQUALS: {
                this.transpileEquals(transpiler);
                break;
            }
            case NOT_EQUALS: {
                this.transpileNotEquals(transpiler);
                break;
            }
            case ROUGHLY: {
                this.transpileRoughly(transpiler);
                break;
            }
            case CONTAINS: {
                this.transpileContains(transpiler);
                break;
            }
            case NOT_CONTAINS: {
                this.transpileNotContains(transpiler);
                break;
            }
            case IS: {
                this.transpileIs(transpiler);
                break;
            }
            case IS_NOT: {
                this.transpileIsNot(transpiler);
                break;
            }
            case IS_A: {
                this.transpileIsA(transpiler);
                break;
            }
            case IS_NOT_A: {
                this.transpileIsNotA(transpiler);
                break;
            }
            default: {
                throw new Error("Cannot transpile:" + this.operator.toString());
            }
        }
        return false;
    }

    private void transpileIsNotA(Transpiler transpiler) {
        transpiler.append("!(");
        this.transpileIsA(transpiler);
        transpiler.append(")");
    }

    private void transpileIsA(Transpiler transpiler) {
        if (!(this.right instanceof TypeExpression)) {
            throw new Error("Cannot transpile:" + this.right.getClass().getName());
        }
        IType type = ((TypeExpression)this.right).getType();
        if (type == BooleanType.instance()) {
            transpiler.append("isABoolean(");
            this.left.transpile(transpiler);
            transpiler.append(")");
        } else if (type == IntegerType.instance()) {
            transpiler.append("isAnInteger(");
            this.left.transpile(transpiler);
            transpiler.append(")");
        } else if (type == DecimalType.instance()) {
            transpiler.append("isADecimal(");
            this.left.transpile(transpiler);
            transpiler.append(")");
        } else if (type == TextType.instance()) {
            transpiler.append("isAText(");
            this.left.transpile(transpiler);
            transpiler.append(")");
        } else if (type == CharacterType.instance()) {
            transpiler.append("isACharacter(");
            this.left.transpile(transpiler);
            transpiler.append(")");
        } else {
            this.left.transpile(transpiler);
            transpiler.append(" instanceof ");
            this.right.transpile(transpiler);
        }
    }

    private void transpileRoughly(Transpiler transpiler) {
        transpiler.append("removeAccents(");
        this.left.transpile(transpiler);
        transpiler.append(").toLowerCase() === removeAccents(");
        this.right.transpile(transpiler);
        transpiler.append(").toLowerCase()");
    }

    private void transpileIsNot(Transpiler transpiler) {
        this.left.transpile(transpiler);
        transpiler.append(" !== ");
        this.right.transpile(transpiler);
    }

    private void transpileIs(Transpiler transpiler) {
        this.left.transpile(transpiler);
        transpiler.append(" === ");
        this.right.transpile(transpiler);
    }

    private void transpileEquals(Transpiler transpiler) {
        IType lt = this.left.check(transpiler.getContext());
        if (lt == BooleanType.instance() || lt == IntegerType.instance() || lt == DecimalType.instance() || lt == CharacterType.instance() || lt == TextType.instance()) {
            this.left.transpile(transpiler);
            transpiler.append(" === ");
            this.right.transpile(transpiler);
        } else {
            this.left.transpile(transpiler);
            transpiler.append(".equals(");
            this.right.transpile(transpiler);
            transpiler.append(")");
        }
    }

    private void transpileNotEquals(Transpiler transpiler) {
        IType lt = this.left.check(transpiler.getContext());
        if (lt == BooleanType.instance() || lt == IntegerType.instance() || lt == DecimalType.instance() || lt == CharacterType.instance() || lt == TextType.instance()) {
            this.left.transpile(transpiler);
            transpiler.append(" !== ");
            this.right.transpile(transpiler);
        } else {
            transpiler.append("!");
            this.left.transpile(transpiler);
            transpiler.append(".equals(");
            this.right.transpile(transpiler);
            transpiler.append(")");
        }
    }

    private void transpileContains(Transpiler transpiler) {
        this.left.transpile(transpiler);
        transpiler.append(".contains(");
        this.right.transpile(transpiler);
        transpiler.append(")");
    }

    private void transpileNotContains(Transpiler transpiler) {
        transpiler.append("!");
        this.transpileNotContains(transpiler);
    }

    @Override
    public void declareQuery(Transpiler transpiler) {
        transpiler.require("MatchOp");
        this.left.declare(transpiler);
        this.right.declare(transpiler);
    }

    @Override
    public void transpileQuery(Transpiler transpiler, String builderName) {
        IExpression value = null;
        String name = this.readFieldName(this.left);
        if (name != null) {
            value = this.right;
        } else {
            name = this.readFieldName(this.right);
            if (name != null) {
                value = this.left;
            } else {
                throw new SyntaxError("Unable to interpret predicate");
            }
        }
        AttributeDeclaration decl = transpiler.getContext().findAttribute(name);
        AttributeInfo info = decl.getAttributeInfo(transpiler.getContext());
        IQueryBuilder.MatchOp matchOp = this.getMatchOp();
        transpiler.append(builderName).append(".verify(").append(info.toTranspiled()).append(", MatchOp.").append(matchOp.name()).append(", ");
        value.transpile(transpiler);
        transpiler.append(");").newLine();
        if (this.operator == EqOp.NOT_EQUALS) {
            transpiler.append(builderName).append(".not();").newLine();
        }
    }

    @Override
    public void transpileFound(Transpiler transpiler, Dialect dialect) {
        transpiler.append("(");
        this.left.transpile(transpiler);
        transpiler.append(") + ' ").append(this.operator.toString(dialect)).append(" ' + (");
        this.right.transpile(transpiler);
        transpiler.append(")");
    }
}

