/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.lang.reflect.Type;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.declaration.CategoryDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.FetchOneExpression;
import prompto.expression.IExpression;
import prompto.expression.IPredicateExpression;
import prompto.grammar.OrderByClauseList;
import prompto.intrinsic.IterableWithCounts;
import prompto.intrinsic.PromptoRoot;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.store.AttributeInfo;
import prompto.store.IQuery;
import prompto.store.IQueryBuilder;
import prompto.store.IStore;
import prompto.store.IStoredIterable;
import prompto.store.InvalidValueError;
import prompto.transpiler.Transpiler;
import prompto.type.AnyType;
import prompto.type.BaseType;
import prompto.type.BooleanType;
import prompto.type.CategoryType;
import prompto.type.CursorType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.CursorValue;
import prompto.value.IValue;
import prompto.value.IntegerValue;

public class FetchManyExpression
extends FetchOneExpression {
    protected IExpression first;
    protected IExpression last;
    protected OrderByClauseList orderBy;

    public FetchManyExpression(CategoryType type, IExpression first, IExpression last, IExpression filter, OrderByClauseList orderBy) {
        super(type, filter);
        this.first = first;
        this.last = last;
        this.orderBy = orderBy;
    }

    @Override
    public String toString() {
        CodeWriter writer = new CodeWriter(Dialect.E, Context.newGlobalsContext());
        this.toDialect(writer);
        return writer.toString();
    }

    public void setFirst(IExpression first) {
        this.first = first;
    }

    public IExpression getFirst() {
        return this.first;
    }

    public void setLast(IExpression last) {
        this.last = last;
    }

    public IExpression getLast() {
        return this.last;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
    }

    private void toMDialect(CodeWriter writer) {
        writer.append("fetch ");
        if (this.first != null) {
            writer.append("rows ");
            this.first.toDialect(writer);
            writer.append(" to ");
            this.last.toDialect(writer);
            writer.append(" ");
        } else {
            writer.append("all ");
        }
        writer.append("( ");
        if (this.type != null) {
            this.type.toDialect(writer);
            writer.append(" ");
        }
        writer.append(") ");
        if (this.predicate != null) {
            writer.append("where ");
            this.predicate.toDialect(writer);
            writer.append(" ");
        }
        if (this.orderBy != null) {
            this.orderBy.toDialect(writer);
        }
    }

    private void toODialect(CodeWriter writer) {
        writer.append("fetch ");
        if (this.first == null) {
            writer.append("all ");
        }
        if (this.type != null) {
            writer.append("( ");
            this.type.toDialect(writer);
            writer.append(" ) ");
        }
        if (this.first != null) {
            writer.append("rows ( ");
            this.first.toDialect(writer);
            writer.append(" to ");
            this.last.toDialect(writer);
            writer.append(") ");
        }
        if (this.predicate != null) {
            writer.append(" where ( ");
            this.predicate.toDialect(writer);
            writer.append(") ");
        }
        if (this.orderBy != null) {
            this.orderBy.toDialect(writer);
        }
    }

    private void toEDialect(CodeWriter writer) {
        writer.append("fetch ");
        if (this.first == null) {
            writer.append("all ");
        }
        if (this.type != null) {
            this.type.toDialect(writer);
            writer.append(" ");
        }
        if (this.first != null) {
            this.first.toDialect(writer);
            writer.append(" to ");
            this.last.toDialect(writer);
            writer.append(" ");
        }
        if (this.predicate != null) {
            writer.append("where ");
            this.predicate.toDialect(writer);
        }
        if (this.orderBy != null) {
            writer.append(" ");
            this.orderBy.toDialect(writer);
        }
    }

    @Override
    public IType check(Context context) {
        BaseType type = this.type;
        if (type == null) {
            type = AnyType.instance();
        } else {
            CategoryDeclaration decl = context.getRegisteredDeclaration(CategoryDeclaration.class, type.getTypeNameId());
            if (decl == null) {
                throw new SyntaxError("Expecting a type type !");
            }
            if (!decl.isStorable(context)) {
                context.getProblemListener().reportNotStorable(this, type.getTypeName());
            }
            context = context.newInstanceContext(decl.getType(context), true);
        }
        this.checkPredicate(context);
        this.checkOrderBy(context);
        this.checkSlice(context);
        return new CursorType(type);
    }

    private void checkSlice(Context context) {
    }

    private void checkOrderBy(Context context) {
    }

    private void checkPredicate(Context context) {
        if (this.predicate == null) {
            return;
        }
        if (!(this.predicate instanceof IPredicateExpression)) {
            throw new SyntaxError("Filtering expression must be a predicate !");
        }
        IType filterType = this.predicate.check(context);
        if (filterType != BooleanType.instance()) {
            throw new SyntaxError("Filtering expression must return a boolean !");
        }
    }

    @Override
    public Object fetchRaw(IStore store) {
        IQuery query = this.buildFetchManyQuery(Context.newGlobalsContext(), store);
        return store.fetchMany(query);
    }

    @Override
    public IValue fetch(Context context, IStore store) throws PromptoError {
        IQuery query = this.buildFetchManyQuery(context, store);
        IStoredIterable docs = store.fetchMany(query);
        BaseType type = this.type == null ? AnyType.instance() : this.type;
        return new CursorValue(context, type, docs);
    }

    private IQuery buildFetchManyQuery(Context context, IStore store) {
        IQueryBuilder builder = store.newQueryBuilder();
        if (this.type != null) {
            AttributeInfo info = AttributeInfo.CATEGORY;
            builder.verify(info, IQueryBuilder.MatchOp.HAS, this.type.getTypeName());
        }
        if (this.predicate != null) {
            if (!(this.predicate instanceof IPredicateExpression)) {
                throw new SyntaxError("Filtering expression must be a predicate !");
            }
            ((IPredicateExpression)this.predicate).interpretQuery(context, builder, store);
        }
        if (this.type != null && this.predicate != null) {
            builder.and();
        }
        builder.first(this.interpretLimit(context, this.first));
        builder.last(this.interpretLimit(context, this.last));
        if (this.orderBy != null) {
            this.orderBy.interpretQuery(context, builder);
        }
        return builder.build();
    }

    private Long interpretLimit(Context context, IExpression exp) throws PromptoError {
        if (exp == null) {
            return null;
        }
        IValue value = exp.interpret(context);
        if (!(value instanceof IntegerValue)) {
            throw new InvalidValueError("Expecting an Integer, got:" + value.getType().toString());
        }
        return ((IntegerValue)value).longValue();
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        this.compileNewQueryBuilder(context, method, flags);
        this.compilePredicates(context, method, flags);
        this.compileLimits(context, method, flags);
        this.compileOrderBy(context, method, flags);
        this.compileBuildQuery(context, method, flags);
        this.compileFetchMany(context, method, flags);
        return this.compileInstantiation(context, method, flags);
    }

    private void compileOrderBy(Context context, MethodInfo method, Flags flags) {
        if (this.orderBy != null) {
            this.orderBy.compileQuery(context, method, flags);
        }
    }

    private void compileLimits(Context context, MethodInfo method, Flags flags) {
        InterfaceConstant i;
        ResultInfo info;
        if (this.first != null) {
            info = this.first.compile(context, method, flags.withPrimitive(false));
            if (Long.TYPE == info.getType()) {
                CompilerUtils.longToLong(method);
            }
            i = new InterfaceConstant((Type)((Object)IQueryBuilder.class), "first", new Type[]{Long.class, IQueryBuilder.class});
            method.addInstruction(Opcode.INVOKEINTERFACE, i);
        }
        if (this.last != null) {
            info = this.last.compile(context, method, flags.withPrimitive(false));
            if (Long.TYPE == info.getType()) {
                CompilerUtils.longToLong(method);
            }
            i = new InterfaceConstant((Type)((Object)IQueryBuilder.class), "last", new Type[]{Long.class, IQueryBuilder.class});
            method.addInstruction(Opcode.INVOKEINTERFACE, i);
        }
    }

    private void compileFetchMany(Context context, MethodInfo method, Flags flags) {
        InterfaceConstant i = new InterfaceConstant((Type)((Object)IStore.class), "fetchMany", new Type[]{IQuery.class, IStoredIterable.class});
        method.addInstruction(Opcode.INVOKEINTERFACE, i);
    }

    private ResultInfo compileInstantiation(Context context, MethodInfo method, Flags flags) {
        MethodConstant m = new MethodConstant((Type)((Object)PromptoRoot.class), "newIterable", new Type[]{IStoredIterable.class, IterableWithCounts.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        return new ResultInfo((Type)((Object)IterableWithCounts.class), new ResultInfo.Flag[0]);
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("Cursor");
        transpiler.require("MatchOp");
        transpiler.require("DataStore");
        transpiler.require("AttributeInfo");
        transpiler.require("TypeFamily");
        if (this.type != null) {
            this.type.declare(transpiler);
        }
        if (this.predicate != null) {
            this.predicate.declare(transpiler);
        }
        if (this.first != null) {
            this.first.declare(transpiler);
        }
        if (this.last != null) {
            this.last.declare(transpiler);
        }
        if (this.orderBy != null) {
            this.orderBy.declare(transpiler);
        }
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("(function() {").indent();
        this.transpileQuery(transpiler);
        boolean mutable = this.type != null ? this.type.isMutable() : false;
        transpiler.append("return $DataStore.instance.fetchMany(builder.build(),").append(mutable).append(");").newLine().dedent();
        transpiler.append("})()");
        return false;
    }

    @Override
    protected void transpileQuery(Transpiler transpiler) {
        transpiler.append("var builder = $DataStore.instance.newQueryBuilder();").newLine();
        if (this.type != null) {
            transpiler.append("builder.verify(new AttributeInfo('category', TypeFamily.TEXT, true, null), MatchOp.HAS, '").append(this.type.getTypeName()).append("');").newLine();
        }
        if (this.predicate != null) {
            this.predicate.transpileQuery(transpiler, "builder");
        }
        if (this.type != null && this.predicate != null) {
            transpiler.append("builder.and();").newLine();
        }
        if (this.first != null) {
            transpiler.append("builder.setFirst(");
            this.first.transpile(transpiler);
            transpiler.append(");").newLine();
        }
        if (this.last != null) {
            transpiler.append("builder.setLast(");
            this.last.transpile(transpiler);
            transpiler.append(");").newLine();
        }
        if (this.orderBy != null) {
            this.orderBy.transpileQuery(transpiler, "builder");
        }
    }
}

