/*
 * Decompiled with CFR 0.152.
 */
package prompto.expression;

import java.lang.reflect.Type;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StringConstant;
import prompto.declaration.CategoryDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.expression.IFetchExpression;
import prompto.expression.IPredicateExpression;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoList;
import prompto.intrinsic.PromptoRoot;
import prompto.parser.Dialect;
import prompto.parser.Section;
import prompto.runtime.Context;
import prompto.statement.UnresolvedCall;
import prompto.store.AttributeInfo;
import prompto.store.DataStore;
import prompto.store.IQuery;
import prompto.store.IQueryBuilder;
import prompto.store.IStore;
import prompto.store.IStored;
import prompto.transpiler.Transpiler;
import prompto.type.AnyType;
import prompto.type.BooleanType;
import prompto.type.CategoryType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;
import prompto.value.NullValue;

public class FetchOneExpression
extends Section
implements IFetchExpression {
    protected CategoryType type;
    protected IExpression predicate;

    public FetchOneExpression(CategoryType type, IExpression predicate) {
        this.type = type;
        this.predicate = predicate;
    }

    public String toString() {
        CodeWriter writer = new CodeWriter(Dialect.E, Context.newGlobalsContext());
        this.toDialect(writer);
        return writer.toString();
    }

    public CategoryType getType() {
        return this.type;
    }

    public IPredicateExpression getPredicate(Context context) {
        IExpression predicate = this.predicate;
        if (predicate instanceof UnresolvedCall) {
            predicate = ((UnresolvedCall)predicate).resolve(context);
        }
        return (IPredicateExpression)predicate;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        switch (writer.getDialect()) {
            case E: {
                writer.append("fetch one ");
                if (this.type != null) {
                    this.type.toDialect(writer);
                    writer.append(" ");
                }
                writer.append("where ");
                this.predicate.toDialect(writer);
                break;
            }
            case O: {
                writer.append("fetch one ");
                if (this.type != null) {
                    writer.append("(");
                    this.type.toDialect(writer);
                    writer.append(") ");
                }
                writer.append("where (");
                this.predicate.toDialect(writer);
                writer.append(")");
                break;
            }
            case M: {
                writer.append("fetch one ");
                if (this.type != null) {
                    this.type.toDialect(writer);
                    writer.append(" ");
                }
                writer.append("where ");
                this.predicate.toDialect(writer);
            }
        }
    }

    @Override
    public IType check(Context context) {
        if (this.type != null) {
            CategoryDeclaration decl = context.getRegisteredDeclaration(CategoryDeclaration.class, this.type.getTypeNameId());
            if (decl == null) {
                context.getProblemListener().reportUnknownCategory(this.type, this.type.getTypeName());
            }
            if (!decl.isStorable(context)) {
                context.getProblemListener().reportNotStorable(this, this.type.getTypeName());
            }
            context = context.newInstanceContext(decl.getType(context), true);
        }
        if (!(this.predicate instanceof IPredicateExpression)) {
            throw new SyntaxError("Filtering expression must be a predicate !");
        }
        IType filterType = this.predicate.check(context);
        if (filterType != BooleanType.instance()) {
            throw new SyntaxError("Filtering expression must return a boolean !");
        }
        return this.type != null ? this.type : AnyType.instance();
    }

    @Override
    public Object fetchRaw(IStore store) {
        IQuery query = this.buildFetchOneQuery(Context.newGlobalsContext(), store);
        return store.fetchOne(query);
    }

    @Override
    public IValue fetch(Context context, IStore store) throws PromptoError {
        IQuery query = this.buildFetchOneQuery(context, store);
        IStored stored = store.fetchOne(query);
        if (stored == null) {
            return NullValue.instance();
        }
        PromptoList categories = (PromptoList)stored.getData("category");
        String actualTypeName = (String)categories.getLast();
        CategoryType type = new CategoryType(new Identifier(actualTypeName));
        if (this.type != null) {
            type.setMutable(this.type.isMutable());
        }
        return type.newInstance(context, stored);
    }

    public IQuery buildFetchOneQuery(Context context, IStore store) {
        IQueryBuilder builder = store.newQueryBuilder();
        if (this.type != null) {
            builder.verify(AttributeInfo.CATEGORY, IQueryBuilder.MatchOp.HAS, this.type.getTypeName());
        }
        if (this.predicate != null) {
            if (!(this.predicate instanceof IPredicateExpression)) {
                throw new SyntaxError("Filtering expression must be a predicate !");
            }
            ((IPredicateExpression)this.predicate).interpretQuery(context, builder, store);
        }
        if (this.type != null && this.predicate != null) {
            builder.and();
        }
        return builder.build();
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        this.compileNewQueryBuilder(context, method, flags);
        this.compilePredicates(context, method, flags);
        this.compileBuildQuery(context, method, flags);
        this.compileFetchOne(context, method, flags);
        return this.compileInstantiation(context, method, flags);
    }

    protected void compileBuildQuery(Context context, MethodInfo method, Flags flags) {
        InterfaceConstant i = new InterfaceConstant((Type)((Object)IQueryBuilder.class), "build", new Type[]{IQuery.class});
        method.addInstruction(Opcode.INVOKEINTERFACE, i);
    }

    private ResultInfo compileInstantiation(Context context, MethodInfo method, Flags flags) {
        MethodConstant m = new MethodConstant((Type)((Object)PromptoRoot.class), "newInstance", new Type[]{IStored.class, PromptoRoot.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        if (this.type != null) {
            method.addInstruction(Opcode.CHECKCAST, new ClassConstant(this.type.getJavaType(context)));
            return new ResultInfo(this.type.getJavaType(context), new ResultInfo.Flag[0]);
        }
        return new ResultInfo(AnyType.instance().getJavaType(context), new ResultInfo.Flag[0]);
    }

    protected void compileFetchOne(Context context, MethodInfo method, Flags flags) {
        InterfaceConstant i = new InterfaceConstant((Type)((Object)IStore.class), "fetchOne", new Type[]{IQuery.class, IStored.class});
        method.addInstruction(Opcode.INVOKEINTERFACE, i);
    }

    protected void compilePredicates(Context context, MethodInfo method, Flags flags) {
        if (this.type != null) {
            AttributeInfo info = AttributeInfo.CATEGORY;
            CompilerUtils.compileAttributeInfo(context, method, flags, info);
            CompilerUtils.compileJavaEnum(context, method, flags, IQueryBuilder.MatchOp.HAS);
            method.addInstruction(Opcode.LDC, new StringConstant(this.type.toString()));
            InterfaceConstant i = new InterfaceConstant((Type)((Object)IQueryBuilder.class), "verify", new Type[]{AttributeInfo.class, IQueryBuilder.MatchOp.class, Object.class, IQueryBuilder.class});
            method.addInstruction(Opcode.INVOKEINTERFACE, i);
        }
        if (this.predicate != null) {
            ((IPredicateExpression)this.predicate).compileQuery(context, method, flags);
        }
        if (this.type != null && this.predicate != null) {
            InterfaceConstant i = new InterfaceConstant((Type)((Object)IQueryBuilder.class), "and", new Type[]{IQueryBuilder.class});
            method.addInstruction(Opcode.INVOKEINTERFACE, i);
        }
    }

    protected void compileNewQueryBuilder(Context context, MethodInfo method, Flags flags) {
        MethodConstant m = new MethodConstant((Type)((Object)DataStore.class), "getInstance", new Type[]{IStore.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        InterfaceConstant i = new InterfaceConstant((Type)((Object)IStore.class), "newQueryBuilder", new Type[]{IQueryBuilder.class});
        method.addInstruction(Opcode.INVOKEINTERFACE, i);
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("MatchOp");
        transpiler.require("DataStore");
        transpiler.require("AttributeInfo");
        transpiler.require("TypeFamily");
        transpiler.require("NativeError");
        if (this.type != null) {
            this.type.declare(transpiler);
        }
        if (this.predicate != null) {
            this.predicate.declareQuery(transpiler);
        }
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("(function() {").indent();
        this.transpileQuery(transpiler);
        transpiler.append("var $stored = $DataStore.instance.fetchOne(builder.build());").newLine();
        this.transpileConvert(transpiler, "result");
        transpiler.append("return result;").dedent();
        transpiler.append("})()");
        return false;
    }

    protected void transpileConvert(Transpiler transpiler, String varName) {
        transpiler.append("if($stored===null)").indent().append("return null;").dedent();
        transpiler.append("var $name = $stored.getData('category').slice(-1)[0];").newLine();
        transpiler.append("var $type = eval($name);").newLine();
        transpiler.append("var ").append(varName).append(" = new $type(null, {}, ").append(this.type != null && this.type.isMutable()).append(");").newLine();
        transpiler.append(varName).append(".fromStored($stored);").newLine();
    }

    protected void transpileQuery(Transpiler transpiler) {
        transpiler.append("var builder = $DataStore.instance.newQueryBuilder();").newLine();
        if (this.type != null) {
            transpiler.append("builder.verify(new AttributeInfo('category', TypeFamily.TEXT, true, null), MatchOp.HAS, '").append(this.type.getTypeName()).append("');").newLine();
        }
        if (this.predicate != null) {
            this.predicate.transpileQuery(transpiler, "builder");
        }
        if (this.type != null && this.predicate != null) {
            transpiler.append("builder.and();").newLine();
        }
    }
}

